/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;

public final class JSRegExp
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSRegExp INSTANCE = new JSRegExp();
    public static final String CLASS_NAME = "RegExp";
    public static final String PROTOTYPE_NAME = "RegExp.prototype";
    public static final String MULTILINE = "multiline";
    public static final String GLOBAL = "global";
    public static final String IGNORE_CASE = "ignoreCase";
    public static final String STICKY = "sticky";
    public static final String UNICODE = "unicode";
    public static final String DOT_ALL = "dotAll";
    public static final String SOURCE = "source";
    public static final String FLAGS = "flags";
    public static final String LAST_INDEX = "lastIndex";
    public static final String INPUT = "input";
    public static final String GROUPS = "groups";
    public static final String INDEX = "index";
    public static final String INDICES = "indices";
    private static final HiddenKey COMPILED_REGEX_ID = new HiddenKey("compiledRegex");
    private static final Property COMPILED_REGEX_PROPERTY;
    private static final HiddenKey GROUPS_FACTORY_ID;
    private static final Property GROUPS_FACTORY_PROPERTY;
    private static final HiddenKey REALM_ID;
    private static final Property REALM_PROPERTY;
    private static final HiddenKey LEGACY_FEATURES_ENABLED_ID;
    private static final Property LEGACY_FEATURES_ENABLED_PROPERTY;
    private static final Property LAZY_INDEX_PROXY;
    public static final HiddenKey GROUPS_RESULT_ID;
    public static final HiddenKey GROUPS_ORIGINAL_INPUT_ID;
    public static final HiddenKey GROUPS_IS_INDICES_ID;
    private static final Property GROUPS_RESULT_PROPERTY;
    private static final Property GROUPS_ORIGINAL_INPUT_PROPERTY;
    private static final Property GROUPS_IS_INDICES_PROPERTY;
    private static final Comparator<Pair<Integer, String>> NAMED_GROUPS_COMPARATOR;

    private JSRegExp() {
    }

    public static Object getCompiledRegex(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return COMPILED_REGEX_PROPERTY.get(thisObj, JSRegExp.isJSRegExp(thisObj));
    }

    public static Object getCompiledRegexUnchecked(DynamicObject thisObj, boolean guard) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return COMPILED_REGEX_PROPERTY.get(thisObj, guard);
    }

    public static JSObjectFactory getGroupsFactory(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return (JSObjectFactory)GROUPS_FACTORY_PROPERTY.get(thisObj, JSRegExp.isJSRegExp(thisObj));
    }

    public static JSObjectFactory getGroupsFactoryUnchecked(DynamicObject thisObj, boolean guard) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return (JSObjectFactory)GROUPS_FACTORY_PROPERTY.get(thisObj, guard);
    }

    public static Object getRealm(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return REALM_PROPERTY.get(thisObj, JSRegExp.isJSRegExp(thisObj));
    }

    public static Object getRealmUnchecked(DynamicObject thisObj, boolean guard) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return REALM_PROPERTY.get(thisObj, guard);
    }

    public static boolean getLegacyFeaturesEnabled(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return (Boolean)LEGACY_FEATURES_ENABLED_PROPERTY.get(thisObj, JSRegExp.isJSRegExp(thisObj));
    }

    public static boolean getLegacyFeaturesEnabledUnchecked(DynamicObject thisObj, boolean guard) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return (Boolean)LEGACY_FEATURES_ENABLED_PROPERTY.get(thisObj, guard);
    }

    public static DynamicObject create(JSContext ctx, Object compiledRegex) {
        DynamicObject obj = JSRegExp.create(ctx, compiledRegex, JSRegExp.computeGroupsFactory(ctx, compiledRegex));
        JSObjectUtil.putDataProperty(ctx, obj, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        return obj;
    }

    public static DynamicObject create(JSContext ctx, Object compiledRegex, JSObjectFactory groupsFactory) {
        return JSRegExp.create(ctx, compiledRegex, groupsFactory, true);
    }

    public static DynamicObject create(JSContext ctx, Object compiledRegex, JSObjectFactory groupsFactory, boolean legacyFeaturesEnabled) {
        DynamicObject regExp = JSObject.create(ctx, ctx.getRegExpFactory(), compiledRegex, groupsFactory, ctx.getRealm(), legacyFeaturesEnabled);
        assert (JSRegExp.isJSRegExp(regExp));
        return regExp;
    }

    private static void initialize(JSContext ctx, DynamicObject regExp, Object regex) {
        COMPILED_REGEX_PROPERTY.setSafe(regExp, regex, null);
        GROUPS_FACTORY_PROPERTY.setSafe(regExp, (Object)JSRegExp.computeGroupsFactory(ctx, regex), null);
    }

    public static void updateCompilation(JSContext ctx, DynamicObject thisObj, Object regex) {
        assert (JSRegExp.isJSRegExp(thisObj) && regex != null);
        JSRegExp.initialize(ctx, thisObj, regex);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSObjectFactory computeGroupsFactory(JSContext ctx, Object compiledRegex) {
        Object namedCaptureGroups = TRegexUtil.InteropReadMemberNode.getUncached().execute(compiledRegex, GROUPS);
        if (TRegexUtil.InteropIsNullNode.getUncached().execute(namedCaptureGroups)) {
            return null;
        }
        return JSRegExp.buildGroupsFactory(ctx, namedCaptureGroups);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObjectFactory buildGroupsFactory(JSContext ctx, Object namedCaptureGroups) {
        Shape groupsShape = ctx.getEmptyShapeNullPrototype();
        groupsShape = groupsShape.addProperty(GROUPS_RESULT_PROPERTY);
        groupsShape = groupsShape.addProperty(GROUPS_ORIGINAL_INPUT_PROPERTY);
        groupsShape = groupsShape.addProperty(GROUPS_IS_INDICES_PROPERTY);
        List<Object> keys = JSInteropUtil.keys(namedCaptureGroups);
        ArrayList<Pair<Integer, String>> pairs = new ArrayList<Pair<Integer, String>>(keys.size());
        for (Object object : keys) {
            String groupName = (String)object;
            int groupIndex = TRegexUtil.InteropReadIntMemberNode.getUncached().execute(namedCaptureGroups, groupName);
            pairs.add(new Pair<Integer, String>(groupIndex, groupName));
        }
        Collections.sort(pairs, NAMED_GROUPS_COMPARATOR);
        for (Pair pair : pairs) {
            int groupIndex = (Integer)pair.getFirst();
            String groupName = (String)pair.getSecond();
            Property groupProperty = JSObjectUtil.makeProxyProperty(groupName, new LazyNamedCaptureGroupProperty(groupName, groupIndex), JSAttributes.getDefault());
            groupsShape = groupsShape.addProperty(groupProperty);
        }
        return JSObjectFactory.createBound(ctx, Null.instance, groupsShape.createFactory());
    }

    @CompilerDirectives.TruffleBoundary
    public static String prototypeToString(DynamicObject thisObj) {
        Object regex = JSRegExp.getCompiledRegex(thisObj);
        TRegexUtil.InteropReadStringMemberNode readString = TRegexUtil.InteropReadStringMemberNode.getUncached();
        String pattern = readString.execute(regex, "pattern");
        if (pattern.length() == 0) {
            pattern = "(?:)";
        }
        String flags = readString.execute(TRegexUtil.InteropReadMemberNode.getUncached().execute(regex, FLAGS), SOURCE);
        return "/" + pattern + '/' + flags;
    }

    public static boolean isJSRegExp(Object obj) {
        return JSObject.isDynamicObject(obj) && JSRegExp.isJSRegExp((DynamicObject)obj);
    }

    public static boolean isJSRegExp(DynamicObject obj) {
        return JSRegExp.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)(ctx.getEcmaScriptVersion() < 6 ? INSTANCE : JSUserObject.INSTANCE));
        if (ctx.getEcmaScriptVersion() < 6) {
            JSObjectUtil.putHiddenProperty(prototype, COMPILED_REGEX_PROPERTY, JSRegExp.compileEarly(realm, "", ""));
            JSObjectUtil.putDataProperty(ctx, prototype, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        }
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, SOURCE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, FLAGS);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, MULTILINE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, GLOBAL);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, IGNORE_CASE);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, STICKY);
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, UNICODE);
        }
        if (ctx.getEcmaScriptVersion() >= 9) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, DOT_ALL);
        }
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, RegExpPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    private static void putRegExpPropertyAccessor(JSRealm realm, DynamicObject prototype, String name) {
        DynamicObject getter = realm.lookupFunction(RegExpPrototypeBuiltins.RegExpPrototypeGetterBuiltins.BUILTINS, name);
        JSObjectUtil.putConstantAccessorProperty(realm.getContext(), prototype, name, getter, Undefined.instance);
    }

    private static Object compileEarly(JSRealm realm, String pattern, String flags) {
        return TRegexUtil.CompileRegexNode.getUncached().execute(JSContext.createTRegexEngine(realm.getEnv(), realm.getContext().getContextOptions()), pattern, flags);
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject thisObj) {
        return JSObjectUtil.getProtoChildShape(thisObj, INSTANCE, ctx).addProperty(COMPILED_REGEX_PROPERTY).addProperty(GROUPS_FACTORY_PROPERTY).addProperty(REALM_PROPERTY).addProperty(LEGACY_FEATURES_ENABLED_PROPERTY);
    }

    public static Shape makeLazyRegexArrayShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSArray.INSTANCE.makeInitialShape(ctx, prototype);
        initialShape = initialShape.addProperty(JSAbstractArray.LAZY_REGEX_RESULT_PROPERTY);
        initialShape = initialShape.addProperty(JSAbstractArray.LAZY_REGEX_ORIGINAL_INPUT_PROPERTY);
        Property inputProperty = JSObjectUtil.makeDataProperty(INPUT, initialShape.allocator().locationForType(String.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.getDefault());
        initialShape = initialShape.addProperty(inputProperty);
        initialShape = initialShape.addProperty(LAZY_INDEX_PROXY);
        initialShape = initialShape.addProperty(JSObjectUtil.makeDataProperty(GROUPS, initialShape.allocator().locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), JSAttributes.getDefault()));
        if (ctx.isOptionRegexpMatchIndices()) {
            initialShape = initialShape.addProperty(JSObjectUtil.makeDataProperty(INDICES, initialShape.allocator().locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), JSAttributes.getDefault()));
        }
        return initialShape;
    }

    public static Shape makeLazyRegexIndicesArrayShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSArray.INSTANCE.makeInitialShape(ctx, prototype);
        initialShape = initialShape.addProperty(JSAbstractArray.LAZY_REGEX_RESULT_PROPERTY);
        initialShape = initialShape.addProperty(JSObjectUtil.makeDataProperty(GROUPS, initialShape.allocator().locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), JSAttributes.getDefault()));
        return initialShape;
    }

    @Override
    public void fillConstructor(JSRealm realm, DynamicObject constructor) {
        JSRegExp.putConstructorSpeciesGetter(realm, constructor);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return "[RegExp " + JSRegExp.prototypeToString(obj) + "]";
        }
        return JSRegExp.prototypeToString(obj);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getRegExpPrototype();
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence escapeRegExpPattern(CharSequence pattern) {
        if (pattern.length() == 0) {
            return "(?:)";
        }
        int extraChars = JSRegExp.escapeRegExpExtraCharCount(pattern);
        if (extraChars == 0) {
            return pattern;
        }
        return JSRegExp.escapeRegExpPattern(pattern, extraChars);
    }

    private static int escapeRegExpExtraCharCount(CharSequence pattern) {
        int extraChars = 0;
        boolean insideCharClass = false;
        block12: for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '\\': {
                    assert (i + 1 < pattern.length());
                    switch (pattern.charAt(++i)) {
                        case '\n': 
                        case '\r': {
                            extraChars = Math.max(extraChars, 1);
                            break;
                        }
                        case '\u2028': 
                        case '\u2029': {
                            extraChars += 4;
                        }
                    }
                    continue block12;
                }
                case '\n': 
                case '\r': {
                    ++extraChars;
                    continue block12;
                }
                case '\u2028': 
                case '\u2029': {
                    extraChars += 5;
                    continue block12;
                }
                case '/': {
                    if (insideCharClass) continue block12;
                    ++extraChars;
                    continue block12;
                }
                case '[': {
                    insideCharClass = true;
                    continue block12;
                }
                case ']': {
                    insideCharClass = false;
                }
            }
        }
        return extraChars;
    }

    @CompilerDirectives.TruffleBoundary
    private static String escapeRegExpPattern(CharSequence pattern, int extraChars) {
        StringBuilder sb = new StringBuilder(pattern.length() + extraChars);
        boolean insideCharClass = false;
        block16: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    assert (i + 1 < pattern.length());
                    sb.append(c);
                    c = pattern.charAt(++i);
                    switch (c) {
                        case '\n': {
                            sb.append('n');
                            continue block16;
                        }
                        case '\r': {
                            sb.append('r');
                            continue block16;
                        }
                        case '\u2028': {
                            sb.append("u2028");
                            continue block16;
                        }
                        case '\u2029': {
                            sb.append("u2029");
                            continue block16;
                        }
                    }
                    sb.append(c);
                    continue block16;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block16;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block16;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block16;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block16;
                }
                case '/': {
                    if (!insideCharClass) {
                        sb.append("\\/");
                        continue block16;
                    }
                    sb.append('/');
                    continue block16;
                }
                case '[': {
                    insideCharClass = true;
                    sb.append(c);
                    continue block16;
                }
                case ']': {
                    insideCharClass = false;
                    sb.append(c);
                    continue block16;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static {
        GROUPS_FACTORY_ID = new HiddenKey("groupsFactory");
        REALM_ID = new HiddenKey("realm");
        LEGACY_FEATURES_ENABLED_ID = new HiddenKey("legacyFeaturesEnabled");
        LAZY_INDEX_PROXY = JSObjectUtil.makeProxyProperty(INDEX, new LazyRegexResultIndexProxyProperty(), JSAttributes.getDefault());
        GROUPS_RESULT_ID = new HiddenKey("regexResult");
        GROUPS_ORIGINAL_INPUT_ID = new HiddenKey("regexResultOriginalIndex");
        GROUPS_IS_INDICES_ID = new HiddenKey("isIndices");
        Shape.Allocator regExpAllocator = JSShape.makeAllocator(JSObject.LAYOUT);
        regExpAllocator.addLocation(JSObject.PROTO_PROPERTY.getLocation());
        COMPILED_REGEX_PROPERTY = JSObjectUtil.makeHiddenProperty(COMPILED_REGEX_ID, regExpAllocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)));
        GROUPS_FACTORY_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_FACTORY_ID, regExpAllocator.locationForType(JSObjectFactory.class));
        REALM_PROPERTY = JSObjectUtil.makeHiddenProperty(REALM_ID, regExpAllocator.locationForType(JSRealm.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        LEGACY_FEATURES_ENABLED_PROPERTY = JSObjectUtil.makeHiddenProperty(LEGACY_FEATURES_ENABLED_ID, regExpAllocator.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        Shape.Allocator resultAllocator = JSShape.makeAllocator(JSObject.LAYOUT);
        GROUPS_RESULT_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_RESULT_ID, resultAllocator.locationForType(Object.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        GROUPS_ORIGINAL_INPUT_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_ORIGINAL_INPUT_ID, resultAllocator.locationForType(String.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        GROUPS_IS_INDICES_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_IS_INDICES_ID, resultAllocator.locationForType(Boolean.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        NAMED_GROUPS_COMPARATOR = new Comparator<Pair<Integer, String>>(){

            @Override
            public int compare(Pair<Integer, String> group1, Pair<Integer, String> group2) {
                return group1.getFirst() - group2.getFirst();
            }
        };
    }

    public static class LazyNamedCaptureGroupProperty
    implements PropertyProxy {
        private final String groupName;
        private final int groupIndex;
        private final ConditionProfile isIndicesObject = ConditionProfile.createBinaryProfile();
        private final TRegexUtil.TRegexMaterializeResultNode materializeNode = TRegexUtil.TRegexMaterializeResultNode.getUncached();

        public LazyNamedCaptureGroupProperty(String groupName, int groupIndex) {
            this.groupName = groupName;
            this.groupIndex = groupIndex;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        @Override
        public Object get(DynamicObject object) {
            Object regexResult = GROUPS_RESULT_PROPERTY.get(object, false);
            if (this.isIndicesObject.profile(((Boolean)GROUPS_IS_INDICES_PROPERTY.get(object, false)).booleanValue())) {
                return LazyRegexResultIndicesArray.getIntIndicesArray(JavaScriptLanguage.getCurrentJSRealm().getContext(), TRegexUtil.TRegexResultAccessor.getUncached(), regexResult, this.groupIndex);
            }
            String input = (String)GROUPS_ORIGINAL_INPUT_PROPERTY.get(object, false);
            return this.materializeNode.materializeGroup(regexResult, this.groupIndex, input);
        }

        @Override
        public boolean set(DynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, this.groupName, value, JSAttributes.getDefault());
            return true;
        }
    }

    public static class LazyRegexResultIndexProxyProperty
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject object) {
            return TRegexUtil.InvokeGetGroupBoundariesMethodNode.getUncached().execute(JSAbstractArray.arrayGetRegexResult(object), "getStart", 0);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(DynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, JSRegExp.INDEX, value, JSAttributes.getDefault());
            return true;
        }
    }
}

