/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.List;

public final class HolesObjectArray
extends AbstractContiguousObjectArray {
    private static final HolesObjectArray HOLES_OBJECT_ARRAY = new HolesObjectArray(0, HolesObjectArray.createCache());

    private HolesObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static HolesObjectArray makeHolesObjectArray(DynamicObject object, int length, Object[] array, long indexOffset, int arrayOffset, int usedLength, int holeCount, int integrityLevel) {
        HolesObjectArray arrayType = (HolesObjectArray)HolesObjectArray.createHolesObjectArray().setIntegrityLevel(integrityLevel);
        HolesObjectArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        JSAbstractArray.arraySetHoleCount(object, holeCount);
        assert (holeCount == arrayType.countHoles(object)) : String.format("holeCount, %d, differs from the actual count, %d", holeCount, arrayType.countHoles(object));
        return arrayType;
    }

    public static HolesObjectArray createHolesObjectArray() {
        return HOLES_OBJECT_ARRAY;
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        HolesObjectArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        JSAbstractArray.arraySetHoleCount(object, holeCount);
        return this;
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, Object value, boolean condition) {
        throw Errors.shouldNotReachHere("should not call this method, use setInBounds(Non)Hole");
    }

    public boolean isHoleFast(DynamicObject object, int index, boolean condition) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object, condition));
        return this.isHolePrepared(object, internalIndex, condition);
    }

    public void setInBoundsFastHole(DynamicObject object, int index, Object value, boolean condition) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object, condition));
        assert (this.isHolePrepared(object, internalIndex, condition));
        this.incrementHolesCount(object, -1);
        this.setInBoundsFastIntl(object, index, internalIndex, value, condition);
    }

    public void setInBoundsFastNonHole(DynamicObject object, int index, Object value, boolean condition) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object, condition));
        assert (!this.isHolePrepared(object, internalIndex, condition));
        this.setInBoundsFastIntl(object, index, internalIndex, HolesObjectArray.checkNonNull(value), condition);
    }

    private void setInBoundsFastIntl(DynamicObject object, int index, int internalIndex, Object value, boolean condition) {
        HolesObjectArray.getArray((DynamicObject)object, (boolean)condition)[internalIndex] = value;
    }

    @Override
    public boolean containsHoles(DynamicObject object, long index, boolean condition) {
        return JSAbstractArray.arrayGetHoleCount(object, condition) > 0 || !this.isInBoundsFast(object, index, condition);
    }

    @Override
    public AbstractObjectArray toNonHoles(DynamicObject object, long index, Object value, boolean condition) {
        assert (!this.containsHoles(object, index, condition));
        Object[] array = HolesObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = HolesObjectArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        this.setInBoundsFastNonHole(object, (int)index, value, condition);
        AbstractObjectArray newArray = this.isInBoundsFast(object, 0L) ? ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, array, this.integrityLevel) : ContiguousObjectArray.makeContiguousObjectArray(object, length, array, indexOffset, arrayOffset, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            HolesObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    protected void incrementHolesCount(DynamicObject object, int offset) {
        JSAbstractArray.arraySetHoleCount(object, JSAbstractArray.arrayGetHoleCount(object) + offset);
    }

    @Override
    public int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareInBoundsHoles(object, index, condition, profile);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return this.isSupportedHoles(object, index, condition);
    }

    @Override
    public int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareSupportedHoles(object, index, condition, profile);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index, boolean condition) {
        Object value = this.getInBoundsFastObject(object, index, condition);
        if (HolesObjectArray.isHoleValue(value)) {
            return Undefined.instance;
        }
        return value;
    }

    @Override
    public HolesObjectArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        return this;
    }

    public static boolean isHoleValue(Object value) {
        return value == null;
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index0, boolean condition) {
        return this.nextElementIndexHoles(object, index0, condition);
    }

    @Override
    public long previousElementIndex(DynamicObject object, long index0, boolean condition) {
        return this.previousElementIndexHoles(object, index0, condition);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return super.hasElement(object, index, condition) && !this.isHolePrepared(object, this.prepareInBoundsFast(object, (int)index, condition), condition);
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.deleteElementHoles(object, index, condition);
    }

    @Override
    public boolean isHolesType() {
        return true;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.removeRangeHoles(object, start, end);
    }

    @Override
    protected Object castNonNull(Object value) {
        return value;
    }

    @Override
    protected HolesObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new HolesObjectArray(newIntegrityLevel, this.cache);
    }

    @Override
    public List<Object> ownPropertyKeys(DynamicObject object) {
        return this.ownPropertyKeysHoles(object);
    }
}

