/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;

final class SourceAccessor
extends Accessor {
    static final SourceAccessor ACCESSOR = new SourceAccessor();
    static final Accessor.LanguageSupport LANGUAGE = ACCESSOR.languageSupport();

    private SourceAccessor() {
    }

    public static void load() {
    }

    static String detectMimeType(TruffleFile file, Set<String> validMimeTypes) {
        return ACCESSOR.languageSupport().detectMimeType(file, validMimeTypes);
    }

    static Charset detectEncoding(TruffleFile file, String mimeType) {
        return ACCESSOR.languageSupport().detectEncoding(file, mimeType);
    }

    static TruffleFile getTruffleFile(URI uri, Object fileSystemContext) {
        return ACCESSOR.languageSupport().getTruffleFile(fileSystemContext, uri);
    }

    static TruffleFile getTruffleFile(String path, Object fileSystemContext) {
        return ACCESSOR.languageSupport().getTruffleFile(path, fileSystemContext);
    }

    static boolean hasAllAccess(Object fileSystemContext) {
        return ACCESSOR.languageSupport().hasAllAccess(fileSystemContext);
    }

    static void onSourceCreated(Source source) {
        ACCESSOR.engineSupport().onSourceCreated(source);
    }

    static String getReinitializedPath(TruffleFile truffleFile) {
        return ACCESSOR.engineSupport().getReinitializedPath(truffleFile);
    }

    static URI getReinitializedURI(TruffleFile truffleFile) {
        return ACCESSOR.engineSupport().getReinitializedURI(truffleFile);
    }

    static final class SourceSupportImpl
    extends Accessor.SourceSupport {
        SourceSupportImpl() {
        }

        @Override
        public Source copySource(Source source) {
            return source.copy();
        }

        @Override
        public Object getSourceIdentifier(Source source) {
            return source.getSourceId();
        }

        @Override
        public org.graalvm.polyglot.Source getPolyglotSource(Source source) {
            return source.polyglotSource;
        }

        @Override
        public void setPolyglotSource(Source source, org.graalvm.polyglot.Source polyglotSource) {
            source.polyglotSource = polyglotSource;
        }

        @Override
        public String findMimeType(URL url, Object fileSystemContext) throws IOException {
            return Source.findMimeType(url, url.openConnection(), null, fileSystemContext);
        }

        @Override
        public Source.SourceBuilder newBuilder(String language, File origin) {
            return Source.newBuilder(language, origin);
        }

        @Override
        public void setFileSystemContext(Source.SourceBuilder builder, Object fileSystemContext) {
            builder.fileSystemContext(fileSystemContext);
        }

        @Override
        public void invalidateAfterPreinitialiation(Source source) {
            ((SourceImpl)source).key.invalidateAfterPreinitialiation();
        }
    }
}

