/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.runner.treelist.TransformCategoryItem;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import java.util.List;

public class TransformHubItem
extends TransformCategoryItem {
    private final HubSeedDescriptor _hubSeed;
    private String _name;

    public TransformHubItem(HubSeedDescriptor hubSeed, List<? extends RunProviderItem> children) {
        super(children);
        this._hubSeed = hubSeed;
        this._name = this._hubSeed.getName();
        if (this._name == null) {
            HubSeedUrl hubSeedUrl = this._hubSeed.getHubSeedUrl();
            this._name = hubSeedUrl != null ? hubSeedUrl.getUrl() : Guid.create().toString();
        }
        this._name = "hub." + this._name;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this._hubSeed.getDisplayName();
    }

    public String getLafPrefix() {
        return "transforms-item-hub";
    }

    public boolean hasConfig() {
        DisplayDescriptorCollection globalTxProps = HubSeedSettings.getDefault().getGlobalTransformProperties(this._hubSeed);
        return globalTxProps != null && !globalTxProps.isEmpty();
    }

    public void showConfig() {
        HubSeedSettings.getDefault().show(this._hubSeed);
    }
}

