/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.slider;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import java.awt.Color;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class TransformSliderTickProvider {
    private static final int[] NORMAL_VALUES = new int[]{12, 50, 256, 10000};
    private static final int[] XL_VALUES = new int[]{12, 256, 4096, 65536};
    private static final String SLIDER_PREF = "maltego.global.slider";
    private Tick[] _ticks;
    private int _default = this.getPreferences().getInt("maltego.global.slider", -1);

    public TransformSliderTickProvider() {
        this.update();
        LicenseManager.A().A(ignored -> this.update());
    }

    private void update() {
        this._ticks = new Tick[NORMAL_VALUES.length];
        A licenseMode = LicenseManager.A().A(false);
        int[] values = licenseMode.N() ? XL_VALUES : NORMAL_VALUES;
        boolean foundDefault = false;
        for (int value : values) {
            if (this._default != value) continue;
            foundDefault = true;
            break;
        }
        if (!foundDefault) {
            this.setDefault(values[0]);
        }
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            Tick tick = new Tick();
            tick.name = this.getName(value);
            tick.value = value;
            if (i == values.length - 1) {
                tick.color = Color.RED;
            }
            this._ticks[i] = tick;
        }
    }

    public int getDefault() {
        return this._default;
    }

    public void setDefault(int value) {
        this._default = value;
        this.getPreferences().putInt(SLIDER_PREF, this._default);
    }

    public int getTickCount() {
        return this._ticks.length;
    }

    public String getLabel(int tickIndex) {
        return this._ticks[tickIndex].name;
    }

    public int getValue(int tickIndex) {
        return this._ticks[tickIndex].value;
    }

    public Color getColor(int tickIndex) {
        return this._ticks[tickIndex].color;
    }

    private String getName(int value) {
        return value < 1000 ? Integer.toString(value) : Integer.toString(value / 1000) + "k";
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass());
    }

    private class Tick
    implements Comparable<Tick> {
        String name;
        int value;
        Color color;

        private Tick() {
        }

        @Override
        public int compareTo(Tick o) {
            return this.value - o.value;
        }
    }
}

