/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.offline;

import com.paterva.maltego.licensing.rest.A;
import com.paterva.maltego.licensing.serialize.H;
import com.paterva.maltego.licensing.ui.wizard.offline.OfflineLicenseKeyControl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class OfflineLicenseKeyController
extends ValidatingController<OfflineLicenseKeyControl> {
    private H blobAndEula;

    public OfflineLicenseKeyController() {
        this.setName("Load license file");
        this.setDescription("Use the License Request blob below to request a license file on the Maltego website. A license file will then be generated which should be input below. You can close this wizard and come back to it later to add the license file if you choose.");
    }

    protected OfflineLicenseKeyControl createComponent() {
        OfflineLicenseKeyControl c = new OfflineLicenseKeyControl();
        c.addChangeListener(this.changeListener());
        return c;
    }

    protected String getFirstError(OfflineLicenseKeyControl component) {
        String error = null;
        String licensePath = component.getLicenseFile();
        if (StringUtilities.isNullOrEmpty((String)licensePath)) {
            error = "Please specify a license file.";
        } else {
            File licenseFile = new File(licensePath);
            if (!licenseFile.isFile()) {
                error = " The specified license file is not a file.";
            } else {
                try {
                    String response = new String(Files.readAllBytes(licenseFile.toPath()), StandardCharsets.UTF_8);
                    this.blobAndEula = A.D((String)response);
                }
                catch (Exception ex) {
                    NormalException.logStackTrace((Throwable)ex);
                    error = "Cannot read license file";
                }
            }
        }
        return error;
    }

    protected void readSettings(WizardDescriptor settings) {
        String requestBlob;
        String licenseKey = (String)settings.getProperty("licensing.key");
        String licenseFile = (String)settings.getProperty("licensing.file");
        try {
            requestBlob = A.C((String)licenseKey);
        }
        catch (GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            requestBlob = "An error occurred: " + ex.getMessage();
        }
        ((OfflineLicenseKeyControl)this.component()).setLicenseRequest(requestBlob);
        ((OfflineLicenseKeyControl)this.component()).setLicenseFile(licenseFile != null ? licenseFile : "");
    }

    protected void storeSettings(WizardDescriptor settings) {
        settings.putProperty("licensing.file", (Object)((OfflineLicenseKeyControl)this.component()).getLicenseFile());
        if (this.blobAndEula != null) {
            settings.putProperty("licensing.blob", (Object)this.blobAndEula.B());
            settings.putProperty("licensing.eula", this.blobAndEula.A().orElse(null));
        }
    }
}

