/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.free;

import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.licensing.ui.login.A;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.free.ErrorPanel;
import com.paterva.maltego.licensing.ui.wizard.free.LoginControl;
import com.paterva.maltego.typing.editing.inputform.InputForm;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.io.IOException;
import java.net.MalformedURLException;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class LoginRequestController
extends PassFailProgressController<InputForm, LoginControl, ErrorPanel> {
    public LoginRequestController() {
        this.setName("Login");
        this.setDescription("Please log in to use the free online version of Maltego.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected InputForm doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws IOException {
        return A.B().C();
    }

    protected LoginControl createPassComponent() {
        return new LoginControl();
    }

    protected ErrorPanel createFailComponent() {
        return new ErrorPanel("Login server could not be contacted!");
    }

    protected void pass(WizardDescriptor descriptor, LoginControl component, InputForm result) {
        try {
            component.setRegistrationUrl(com.paterva.maltego.licensing.free.A.K());
            component.setForm(result);
            descriptor.putProperty("licensing.login.form", (Object)result);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void fail(ErrorPanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else if (CertificateUtils.isCertificateError((Exception)e)) {
            String message = CertificateUtils.getErrorString((Exception)e);
            component.setTitle("Certificate chain is not trusted.");
            String extraInfo = "Rerun this wizard from the \"Log In\" button under the \"License Manager\".";
            component.setMessage("The transform certificate is blocked because of an invalid date, Subject Alternative Names (SANs) and subject Common Name (CN) that do not match the queried URL, or the certificate is blacklisted in the \"Certificate Manager\" (find under the \"Transforms\" ribbon tab).\n\n" + extraInfo);
            component.setOptionsButtonVisible(false);
            component.setError(message);
        } else {
            component.setError(e.getMessage());
        }
    }
}

