/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.product;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ProductSelectionPanel
extends JPanel {
    private static final String PREF_FIRST_SHOW = "maltego.product-selection.first-show";
    private static final String PURCHASE = "Purchase";
    private static final String UPGRADE = "Upgrade";
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final JButton closeButton;
    private ProductSelectionResult result;
    private ChangeListener licenseListener;
    private JButton activateOfflineButton;
    private JLabel casefileActiveLabel;
    private JPanel casefileBgPanel;
    private JButton casefileButton;
    private JLabel casefileIconLabel;
    private JLabel casefileLabel;
    private JScrollPane casefileScrollPane;
    private JTextArea casefileTextArea;
    private JLabel ceActiveLabel;
    private JPanel ceBgPanel;
    private JButton ceButton;
    private JLabel ceIconLabel;
    private JLabel ceLabel;
    private JScrollPane ceScrollPane;
    private JTextArea ceTextArea;
    private JLabel chooseProductLabel;
    private JButton classicActivateButton;
    private JLabel classicActiveLabel;
    private JPanel classicBgPanel;
    private JButton classicBuyButton;
    private JLabel classicIconLabel;
    private JLabel classicLabel;
    private JScrollPane classicScrollPane;
    private JTextArea classicTextArea;
    private JButton compareButton;
    private JPanel fillerPanel;
    private JButton oneActivateButton;
    private JLabel oneActiveLabel;
    private JPanel oneBgPanel;
    private JButton oneBuyButton;
    private JLabel oneIconLabel;
    private JLabel oneLabel;
    private JScrollPane oneScrollPane;
    private JTextArea oneTextArea;
    private JPanel productsPanel;
    private JLabel titleLabel;
    private JLabel titleMsgLabel;
    private JPanel topPanel;
    private JPanel topRightPanel;
    private JPanel welcomePanel;
    private JButton xlActivateButton;
    private JLabel xlActiveLabel;
    private JPanel xlBgPanel;
    private JButton xlBuyButton;
    private JLabel xlIconLabel;
    private JLabel xlLabel;
    private JScrollPane xlScrollPane;
    private JTextArea xlTextArea;

    public ProductSelectionPanel(JButton closeButton) {
        this.closeButton = closeButton;
        this.initComponents();
        this.setBackground(this.LAF.getColor("3-main-dark-color"));
        this.welcomePanel.setBackground(this.LAF.getColor("7-heading-panel-background"));
        Color orange = this.LAF.getColor("3-maltego-orange");
        this.titleLabel.setForeground(orange);
        this.titleMsgLabel.setForeground(orange);
        Color modeFgColor = Color.WHITE;
        this.ceButton.setForeground(modeFgColor);
        this.casefileButton.setForeground(modeFgColor);
        this.classicActivateButton.setForeground(modeFgColor);
        this.classicBuyButton.setForeground(modeFgColor);
        this.xlActivateButton.setForeground(modeFgColor);
        this.xlBuyButton.setForeground(modeFgColor);
        this.oneActivateButton.setForeground(modeFgColor);
        this.oneBuyButton.setForeground(modeFgColor);
        Color descriptionBgColor = this.ceTextArea.getBackground();
        this.ceTextArea.setBackground(descriptionBgColor);
        this.casefileTextArea.setBackground(descriptionBgColor);
        this.classicTextArea.setBackground(descriptionBgColor);
        this.xlTextArea.setBackground(descriptionBgColor);
        this.oneTextArea.setBackground(descriptionBgColor);
        if (this.isFirstShow()) {
            this.titleLabel.setText("Product Selection");
            this.titleMsgLabel.setText("Please select how you want to use Maltego.");
        }
        this.update();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.licenseListener = ignored -> this.update();
        LicenseManager.A().A(this.licenseListener);
    }

    @Override
    public void removeNotify() {
        this.setFirstShow(false);
        LicenseManager.A().B(this.licenseListener);
        this.licenseListener = null;
        super.removeNotify();
    }

    public ProductSelectionResult getResult() {
        return this.result;
    }

    private void update() {
        LicenseManager licMan = LicenseManager.A();
        A licenseMode = licMan.A(false);
        this.ceButton.setVisible(!licenseMode.L());
        this.ceActiveLabel.setVisible(licenseMode.L());
        this.casefileButton.setVisible(!licenseMode.F());
        this.casefileActiveLabel.setVisible(licenseMode.F());
        this.classicActivateButton.setVisible(!licenseMode.B());
        this.classicBuyButton.setVisible(!licenseMode.B());
        this.classicActiveLabel.setVisible(licenseMode.G());
        this.xlActivateButton.setVisible(!licenseMode.B());
        this.xlBuyButton.setVisible(!licenseMode.B() || licenseMode.G());
        this.xlBuyButton.setText(licenseMode.B() ? UPGRADE : PURCHASE);
        this.xlActiveLabel.setVisible(licenseMode.M());
        this.oneActivateButton.setVisible(!licenseMode.B());
        this.oneBuyButton.setVisible(!licenseMode.B() || licenseMode.G() || licenseMode.M());
        this.oneBuyButton.setText(licenseMode.B() ? UPGRADE : PURCHASE);
        this.oneActiveLabel.setVisible(licenseMode.E());
        Color modeBgColor = new JButton().getBackground().brighter();
        Color activeBgColor = Color.WHITE;
        this.ceBgPanel.setBackground(licenseMode.L() ? activeBgColor : modeBgColor);
        this.casefileBgPanel.setBackground(licenseMode.F() ? activeBgColor : modeBgColor);
        this.classicBgPanel.setBackground(licenseMode.G() ? activeBgColor : modeBgColor);
        this.xlBgPanel.setBackground(licenseMode.M() ? activeBgColor : modeBgColor);
        this.oneBgPanel.setBackground(licenseMode.E() ? activeBgColor : modeBgColor);
    }

    private boolean isFirstShow() {
        return NbPreferences.forModule(this.getClass()).getBoolean(PREF_FIRST_SHOW, true);
    }

    private void setFirstShow(boolean firstShow) {
        NbPreferences.forModule(this.getClass()).putBoolean(PREF_FIRST_SHOW, firstShow);
    }

    private void initComponents() {
        this.welcomePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleMsgLabel = new JLabel();
        this.productsPanel = new JPanel();
        this.topPanel = new JPanel();
        this.chooseProductLabel = new JLabel();
        this.topRightPanel = new JPanel();
        this.compareButton = new JButton();
        this.activateOfflineButton = new JButton();
        this.ceIconLabel = new JLabel();
        this.ceLabel = new JLabel();
        this.ceButton = new JButton();
        this.ceButton.setBackground(this.LAF.getColor("8-ce-color"));
        this.ceActiveLabel = new JLabel();
        this.ceScrollPane = new JScrollPane();
        this.ceTextArea = new JTextArea();
        this.ceBgPanel = new JPanel();
        this.casefileIconLabel = new JLabel();
        this.casefileLabel = new JLabel();
        this.casefileButton = new JButton();
        this.casefileButton.setBackground(this.LAF.getColor("8-casefile-color"));
        this.casefileActiveLabel = new JLabel();
        this.casefileScrollPane = new JScrollPane();
        this.casefileTextArea = new JTextArea();
        this.casefileBgPanel = new JPanel();
        this.classicIconLabel = new JLabel();
        this.classicLabel = new JLabel();
        this.classicActivateButton = new JButton();
        this.classicActivateButton.setBackground(this.LAF.getColor("8-classic-color"));
        this.classicBuyButton = new JButton();
        this.classicBuyButton.setBackground(this.LAF.getColor("8-classic-color"));
        this.classicActiveLabel = new JLabel();
        this.classicScrollPane = new JScrollPane();
        this.classicTextArea = new JTextArea();
        this.classicBgPanel = new JPanel();
        this.xlIconLabel = new JLabel();
        this.xlLabel = new JLabel();
        this.xlActivateButton = new JButton();
        this.xlActivateButton.setBackground(this.LAF.getColor("8-xl-color"));
        this.xlBuyButton = new JButton();
        this.xlBuyButton.setBackground(this.LAF.getColor("8-xl-color"));
        this.xlActiveLabel = new JLabel();
        this.xlScrollPane = new JScrollPane();
        this.xlTextArea = new JTextArea();
        this.xlBgPanel = new JPanel();
        this.oneIconLabel = new JLabel();
        this.oneLabel = new JLabel();
        this.oneActivateButton = new JButton();
        this.oneActivateButton.setBackground(this.LAF.getColor("8-one-color"));
        this.oneBuyButton = new JButton();
        this.oneBuyButton.setBackground(this.LAF.getColor("8-one-color"));
        this.oneActiveLabel = new JLabel();
        this.oneScrollPane = new JScrollPane();
        this.oneTextArea = new JTextArea();
        this.oneBgPanel = new JPanel();
        this.fillerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.welcomePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.welcomePanel.setLayout(new GridBagLayout());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1, this.titleLabel.getFont().getSize() + 4));
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.welcomePanel.add((Component)this.titleLabel, gridBagConstraints);
        this.titleMsgLabel.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.titleMsgLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.titleMsgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.welcomePanel.add((Component)this.titleMsgLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.welcomePanel, gridBagConstraints);
        this.productsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.productsPanel.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.chooseProductLabel.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.chooseProductLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.chooseProductLabel.text"));
        this.topPanel.add((Component)this.chooseProductLabel, "Center");
        this.topRightPanel.setLayout(new BorderLayout(6, 0));
        this.compareButton.setFont(new Font("Dialog", 0, 12));
        this.compareButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.compareButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.compareButton.text_1"));
        this.compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.compareButtonActionPerformed(evt);
            }
        });
        this.topRightPanel.add((Component)this.compareButton, "Center");
        this.activateOfflineButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.activateOfflineButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.activateOfflineButton.text"));
        this.activateOfflineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.activateOfflineButtonActionPerformed(evt);
            }
        });
        this.topRightPanel.add((Component)this.activateOfflineButton, "East");
        this.topPanel.add((Component)this.topRightPanel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 3, 6);
        this.productsPanel.add((Component)this.topPanel, gridBagConstraints);
        this.ceIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/CE_logo_64.png")));
        Mnemonics.setLocalizedText((JLabel)this.ceIconLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceIconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(9, 12, 9, 3);
        this.productsPanel.add((Component)this.ceIconLabel, gridBagConstraints);
        this.ceLabel.setFont(this.ceLabel.getFont().deriveFont(this.ceLabel.getFont().getStyle() | 1, this.ceLabel.getFont().getSize() + 4));
        Mnemonics.setLocalizedText((JLabel)this.ceLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.productsPanel.add((Component)this.ceLabel, gridBagConstraints);
        this.ceButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.ceButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceButton.text"));
        this.ceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.ceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 9, 3);
        this.productsPanel.add((Component)this.ceButton, gridBagConstraints);
        this.ceActiveLabel.setFont(this.ceActiveLabel.getFont().deriveFont((float)this.ceActiveLabel.getFont().getSize() + 3.0f));
        this.ceActiveLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.ceActiveLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceActiveLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.ceActiveLabel, gridBagConstraints);
        this.ceScrollPane.setHorizontalScrollBarPolicy(31);
        this.ceTextArea.setEditable(false);
        this.ceTextArea.setColumns(20);
        this.ceTextArea.setLineWrap(true);
        this.ceTextArea.setText(NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceTextArea.text"));
        this.ceTextArea.setWrapStyleWord(true);
        this.ceTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.ceTextArea.setMinimumSize(new Dimension(20, 10));
        this.ceScrollPane.setViewportView(this.ceTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 12);
        this.productsPanel.add((Component)this.ceScrollPane, gridBagConstraints);
        this.ceBgPanel.setBackground(new Color(51, 51, 51));
        GroupLayout ceBgPanelLayout = new GroupLayout(this.ceBgPanel);
        this.ceBgPanel.setLayout(ceBgPanelLayout);
        ceBgPanelLayout.setHorizontalGroup(ceBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 788, Short.MAX_VALUE));
        ceBgPanelLayout.setVerticalGroup(ceBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 76, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.productsPanel.add((Component)this.ceBgPanel, gridBagConstraints);
        this.casefileIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/CF_logo_64.png")));
        Mnemonics.setLocalizedText((JLabel)this.casefileIconLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.casefileIconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(9, 12, 9, 3);
        this.productsPanel.add((Component)this.casefileIconLabel, gridBagConstraints);
        this.casefileLabel.setFont(this.casefileLabel.getFont().deriveFont(this.casefileLabel.getFont().getStyle() | 1, this.casefileLabel.getFont().getSize() + 4));
        Mnemonics.setLocalizedText((JLabel)this.casefileLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.casefileLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.productsPanel.add((Component)this.casefileLabel, gridBagConstraints);
        this.casefileButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.casefileButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.casefileButton.text"));
        this.casefileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.casefileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 9, 3);
        this.productsPanel.add((Component)this.casefileButton, gridBagConstraints);
        this.casefileActiveLabel.setFont(this.casefileActiveLabel.getFont().deriveFont((float)this.casefileActiveLabel.getFont().getSize() + 3.0f));
        this.casefileActiveLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.casefileActiveLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.casefileActiveLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.casefileActiveLabel, gridBagConstraints);
        this.casefileScrollPane.setHorizontalScrollBarPolicy(31);
        this.casefileTextArea.setEditable(false);
        this.casefileTextArea.setColumns(20);
        this.casefileTextArea.setLineWrap(true);
        this.casefileTextArea.setText(NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.casefileTextArea.text"));
        this.casefileTextArea.setWrapStyleWord(true);
        this.casefileTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.casefileTextArea.setMinimumSize(new Dimension(20, 10));
        this.casefileScrollPane.setViewportView(this.casefileTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 12);
        this.productsPanel.add((Component)this.casefileScrollPane, gridBagConstraints);
        this.casefileBgPanel.setBackground(new Color(51, 51, 51));
        GroupLayout casefileBgPanelLayout = new GroupLayout(this.casefileBgPanel);
        this.casefileBgPanel.setLayout(casefileBgPanelLayout);
        casefileBgPanelLayout.setHorizontalGroup(casefileBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        casefileBgPanelLayout.setVerticalGroup(casefileBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.productsPanel.add((Component)this.casefileBgPanel, gridBagConstraints);
        this.classicIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/Classic_logo_64.png")));
        Mnemonics.setLocalizedText((JLabel)this.classicIconLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.classicIconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(9, 12, 9, 3);
        this.productsPanel.add((Component)this.classicIconLabel, gridBagConstraints);
        this.classicLabel.setFont(this.classicLabel.getFont().deriveFont(this.classicLabel.getFont().getStyle() | 1, this.classicLabel.getFont().getSize() + 4));
        Mnemonics.setLocalizedText((JLabel)this.classicLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.classicLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.productsPanel.add((Component)this.classicLabel, gridBagConstraints);
        this.classicActivateButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.classicActivateButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.classicActivateButton.text"));
        this.classicActivateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.classicActivateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 3, 3);
        this.productsPanel.add((Component)this.classicActivateButton, gridBagConstraints);
        this.classicBuyButton.setFont(new Font("Dialog", 0, 12));
        this.classicBuyButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.classicBuyButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.classicBuyButton.text"));
        this.classicBuyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.classicBuyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.classicBuyButton, gridBagConstraints);
        this.classicActiveLabel.setFont(this.classicActiveLabel.getFont().deriveFont((float)this.classicActiveLabel.getFont().getSize() + 3.0f));
        this.classicActiveLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.classicActiveLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.classicActiveLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.classicActiveLabel, gridBagConstraints);
        this.classicScrollPane.setHorizontalScrollBarPolicy(31);
        this.classicTextArea.setEditable(false);
        this.classicTextArea.setColumns(20);
        this.classicTextArea.setLineWrap(true);
        this.classicTextArea.setText(NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.classicTextArea.text"));
        this.classicTextArea.setWrapStyleWord(true);
        this.classicTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.classicTextArea.setMinimumSize(new Dimension(20, 10));
        this.classicScrollPane.setViewportView(this.classicTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 12);
        this.productsPanel.add((Component)this.classicScrollPane, gridBagConstraints);
        this.classicBgPanel.setBackground(new Color(51, 51, 51));
        GroupLayout classicBgPanelLayout = new GroupLayout(this.classicBgPanel);
        this.classicBgPanel.setLayout(classicBgPanelLayout);
        classicBgPanelLayout.setHorizontalGroup(classicBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 788, Short.MAX_VALUE));
        classicBgPanelLayout.setVerticalGroup(classicBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 88, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.productsPanel.add((Component)this.classicBgPanel, gridBagConstraints);
        this.xlIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/XL_logo_64.png")));
        Mnemonics.setLocalizedText((JLabel)this.xlIconLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.xlIconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(9, 12, 9, 3);
        this.productsPanel.add((Component)this.xlIconLabel, gridBagConstraints);
        this.xlLabel.setFont(this.xlLabel.getFont().deriveFont(this.xlLabel.getFont().getStyle() | 1, this.xlLabel.getFont().getSize() + 4));
        Mnemonics.setLocalizedText((JLabel)this.xlLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.xlLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.productsPanel.add((Component)this.xlLabel, gridBagConstraints);
        this.xlActivateButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.xlActivateButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceButton1.text"));
        this.xlActivateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.xlActivateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 3, 3);
        this.productsPanel.add((Component)this.xlActivateButton, gridBagConstraints);
        this.xlBuyButton.setFont(new Font("Dialog", 0, 12));
        this.xlBuyButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.xlBuyButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.ceButton3.text"));
        this.xlBuyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.xlBuyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.xlBuyButton, gridBagConstraints);
        this.xlActiveLabel.setFont(this.xlActiveLabel.getFont().deriveFont((float)this.xlActiveLabel.getFont().getSize() + 3.0f));
        this.xlActiveLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.xlActiveLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.xlActiveLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.xlActiveLabel, gridBagConstraints);
        this.xlScrollPane.setHorizontalScrollBarPolicy(31);
        this.xlTextArea.setEditable(false);
        this.xlTextArea.setColumns(20);
        this.xlTextArea.setLineWrap(true);
        this.xlTextArea.setText(NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.xlTextArea.text"));
        this.xlTextArea.setWrapStyleWord(true);
        this.xlTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.xlTextArea.setMinimumSize(new Dimension(20, 10));
        this.xlScrollPane.setViewportView(this.xlTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 12);
        this.productsPanel.add((Component)this.xlScrollPane, gridBagConstraints);
        this.xlBgPanel.setBackground(new Color(51, 51, 51));
        GroupLayout xlBgPanelLayout = new GroupLayout(this.xlBgPanel);
        this.xlBgPanel.setLayout(xlBgPanelLayout);
        xlBgPanelLayout.setHorizontalGroup(xlBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        xlBgPanelLayout.setVerticalGroup(xlBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.productsPanel.add((Component)this.xlBgPanel, gridBagConstraints);
        this.oneIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/One_logo_64.png")));
        Mnemonics.setLocalizedText((JLabel)this.oneIconLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.oneIconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(9, 12, 9, 3);
        this.productsPanel.add((Component)this.oneIconLabel, gridBagConstraints);
        this.oneLabel.setFont(this.oneLabel.getFont().deriveFont(this.oneLabel.getFont().getStyle() | 1, this.oneLabel.getFont().getSize() + 4));
        Mnemonics.setLocalizedText((JLabel)this.oneLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.oneLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.productsPanel.add((Component)this.oneLabel, gridBagConstraints);
        this.oneActivateButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.oneActivateButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.oneActivateButton.text"));
        this.oneActivateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.oneActivateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 3, 3);
        this.productsPanel.add((Component)this.oneActivateButton, gridBagConstraints);
        this.oneBuyButton.setFont(new Font("Dialog", 0, 12));
        this.oneBuyButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.oneBuyButton, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.oneBuyButton.text"));
        this.oneBuyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductSelectionPanel.this.oneBuyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.oneBuyButton, gridBagConstraints);
        this.oneActiveLabel.setFont(this.oneActiveLabel.getFont().deriveFont((float)this.oneActiveLabel.getFont().getSize() + 3.0f));
        this.oneActiveLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.oneActiveLabel, (String)NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.oneActiveLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 13, 3);
        this.productsPanel.add((Component)this.oneActiveLabel, gridBagConstraints);
        this.oneScrollPane.setHorizontalScrollBarPolicy(31);
        this.oneTextArea.setEditable(false);
        this.oneTextArea.setColumns(20);
        this.oneTextArea.setLineWrap(true);
        this.oneTextArea.setText(NbBundle.getMessage(ProductSelectionPanel.class, (String)"ProductSelectionPanel.oneTextArea.text"));
        this.oneTextArea.setWrapStyleWord(true);
        this.oneTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.oneTextArea.setMinimumSize(new Dimension(20, 10));
        this.oneScrollPane.setViewportView(this.oneTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 12);
        this.productsPanel.add((Component)this.oneScrollPane, gridBagConstraints);
        this.oneBgPanel.setBackground(new Color(51, 51, 51));
        GroupLayout oneBgPanelLayout = new GroupLayout(this.oneBgPanel);
        this.oneBgPanel.setLayout(oneBgPanelLayout);
        oneBgPanelLayout.setHorizontalGroup(oneBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        oneBgPanelLayout.setVerticalGroup(oneBgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.productsPanel.add((Component)this.oneBgPanel, gridBagConstraints);
        GroupLayout fillerPanelLayout = new GroupLayout(this.fillerPanel);
        this.fillerPanel.setLayout(fillerPanelLayout);
        fillerPanelLayout.setHorizontalGroup(fillerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        fillerPanelLayout.setVerticalGroup(fillerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.productsPanel.add((Component)this.fillerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.productsPanel, gridBagConstraints);
    }

    private void ceButtonActionPerformed(ActionEvent evt) {
        this.result = ProductSelectionResult.RUN_CE;
        this.closeButton.doClick();
    }

    private void compareButtonActionPerformed(ActionEvent evt) {
        String licenseKey = LicenseManager.A().C();
        BrowseToUrl.compareProducts(licenseKey);
    }

    private void casefileButtonActionPerformed(ActionEvent evt) {
        this.result = ProductSelectionResult.RUN_CASEFILE;
        this.closeButton.doClick();
    }

    private void classicActivateButtonActionPerformed(ActionEvent evt) {
        this.result = ProductSelectionResult.ACTIVATE;
        this.closeButton.doClick();
    }

    private void xlActivateButtonActionPerformed(ActionEvent evt) {
        this.result = ProductSelectionResult.ACTIVATE;
        this.closeButton.doClick();
    }

    private void classicBuyButtonActionPerformed(ActionEvent evt) {
        String licenseKey = LicenseManager.A().C();
        BrowseToUrl.buyClassic(licenseKey);
    }

    private void xlBuyButtonActionPerformed(ActionEvent evt) {
        String licenseKey = LicenseManager.A().C();
        if (PURCHASE.equals(this.xlBuyButton.getText())) {
            BrowseToUrl.buyXL(licenseKey);
        } else {
            BrowseToUrl.upgradeToXL(licenseKey);
        }
    }

    private void activateOfflineButtonActionPerformed(ActionEvent evt) {
        this.result = ProductSelectionResult.OFFLINE;
        this.closeButton.doClick();
    }

    private void oneActivateButtonActionPerformed(ActionEvent evt) {
        this.result = ProductSelectionResult.ACTIVATE;
        this.closeButton.doClick();
    }

    private void oneBuyButtonActionPerformed(ActionEvent evt) {
        String licenseKey = LicenseManager.A().C();
        if (PURCHASE.equals(this.oneBuyButton.getText())) {
            BrowseToUrl.buyOne(licenseKey);
        } else {
            BrowseToUrl.upgradeToOne(licenseKey);
        }
    }
}

