/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.manager;

import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseDateFormat;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.wizard.LicenseWebLinksPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LicensedPanel
extends JPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color errorDarkColor;
    private final JButton closeButton;
    private boolean changeKey = false;
    private JPanel bottomPanel;
    private JLabel descriptionLabel;
    private JLabel invalidLabel;
    private JButton keyChangeButton;
    private JLabel keyLabel;
    private JTextField keyTextField;
    private JLabel licensedToLabel;
    private JTextField licensedToTextField;
    private LicenseWebLinksPanel linksPanel;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JLabel validFromLabel;
    private JTextField validFromTextField;
    private JLabel validToLabel;
    private JTextField validToTextField;

    public LicensedPanel(A licenseMode, JButton closeButton) {
        this.closeButton = closeButton;
        this.initComponents();
        this.errorDarkColor = UIManager.getLookAndFeelDefaults().getColor("7-dark-red");
        this.invalidLabel.setForeground(this.errorDarkColor);
        Color orange = this.LAF.getColor("3-maltego-orange");
        this.titleLabel.setForeground(orange);
        this.descriptionLabel.setForeground(orange);
        this.titlePanel.setBackground(this.LAF.getColor("7-heading-panel-background"));
        Color disabledColor = new JPanel().getBackground();
        this.licensedToTextField.setBackground(disabledColor);
        this.keyTextField.setBackground(disabledColor);
        this.validFromTextField.setBackground(disabledColor);
        this.validToTextField.setBackground(disabledColor);
        this.update(licenseMode);
    }

    public boolean isChangeKey() {
        return this.changeKey;
    }

    private void update(A licenseMode) {
        C validity = licenseMode.J();
        E capability = validity.J();
        D license = licenseMode.A();
        this.titleLabel.setText(capability.F());
        this.licensedToTextField.setText(license.A());
        this.keyTextField.setText(license.C());
        this.validFromTextField.setText(LicenseDateFormat.format((long)capability.H()));
        this.validToTextField.setText(LicenseDateFormat.format((long)capability.G()));
        this.linksPanel.setLicenseKey(license.C());
        boolean beforeFrom = !validity.L();
        boolean afterTo = validity.M();
        this.invalidLabel.setVisible(beforeFrom || afterTo);
        this.invalidLabel.setText(beforeFrom ? "(License not yet valid)" : "(License Expired!)");
        this.validToTextField.setForeground(afterTo ? this.errorDarkColor : this.validFromTextField.getForeground());
        long daysRemaining = validity.H();
        if (!afterTo && !beforeFrom) {
            this.descriptionLabel.setText("Your license is still valid for " + daysRemaining + " days.");
            this.descriptionLabel.setForeground(this.titleLabel.getForeground());
        } else if (beforeFrom) {
            String description = "Your license is not yet valid.";
            this.descriptionLabel.setText(description);
            this.descriptionLabel.setForeground(this.errorDarkColor);
        } else {
            boolean isInGracePeriod = validity.A();
            String description = "Your license expired " + Math.abs(daysRemaining) + " days ago. Please renew your license.";
            if (isInGracePeriod) {
                long graceDays = validity.D();
                description = description + " You have a grace period of " + graceDays + " days left.";
            } else {
                description = description + " You have no grace period left.";
            }
            this.descriptionLabel.setText(description);
            this.descriptionLabel.setForeground(this.errorDarkColor);
        }
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.invalidLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.linksPanel = new LicenseWebLinksPanel();
        this.bottomPanel = new JPanel();
        this.licensedToLabel = new JLabel();
        this.licensedToTextField = new JTextField();
        this.validFromLabel = new JLabel();
        this.validFromTextField = new JTextField();
        this.validToLabel = new JLabel();
        this.validToTextField = new JTextField();
        this.keyLabel = new JLabel();
        this.keyTextField = new JTextField();
        this.keyChangeButton = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.titlePanel.setLayout(new GridBagLayout());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1, this.titleLabel.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.titlePanel.add((Component)this.titleLabel, gridBagConstraints);
        this.invalidLabel.setFont(this.invalidLabel.getFont().deriveFont(this.invalidLabel.getFont().getStyle() | 1, this.invalidLabel.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.invalidLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.invalidLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.titlePanel.add((Component)this.invalidLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.descriptionLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.titlePanel.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.linksPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.linksPanel, gridBagConstraints);
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.bottomPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.licensedToLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.licensedToLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.licensedToLabel, gridBagConstraints);
        this.licensedToTextField.setEditable(false);
        this.licensedToTextField.setText(NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.licensedToTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.licensedToTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.validFromLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.validFromLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.validFromLabel, gridBagConstraints);
        this.validFromTextField.setEditable(false);
        this.validFromTextField.setText(NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.validFromTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.validFromTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.validToLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.validToLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.validToLabel, gridBagConstraints);
        this.validToTextField.setEditable(false);
        this.validToTextField.setText(NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.validToTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.validToTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.keyLabel, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.keyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.keyLabel, gridBagConstraints);
        this.keyTextField.setEditable(false);
        this.keyTextField.setText(NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.keyTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.keyTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.keyChangeButton, (String)NbBundle.getMessage(LicensedPanel.class, (String)"LicensedPanel.keyChangeButton.text"));
        this.keyChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicensedPanel.this.keyChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.bottomPanel.add((Component)this.keyChangeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
    }

    private void keyChangeButtonActionPerformed(ActionEvent evt) {
        this.changeKey = true;
        this.closeButton.doClick();
    }
}

