/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.manager;

import com.paterva.maltego.licensing.LicenseDateFormat;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.wizard.LicenseWebLinksPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FreePanel
extends JPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final JButton closeButton;
    private boolean logIn = false;
    private JPanel bottomPanel;
    private JTextArea descriptionTextArea;
    private JLabel fullNameLabel;
    private JTextField fullNameTextField;
    private LicenseWebLinksPanel linksPanel;
    private JButton logInButton;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JLabel validUntilLabel;
    private JTextField validUntilTextField;

    public FreePanel(A licenseMode, JButton closeButton) {
        this.closeButton = closeButton;
        this.initComponents();
        Color orange = this.LAF.getColor("3-maltego-orange");
        this.titleLabel.setForeground(orange);
        this.descriptionTextArea.setForeground(orange);
        this.titlePanel.setBackground(this.LAF.getColor("7-heading-panel-background"));
        Color disabledColor = new JPanel().getBackground();
        this.fullNameTextField.setBackground(disabledColor);
        this.validUntilTextField.setBackground(disabledColor);
        boolean online = licenseMode.I();
        this.titleLabel.setText(online ? "Maltego Community Edition" : "Maltego CaseFile");
        if (online) {
            UserInfo userInfo = new UserInfo(licenseMode);
            long validTo = com.paterva.maltego.licensing.free.A.R();
            if (validTo >= System.currentTimeMillis()) {
                this.fullNameTextField.setText(userInfo.getFullName());
                this.validUntilTextField.setText(LicenseDateFormat.format((long)validTo));
                this.logInButton.setVisible(false);
            } else {
                this.fullNameLabel.setVisible(false);
                this.fullNameTextField.setVisible(false);
                this.validUntilLabel.setVisible(false);
                this.validUntilTextField.setVisible(false);
                this.logInButton.setVisible(true);
            }
            this.descriptionTextArea.setText("In the Community Edition free online mode the Community Transforms will be installed and can be run to generate graphs, but the resulting graphs may not be used for commercial purposes.");
        } else {
            this.bottomPanel.setVisible(false);
            this.fullNameLabel.setVisible(false);
            this.fullNameTextField.setVisible(false);
            this.validUntilLabel.setVisible(false);
            this.validUntilTextField.setVisible(false);
            this.logInButton.setVisible(false);
            this.descriptionTextArea.setText("In the CaseFile free offline mode, graphs can only be created manually, no transforms may be run. More types of entities will be installed and the resulting graphs may be used for commercial purposes.");
        }
    }

    public boolean isLogIn() {
        return this.logIn;
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.descriptionTextArea = new JTextArea();
        this.linksPanel = new LicenseWebLinksPanel();
        this.bottomPanel = new JPanel();
        this.fullNameLabel = new JLabel();
        this.fullNameTextField = new JTextField();
        this.validUntilLabel = new JLabel();
        this.validUntilTextField = new JTextField();
        this.logInButton = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.titlePanel.setLayout(new GridBagLayout());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1, this.titleLabel.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(FreePanel.class, (String)"FreePanel.titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.titlePanel.add((Component)this.titleLabel, gridBagConstraints);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.titlePanel.add((Component)this.descriptionTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.linksPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.linksPanel, gridBagConstraints);
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.bottomPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.fullNameLabel, (String)NbBundle.getMessage(FreePanel.class, (String)"FreePanel.fullNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.fullNameLabel, gridBagConstraints);
        this.fullNameTextField.setEditable(false);
        this.fullNameTextField.setText(NbBundle.getMessage(FreePanel.class, (String)"FreePanel.fullNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.fullNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.validUntilLabel, (String)NbBundle.getMessage(FreePanel.class, (String)"FreePanel.validUntilLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.validUntilLabel, gridBagConstraints);
        this.validUntilTextField.setEditable(false);
        this.validUntilTextField.setText(NbBundle.getMessage(FreePanel.class, (String)"FreePanel.validUntilTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomPanel.add((Component)this.validUntilTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.logInButton, (String)NbBundle.getMessage(FreePanel.class, (String)"FreePanel.logInButton.text"));
        this.logInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreePanel.this.logInButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        this.bottomPanel.add((Component)this.logInButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
    }

    private void logInButtonActionPerformed(ActionEvent evt) {
        this.logIn = true;
        this.closeButton.doClick();
    }
}

