/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.eula;

import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.components.SmoothScrollingEditorPane;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;

class EulaPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(EulaPanel.class.getName());
    private final JEditorPane licensePane;

    public EulaPanel(I eula) {
        this(eula.A());
    }

    public EulaPanel(String html) {
        Args.notNullOrBlank((String)html, (String)"html");
        this.setLayout(new BorderLayout());
        this.licensePane = new SmoothScrollingEditorPane();
        this.licensePane.setContentType("text/html");
        this.licensePane.setText(html);
        this.licensePane.addHyperlinkListener(new EulaLinkListener());
        this.licensePane.setEditable(false);
        this.licensePane.setCaretPosition(0);
        this.licensePane.setPreferredSize(new Dimension(600, 400));
        JScrollPane scrollPane = new JScrollPane(this.licensePane);
        this.add(scrollPane);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "EULA html:\n{0}", html);
            LOG.log(Level.FINE, "EULA parsed html:\n{0}", this.licensePane.getText());
        }
    }

    private class EulaLinkListener
    implements HyperlinkListener {
        private EulaLinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            Args.notNull((Object)evt, (String)"evt");
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String desc = evt.getDescription();
                if (desc != null && desc.startsWith("#")) {
                    desc = desc.substring(1);
                    EulaPanel.this.licensePane.scrollToReference(desc);
                } else {
                    URL url = evt.getURL();
                    if (url != null) {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                    }
                }
            }
        }
    }
}

