/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.transform.descriptor.TransformApiKeyProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicensedApiKeyProvider
extends TransformApiKeyProvider {
    private static final Logger LOG = Logger.getLogger(LicensedApiKeyProvider.class.getName());
    private static final TransformApiKeyProvider.UrlWildcard PATERVA = new TransformApiKeyProvider.UrlWildcard("http://*.paterva.com:*/*");
    private static final TransformApiKeyProvider.UrlWildcard MALTEGO = new TransformApiKeyProvider.UrlWildcard("http://*.maltego.com:*/*");

    private Map<String, String> getKeyMap() {
        Map map = Collections.emptyMap();
        A licenseMode = LicenseManager.A().A(false);
        if (licenseMode.B() && licenseMode.P()) {
            LOG.fine("Using commercial API keys");
            map = licenseMode.A().I();
        }
        if (licenseMode.Q() && licenseMode.I()) {
            LOG.fine("Using community API keys");
            map = com.paterva.maltego.licensing.free.A.H();
        }
        LOG.log(Level.FINE, "API keys: {0}", map);
        return map;
    }

    public String getKey(String target) {
        String apiKey = null;
        try {
            Iterator<Map.Entry<String, String>> iterator;
            URL targetUrl = new URL(target);
            if ((PATERVA.matches(targetUrl) || MALTEGO.matches(targetUrl)) && (iterator = this.getKeyMap().entrySet().iterator()).hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                apiKey = entry.getValue();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        LOG.log(Level.FINE, "Target: {0}, API key:{1}", new Object[]{target, apiKey});
        return apiKey;
    }
}

