/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.paterva.maltego.crypto.MaltegoClientCryptographer;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.PatervaUrl;
import com.paterva.maltego.licensing.ui.monitor.B;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class BrowseToUrl {
    public static void compareProducts(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.PRODUCT_MATRIX, null, licenseKey, false);
    }

    public static void buyClassic(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.PURCHASE, "Classic", licenseKey, false);
    }

    public static void buyXL(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.PURCHASE, "XL", licenseKey, false);
    }

    public static void buyOne(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.PURCHASE, "One", licenseKey, false);
    }

    public static void upgradeToXL(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.UPGRADE, "XL", licenseKey, true);
    }

    public static void upgradeToOne(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.UPGRADE, "One", licenseKey, true);
    }

    public static void renew(String licenseKey) {
        BrowseToUrl.go(PatervaUrl.RENEW, null, licenseKey, true);
    }

    public static void go(PatervaUrl url, String product, String licenseKey, boolean startLicensePolling) {
        BrowseToUrl.go(url.get(), product, licenseKey, startLicensePolling);
    }

    public static void go(String urlStr, String product, String licenseKey, boolean startLicensePolling) {
        try {
            URL url;
            if (startLicensePolling) {
                B.F();
            }
            StringBuilder sb = new StringBuilder(urlStr);
            String licenseEncrypted = null;
            if (!StringUtilities.isNullOrEmpty((String)licenseKey)) {
                long time = System.currentTimeMillis();
                String licensePart = licenseKey + "#" + time;
                licenseEncrypted = MaltegoClientCryptographer.getInstance().encryptAsymmetricToString(licensePart);
            }
            Version ver = Version.getCurrent();
            String branding = LicenseManager.A().B();
            ver.appendToUrl(sb, branding);
            String osName = System.getProperty("os.name");
            String java = System.getProperty("java.version");
            sb.append("&os=").append(BrowseToUrl.encode(osName));
            sb.append("&java=").append(BrowseToUrl.encode(java));
            if (!StringUtilities.isNullOrEmpty((String)product)) {
                sb.append("&product=").append(BrowseToUrl.encode(product));
            }
            if (!StringUtilities.isNullOrEmpty((String)licenseEncrypted)) {
                sb.append("&license=").append(BrowseToUrl.encode(licenseEncrypted));
            }
            if (!FileUtilities.isRemoteFileURL((URL)(url = new URL(sb.toString())))) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
    }
}

