/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.impl.CollectionNodes;
import com.paterva.maltego.graph.store.views.impl.CollectionNodesSerializer;
import com.paterva.maltego.graph.store.views.impl.UpdateLayout;
import com.paterva.maltego.graph.store.views.impl.UpdateView;
import com.paterva.maltego.graph.store.views.impl.structures.Pair;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class InMemoryCollectionNodes
implements CollectionNodes {
    private static final Logger LOG = Logger.getLogger(InMemoryCollectionNodes.class.getName());
    private final GraphID _graphID;
    private final Map<EntityID, ViewEntity> _viewEntities = new HashMap<EntityID, ViewEntity>();
    private final Map<LinkID, ViewLink> _viewLinks = new HashMap<LinkID, ViewLink>();
    private final Map<EntityID, EntityID> _modelEntityToViewEntity = new HashMap<EntityID, EntityID>();
    private final Map<LinkID, LinkID> _modelLinkToViewLink = new HashMap<LinkID, LinkID>();
    private final Set<EntityID> _viewEntitiesWithoutLinks = new HashSet<EntityID>();
    private final GraphStructureReader _modelStructureReader;
    private final GraphDataStoreReader _modelDataReader;
    private final UpdateLayout _updateLayout;
    private final UpdateView _updateView;

    public InMemoryCollectionNodes(GraphID graphID) throws GraphStoreException {
        this._graphID = graphID;
        GraphStore model = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
        this._modelStructureReader = model.getGraphStructureStore().getStructureReader();
        this._modelDataReader = model.getGraphDataStore().getDataStoreReader();
        this._updateLayout = new UpdateLayout(this);
        this._updateView = new UpdateView(this, this._graphID);
    }

    public GraphStructureMods loadFromSerializer() {
        GraphStructureMods mods = new GraphStructureMods();
        Map<EntityID, ViewEntity> loadedViewEntities = CollectionNodesSerializer.getInstance(this._graphID).getLoadedViewEntities();
        Map<LinkID, ViewLink> loadedViewLinks = CollectionNodesSerializer.getInstance(this._graphID).getLoadedViewLinks();
        this._viewEntities.clear();
        this._viewLinks.clear();
        this._viewEntities.putAll(loadedViewEntities);
        this._viewLinks.putAll(loadedViewLinks);
        this.repopulateHelperMaps();
        mods.getEntitiesAdded().addAll(this._viewEntities.keySet());
        mods.getLinksAdded().addAll(this._viewLinks.keySet());
        return mods;
    }

    private void repopulateHelperMaps() {
        Object value;
        EntityID key;
        this._modelEntityToViewEntity.clear();
        this._modelLinkToViewLink.clear();
        this._viewEntitiesWithoutLinks.clear();
        LinkedList<EntityID> viewEntitiesWithoutLinks = new LinkedList<EntityID>();
        for (Map.Entry<EntityID, ViewEntity> entry : this._viewEntities.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (((ViewEntity)value).isCollection()) {
                for (EntityID entityID : ((ViewEntity)value).getCollection()) {
                    this._modelEntityToViewEntity.put(entityID, key);
                }
            } else {
                this._modelEntityToViewEntity.put(key, key);
            }
            if (((ViewEntity)value).getAllLinks().hasViewOrModelLinks()) continue;
            viewEntitiesWithoutLinks.add(key);
        }
        this._viewEntitiesWithoutLinks.addAll(viewEntitiesWithoutLinks);
        for (Map.Entry<Object, Object> entry : this._viewLinks.entrySet()) {
            key = (LinkID)entry.getKey();
            value = (ViewLink)entry.getValue();
            if (((ViewLink)value).isCollection()) {
                for (LinkID linkID : ((ViewLink)value).getCollection()) {
                    this._modelLinkToViewLink.put(linkID, (LinkID)key);
                }
                continue;
            }
            this._modelLinkToViewLink.put((LinkID)key, (LinkID)key);
        }
    }

    public Map<EntityID, ViewEntity> getViewEntities() {
        return this._viewEntities;
    }

    public Map<LinkID, ViewLink> getViewLinks() {
        return this._viewLinks;
    }

    Map<EntityID, EntityID> getModelEntityToViewEntity() {
        return this._modelEntityToViewEntity;
    }

    Map<LinkID, LinkID> getModelLinkToViewLink() {
        return this._modelLinkToViewLink;
    }

    Set<EntityID> getViewEntitiesWithoutLinks() {
        return this._viewEntitiesWithoutLinks;
    }

    public GraphStructureReader getModelStructureReader() {
        return this._modelStructureReader;
    }

    GraphDataStoreReader getModelDataReader() {
        return this._modelDataReader;
    }

    @Override
    public boolean exists(EntityID entityID) {
        return this._viewEntities.containsKey(entityID);
    }

    @Override
    public boolean exists(LinkID linkID) {
        return this._viewLinks.containsKey(linkID);
    }

    @Override
    public Set<EntityID> getExistingEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashSet<EntityID> existing = new HashSet<EntityID>(entityIDs);
        existing.retainAll(this._viewEntities.keySet());
        return existing;
    }

    @Override
    public Set<LinkID> getExistingLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashSet<LinkID> existing = new HashSet<LinkID>(linkIDs);
        existing.retainAll(this._viewLinks.keySet());
        return existing;
    }

    @Override
    public boolean isCollectionEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        ViewEntity viewEnt = this._viewEntities.get(entityID);
        return viewEnt != null && viewEnt.isCollection();
    }

    @Override
    public boolean isCollectionLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        ViewLink viewLnk = this._viewLinks.get(linkID);
        return viewLnk != null && viewLnk.isCollection();
    }

    @Override
    public Set<EntityID> getEntities() throws GraphStoreException {
        return Collections.unmodifiableSet(this._viewEntities.keySet());
    }

    @Override
    public Set<LinkID> getLinks() throws GraphStoreException {
        return Collections.unmodifiableSet(this._viewLinks.keySet());
    }

    @Override
    public EntityID getSource(LinkID linkId) throws GraphStoreException {
        if (linkId == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return this._viewLinks.get(linkId).getEntities().getSourceID();
    }

    @Override
    public EntityID getTarget(LinkID linkId) throws GraphStoreException {
        if (linkId == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return this._viewLinks.get(linkId).getEntities().getTargetID();
    }

    @Override
    public LinkEntityIDs getEntities(LinkID linkId) throws GraphStoreException {
        if (linkId == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return this._viewLinks.get(linkId).getEntities();
    }

    @Override
    public Set<LinkID> getIncoming(EntityID entityId) throws GraphStoreException {
        return CollectionUtils.getIncoming(this._viewEntities, entityId);
    }

    @Override
    public Set<LinkID> getOutgoing(EntityID entityId) throws GraphStoreException {
        return CollectionUtils.getOutgoing(this._viewEntities, entityId);
    }

    @Override
    public Set<LinkID> getLinks(EntityID entityId) throws GraphStoreException {
        return CollectionUtils.getLinks(this._viewEntities, entityId);
    }

    @Override
    public boolean hasLinks(EntityID entityId) {
        return CollectionUtils.hasLinks(this._viewEntities, entityId);
    }

    @Override
    public int getLinkCount(EntityID entity) throws GraphStoreException {
        return CollectionUtils.getLinkCount(this._viewEntities, entity);
    }

    @Override
    public int getIncomingLinkCount(EntityID entity) throws GraphStoreException {
        return CollectionUtils.getIncomingLinkCount(this._viewEntities, entity);
    }

    @Override
    public int getOutgoingLinkCount(EntityID entity) throws GraphStoreException {
        return CollectionUtils.getOutgoingLinkCount(this._viewEntities, entity);
    }

    @Override
    public Set<EntityID> getChildren(EntityID entityID) throws GraphStoreException {
        return CollectionUtils.getChildren(this._viewEntities, this._viewLinks, entityID);
    }

    @Override
    public Set<EntityID> getParents(EntityID entityID) throws GraphStoreException {
        return CollectionUtils.getParents(this._viewEntities, this._viewLinks, entityID);
    }

    @Override
    public int getEntityCount() throws GraphStoreException {
        return this._viewEntities.size();
    }

    @Override
    public int getLinkCount() throws GraphStoreException {
        return this._viewLinks.size();
    }

    @Override
    public Map<LinkID, LinkEntityIDs> getEntities(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashMap<LinkID, LinkEntityIDs> entities = new HashMap<LinkID, LinkEntityIDs>();
        for (LinkID linkID : linkIDs) {
            ViewLink viewLink = this._viewLinks.get(linkID);
            if (viewLink == null) {
                throw new IllegalArgumentException("No view source/target entity exists for link '" + linkID + "' in the collection nodes");
            }
            entities.put(linkID, viewLink.getEntities());
        }
        return entities;
    }

    @Override
    public Map<LinkID, EntityID> getSources(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashMap<LinkID, EntityID> entities = new HashMap<LinkID, EntityID>();
        for (LinkID linkID : linkIDs) {
            ViewLink viewLink = this._viewLinks.get(linkID);
            if (viewLink == null) {
                throw new IllegalArgumentException("No view source entity exists for link '" + linkID + "' in the collection nodes");
            }
            entities.put(linkID, viewLink.getEntities().getSourceID());
        }
        return entities;
    }

    @Override
    public Map<LinkID, EntityID> getTargets(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashMap<LinkID, EntityID> entities = new HashMap<LinkID, EntityID>();
        for (LinkID linkID : linkIDs) {
            ViewLink viewLink = this._viewLinks.get(linkID);
            if (viewLink == null) {
                throw new IllegalArgumentException("No view target entity exists for link '" + linkID + "' in the collection nodes");
            }
            entities.put(linkID, viewLink.getEntities().getTargetID());
        }
        return entities;
    }

    @Override
    public Set<LinkID> getLinksBetween(Collection<EntityID> entityIDs) throws GraphStoreException {
        LinkedList<LinkID> linksList = new LinkedList<LinkID>();
        for (EntityID ent1 : entityIDs) {
            for (EntityID ent2 : entityIDs) {
                LinkID linkBetween = this.getLinkBetween(ent1, ent2);
                if (linkBetween == null) continue;
                linksList.add(linkBetween);
            }
        }
        return new HashSet<LinkID>(linksList);
    }

    @Override
    public Set<LinkID> getLinks(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashSet<LinkID> links = new HashSet<LinkID>();
        for (EntityID entityID : entityIDs) {
            links.addAll(this.getLinks(entityID));
        }
        return links;
    }

    @Override
    public Map<EntityID, Set<LinkID>> getLinksMap(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<LinkID>> links = new HashMap<EntityID, Set<LinkID>>();
        for (EntityID entityID : entityIDs) {
            links.put(entityID, this.getLinks(entityID));
        }
        return links;
    }

    @Override
    public Map<EntityID, Set<LinkID>> getOutgoing(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<LinkID>> outgoing = new HashMap<EntityID, Set<LinkID>>();
        for (EntityID entityID : entityIDs) {
            outgoing.put(entityID, this.getOutgoing(entityID));
        }
        return outgoing;
    }

    @Override
    public Map<EntityID, Set<LinkID>> getIncoming(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<LinkID>> incoming = new HashMap<EntityID, Set<LinkID>>();
        for (EntityID entityID : entityIDs) {
            incoming.put(entityID, this.getIncoming(entityID));
        }
        return incoming;
    }

    @Override
    public Map<EntityID, Set<EntityID>> getParents(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<EntityID>> parents = new HashMap<EntityID, Set<EntityID>>();
        for (EntityID entityID : entityIDs) {
            parents.put(entityID, this.getParents(entityID));
        }
        return parents;
    }

    @Override
    public Map<EntityID, Set<EntityID>> getChildren(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<EntityID>> children = new HashMap<EntityID, Set<EntityID>>();
        for (EntityID entityID : entityIDs) {
            children.put(entityID, this.getChildren(entityID));
        }
        return children;
    }

    @Override
    public Map<EntityID, Boolean> getPinned(Collection<EntityID> entityIDs) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getPinned(EntityID entityID) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<EntityID> getAllEntitiesWithoutLinks() throws GraphStoreException {
        LinkedList<EntityID> entitiesList = new LinkedList<EntityID>();
        for (Map.Entry<EntityID, ViewEntity> entry : this._viewEntities.entrySet()) {
            EntityID entity = entry.getKey();
            if (this.hasLinks(entity)) continue;
            entitiesList.add(entity);
        }
        return new HashSet<EntityID>(entitiesList);
    }

    @Override
    public Set<EntityID> getAllSingleLinkChildren(EntityID entityID) throws GraphStoreException {
        LinkedList<EntityID> entitiesList = new LinkedList<EntityID>();
        Set<EntityID> children = this.getChildren(entityID);
        for (EntityID child : children) {
            if (this.getLinkCount(child) != 1) continue;
            entitiesList.add(child);
        }
        return new HashSet<EntityID>(entitiesList);
    }

    public Map<EntityID, Set<EntityID>> getModelEntitiesMap(Collection<EntityID> entityIDs) throws GraphStoreException {
        if (entityIDs == null) {
            throw new IllegalArgumentException("Collection<EntityID> argument is null");
        }
        HashMap<EntityID, Set<EntityID>> m = new HashMap<EntityID, Set<EntityID>>();
        for (EntityID ent : entityIDs) {
            m.put(ent, this.getModelEntities(ent));
        }
        return Collections.unmodifiableMap(m);
    }

    public Set<EntityID> getModelEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        if (entityIDs == null) {
            throw new IllegalArgumentException("Collection<EntityID> argument is null");
        }
        HashSet<EntityID> s = new HashSet<EntityID>();
        for (EntityID ent : entityIDs) {
            s.addAll(this.getModelEntities(ent));
        }
        return Collections.unmodifiableSet(s);
    }

    public Set<EntityID> getModelEntities(EntityID entityID) throws GraphStoreException {
        Set<EntityID> s;
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        ViewEntity i = this._viewEntities.get(entityID);
        if (i != null && i.isCollection()) {
            s = i.getCollection();
        } else {
            s = new HashSet<EntityID>();
            s.add(entityID);
        }
        return Collections.unmodifiableSet(s);
    }

    public Map<LinkID, Set<LinkID>> getModelLinksMap(Collection<LinkID> linkIDs) throws GraphStoreException {
        if (linkIDs == null) {
            throw new IllegalArgumentException("Collection<LinkID> argument is null");
        }
        HashMap<LinkID, Set<LinkID>> m = new HashMap<LinkID, Set<LinkID>>();
        for (LinkID ent : linkIDs) {
            m.put(ent, this.getModelLinks(ent));
        }
        return Collections.unmodifiableMap(m);
    }

    public Set<LinkID> getModelLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        if (linkIDs == null) {
            throw new IllegalArgumentException("Collection<LinkID> argument is null");
        }
        HashSet<LinkID> s = new HashSet<LinkID>();
        for (LinkID l : linkIDs) {
            s.addAll(this.getModelLinks(l));
        }
        return Collections.unmodifiableSet(s);
    }

    public Set<LinkID> getModelLinks(LinkID linkID) throws GraphStoreException {
        Set<LinkID> s;
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        ViewLink i = this._viewLinks.get(linkID);
        if (i != null && i.isCollection()) {
            s = i.getCollection();
        } else {
            s = new HashSet<LinkID>();
            s.add(linkID);
        }
        return Collections.unmodifiableSet(s);
    }

    public Pair<EntityID, ViewEntity> getFirstViewEntityThatIsACollection(Set<EntityID> modelEntitiesToCollect) throws GraphStoreException {
        for (EntityID entityToCollect : modelEntitiesToCollect) {
            ViewEntity viewEntity;
            EntityID firstViewEntity = this.getViewEntity(entityToCollect);
            if (firstViewEntity == null || !(viewEntity = this._viewEntities.get(firstViewEntity)).isCollection()) continue;
            return new Pair<EntityID, ViewEntity>(firstViewEntity, viewEntity);
        }
        return null;
    }

    Pair<LinkID, ViewLink> getFirstViewLinkThatIsACollection(Set<LinkID> modelLinksToCollect) throws GraphStoreException {
        for (LinkID linkToCollect : modelLinksToCollect) {
            ViewLink viewLink;
            LinkID firstViewLink = this.getViewLink(linkToCollect);
            if (firstViewLink == null || !(viewLink = this._viewLinks.get(firstViewLink)).isCollection()) continue;
            return new Pair<LinkID, ViewLink>(firstViewLink, viewLink);
        }
        return null;
    }

    public Pair<LinkID, ViewLink> getFirstViewLinkThatIsACollection(Set<LinkID> links, EntityID source, EntityID target) throws GraphStoreException {
        for (LinkID linkToCollect : links) {
            LinkID firstViewLink = this.getViewLink(linkToCollect);
            if (firstViewLink == null) continue;
            ViewLink viewLink = this._viewLinks.get(firstViewLink);
            LinkEntityIDs entities = viewLink.getEntities();
            if (!viewLink.isCollection() || !entities.getSourceID().equals((Object)source) || !entities.getTargetID().equals((Object)target)) continue;
            return new Pair<LinkID, ViewLink>(firstViewLink, viewLink);
        }
        return null;
    }

    LinkID getLinkBetween(EntityID source, EntityID target) {
        for (Map.Entry<LinkID, ViewLink> entry : this._viewLinks.entrySet()) {
            LinkID link = entry.getKey();
            ViewLink viewLink = entry.getValue();
            LinkEntityIDs entities = viewLink.getEntities();
            if (!entities.getSourceID().equals((Object)source) || !entities.getTargetID().equals((Object)target)) continue;
            return link;
        }
        return null;
    }

    public EntityID getViewEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        return this._modelEntityToViewEntity.get(entityID);
    }

    public Pair<EntityID, ViewEntity> getViewEntityPair(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        EntityID viewEntity = this.getViewEntity(entityID);
        if (viewEntity != null) {
            return new Pair<EntityID, ViewEntity>(viewEntity, this._viewEntities.get(viewEntity));
        }
        return null;
    }

    public Set<EntityID> getViewEntitiesWithNoLinksUnmodifiable() {
        return Collections.unmodifiableSet(this._viewEntitiesWithoutLinks);
    }

    Map<EntityID, ViewEntity> getViewEntitiesWithNoLinksMap() {
        HashMap<EntityID, ViewEntity> entsWithNoLinks = new HashMap<EntityID, ViewEntity>();
        for (EntityID viewEntitiesWithoutLink : this._viewEntitiesWithoutLinks) {
            entsWithNoLinks.put(viewEntitiesWithoutLink, this._viewEntities.get(viewEntitiesWithoutLink));
        }
        return entsWithNoLinks;
    }

    public LinkID getViewLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return this._modelLinkToViewLink.get(linkID);
    }

    Pair<LinkID, ViewLink> getViewLinkPair(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        LinkID viewLink = this.getViewLink(linkID);
        if (viewLink != null) {
            return new Pair<LinkID, ViewLink>(viewLink, this._viewLinks.get(viewLink));
        }
        return null;
    }

    public boolean isModelAndViewEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        ViewEntity viewEntity = this._viewEntities.get(entityID);
        return viewEntity == null ? false : !viewEntity.isCollection();
    }

    public boolean isModelEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        ViewEntity viewEntity = this._viewEntities.get(entityID);
        if (viewEntity == null) {
            return this.getViewEntity(entityID) != null;
        }
        return !viewEntity.isCollection();
    }

    public boolean isViewEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        return this._viewEntities.containsKey(entityID);
    }

    public boolean isOnlyViewEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        return this.isCollectionEntity(entityID);
    }

    public boolean isOnlyModelEntity(EntityID entityID) throws GraphStoreException {
        if (entityID == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        return !this.isViewEntity(entityID);
    }

    public boolean isModelAndViewLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        ViewLink viewLink = this._viewLinks.get(linkID);
        return viewLink == null ? false : !viewLink.isCollection();
    }

    public boolean isModelLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        ViewLink viewLink = this._viewLinks.get(linkID);
        if (viewLink == null) {
            return this.getViewLink(linkID) != null;
        }
        return !viewLink.isCollection();
    }

    public boolean isViewLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return this._viewLinks.containsKey(linkID);
    }

    public boolean isOnlyViewLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return this.isCollectionLink(linkID);
    }

    public boolean isOnlyModelLink(LinkID linkID) throws GraphStoreException {
        if (linkID == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        return !this.isViewLink(linkID);
    }

    @Override
    public GraphLayoutMods update(GraphLayoutMods modelMods) throws GraphStoreException {
        return this._updateLayout.update(modelMods);
    }

    @Override
    public GraphStructureMods update(GraphStructureMods structureMods, GraphDataMods dataMods) throws GraphStoreException {
        return this._updateView.update(structureMods, dataMods);
    }

    @Override
    public GraphStructureMods recollectAll() throws GraphStoreException {
        return this._updateView.recollectAll();
    }

    @Override
    public Map<LinkID, ViewLink> getViewLinks(Collection<LinkID> modelLinks) {
        HashMap<LinkID, ViewLink> viewLinks = new HashMap<LinkID, ViewLink>();
        LinkedList<LinkID> modelLinkIDs = new LinkedList<LinkID>(modelLinks);
        while (!modelLinkIDs.isEmpty()) {
            LinkID modelLinkID = modelLinkIDs.pop();
            LinkID viewLinkID = this._modelLinkToViewLink.get(modelLinkID);
            ViewLink viewLink = this._viewLinks.get(viewLinkID);
            Set<LinkID> viewLinkSet = viewLink.getCollection();
            if (!viewLinkSet.isEmpty()) {
                modelLinkIDs.removeAll(viewLinkSet);
            }
            viewLinks.put(viewLinkID, viewLink);
        }
        return viewLinks;
    }
}

