/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.simpleframework.xml.stream.DocumentReader;
import org.simpleframework.xml.stream.EventReader;
import org.simpleframework.xml.stream.Provider;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DocumentProvider
implements Provider {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public DocumentProvider() {
        this.factory.setNamespaceAware(true);
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            this.factory.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            this.factory.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            this.factory.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            this.factory.setFeature(FEATURE, false);
            this.factory.setXIncludeAware(false);
            this.factory.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("ParserConfigurationException was thrown. The feature '" + FEATURE + "' is probably not supported by your XML processor.", e);
        }
    }

    @Override
    public EventReader provide(InputStream source) throws Exception {
        return this.provide(new InputSource(source));
    }

    @Override
    public EventReader provide(Reader source) throws Exception {
        return this.provide(new InputSource(source));
    }

    private EventReader provide(InputSource source) throws Exception {
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        try {
            return new DocumentReader(builder.parse(source));
        }
        catch (SAXException e) {
            throw new RuntimeException("A DOCTYPE was passed into the XML document, and this is blocked on purpose due to security issues", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred, XXE may still possible", e);
        }
    }
}

