/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.discovery.impl;

import com.paterva.maltego.archive.mtz.discover.DiscoveryEntityMerger;
import com.paterva.maltego.archive.mtz.discover.DiscoveryMergingRules;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryItems;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.IconUtils;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.discovery.TransformUpdater;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DefaultTransformUpdater
extends TransformUpdater {
    private static final Logger LOGGER = Logger.getLogger(DefaultTransformUpdater.class.getName());

    @Override
    public void removeMissing(TransformServerListing[] listings) {
        TransformServerRegistry servers = TransformServerRegistry.getDefault();
        for (TransformServerListing listing : listings) {
            TransformServerInfo tas = servers.get(listing.getBaseUrl());
            if (tas == null) continue;
            HashSet<String> toRemove = new HashSet<String>();
            for (String transform : tas.getTransforms()) {
                boolean found = false;
                for (TransformDescriptor td : listing.getTransforms()) {
                    if (!transform.equals(td.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(transform);
            }
            tas.getTransforms().removeAll(toRemove);
            tas.setDirty();
            for (String transform : toRemove) {
                TransformRepositoryRegistry.getDefault().removeTransform(transform);
            }
        }
    }

    @Override
    public void updateServers(TransformServerListing[] listings) {
        TransformServerRegistry servers = TransformServerRegistry.getDefault();
        for (TransformServerListing listing : listings) {
            TransformServerInfo tas = servers.get(listing.getBaseUrl());
            if (tas == null) {
                tas = new TransformServerInfo(listing.getSeedUrl(), listing.getBaseUrl(), listing.getName());
            } else {
                tas.addSeedUrl(listing.getSeedUrl());
            }
            servers.put(tas);
        }
    }

    @Override
    public void removeMissingServers(TransformServerReference[] servers) {
        Map serversBySeed = Arrays.stream(servers).collect(Collectors.groupingBy(server -> server.getSeedUrl(), Collectors.mapping(server -> server.getBaseUrl(), Collectors.toSet())));
        TransformServerRegistry registry = TransformServerRegistry.getDefault();
        ArrayList allServers = new ArrayList(registry.getAll());
        for (TransformServerInfo server2 : allServers) {
            ArrayList seedUrls = new ArrayList(server2.getSeedUrls());
            for (String seedUrl : seedUrls) {
                FastURL serverUrl;
                Set seedServers = serversBySeed.get(seedUrl);
                if (seedServers == null || seedServers.contains(serverUrl = server2.getUrl())) continue;
                server2.removeSeedUrl(seedUrl);
                if (!server2.getSeedUrls().isEmpty()) continue;
                LOGGER.log(Level.INFO, "Removing server since it is no longer associated with any seeds: {0}", serverUrl);
                registry.remove(serverUrl);
            }
        }
    }

    @Override
    public void update(HubSeedDescriptor hubSeed, TransformServerListing[] listings, DiscoveryMergingRules rules) throws IOException {
        TransformServerRegistry servers = TransformServerRegistry.getDefault();
        for (TransformServerListing listing : listings) {
            HubSeedDescriptor seed = hubSeed;
            if (seed == null) {
                seed = HubSeedRegistry.getDefault().getHubSeed(listing.getSeedUrl());
            }
            TransformServerInfo tas = servers.get(listing.getBaseUrl());
            DefaultTransformUpdater.updateTas(seed, tas, listing);
            servers.put(tas);
            this.updateDescriptors(seed, listing.getTransforms());
            this.createNewSets(listing.getSets());
            this.updateSets(listing.getTransforms());
            this.updateEntities(listing.getEntities(), rules);
            this.updateMtzItems(listing.getMtzDiscoveryItems());
            this.updateAuthenticators(seed, listing.getTransforms(), listing.getPublicWebServices());
        }
        for (MtzDiscoveryProvider mtzDiscoveryProvider : MtzDiscoveryProvider.getAll()) {
            mtzDiscoveryProvider.cleanup();
        }
    }

    private static void updateTas(HubSeedDescriptor hubSeed, TransformServerInfo tas, TransformServerListing listing) {
        tas.setAuthentication(listing.getAuthentication());
        tas.setDescription(listing.getDescription());
        tas.setDisplayName(listing.getName());
        tas.setLastSync(new Date(System.currentTimeMillis()));
        tas.setProtocolVersion(listing.getProtocolVersion());
        for (TransformDescriptor td : listing.getTransforms()) {
            if (hubSeed != null) {
                List hubSeeds = HubSeedRegistry.getDefault().getHubSeeds(td);
                for (HubSeedDescriptor hs : hubSeeds) {
                    if (hubSeed.equals((Object)hs)) continue;
                    listing.getDuplicateTransforms().put(td, hs);
                }
            }
            tas.getTransforms().add(td.getName());
        }
    }

    private void updateEntities(Set<MaltegoEntitySpec> otherSpecs, DiscoveryMergingRules rules) {
        EntityRegistry registry = EntityRegistry.getDefault();
        Iterator<MaltegoEntitySpec> itr = otherSpecs.iterator();
        while (itr.hasNext()) {
            MaltegoEntitySpec newSpec = itr.next();
            boolean isNew = DiscoveryEntityMerger.merge((EntityRegistry)registry, (MaltegoEntitySpec)newSpec, (DiscoveryMergingRules.EntityRule)rules.getEntityRule());
            if (isNew) continue;
            itr.remove();
        }
    }

    private void updateMtzItems(Set<MtzDiscoveryItems> items) {
        Iterator<MtzDiscoveryItems> itr = items.iterator();
        while (itr.hasNext()) {
            MtzDiscoveryItems mtzItems = itr.next();
            MtzDiscoveryProvider provider = mtzItems.getProvider();
            provider.apply(mtzItems);
            if (!mtzItems.isEmpty()) continue;
            itr.remove();
        }
    }

    private void updateDescriptors(HubSeedDescriptor hubSeed, Set<TransformDescriptor> transforms) throws IOException {
        TransformRepository repository = TransformRepositoryRegistry.getDefault().getOrCreateRepository("Remote");
        for (TransformDescriptor descriptor : transforms) {
            String transformUrl;
            if (hubSeed != null && hubSeed.getHelp() != null && (transformUrl = hubSeed.getHelp().getTransformUrl()) != null) {
                descriptor.setHelpUrl(transformUrl.replace("${transformId}", descriptor.getName()));
            }
            repository.put(descriptor);
        }
    }

    private void createNewSets(Set<TransformSet> sets) throws IOException {
        TransformSetRepository repository = TransformSetRepository.getDefault();
        for (TransformSet set : sets) {
            if (repository.contains(set.getName())) continue;
            repository.put(set);
        }
    }

    private void updateSets(Set<TransformDescriptor> transforms) throws IOException {
        TransformSetRepository repository = TransformSetRepository.getDefault();
        for (TransformDescriptor descriptor : transforms) {
            for (String setName : descriptor.getDefaultSets()) {
                TransformSet set = repository.get(setName);
                if (set == null) {
                    set = new TransformSet(setName);
                }
                set.addTransform(descriptor.getName());
                repository.put(set);
            }
        }
    }

    @Override
    public TransformServerListing[] getNew(TransformServerListing[] listings, DiscoveryMergingRules rules) {
        ArrayList<TransformServerListing> remaining = new ArrayList<TransformServerListing>();
        TransformServerRegistry servers = TransformServerRegistry.getDefault();
        TransformRepositoryRegistry transformRegistry = TransformRepositoryRegistry.getDefault();
        for (TransformServerListing listing : listings) {
            FastURL source = listing.getBaseUrl();
            LOGGER.log(Level.INFO, "server: {0}", source);
            TransformServerInfo tas = servers.get(source);
            Set<TransformDescriptor> transforms = listing.getTransforms();
            Set<MtzDiscoveryItems> mtzItems = listing.getMtzDiscoveryItems();
            Map<PublicWebService, String> services = listing.getPublicWebServices();
            if (tas != null) {
                int transformDiscovered = transforms.size();
                TransformDescriptor[] descriptors = transforms.toArray(new TransformDescriptor[transforms.size()]);
                transforms.clear();
                for (TransformDescriptor desc : descriptors) {
                    TransformDefinition registeredDesc = transformRegistry.findTransform(desc.getName());
                    if (desc.isCopy((TransformDescriptor)registeredDesc)) continue;
                    transforms.add(desc);
                }
                int transformsNew = transforms.size();
                LOGGER.log(Level.INFO, "  {0}/{1} Transforms", new Object[]{transformsNew, transformDiscovered});
                HashSet<MtzDiscoveryItems> newMtzItems = new HashSet<MtzDiscoveryItems>(mtzItems);
                mtzItems.clear();
                for (MtzDiscoveryItems items : newMtzItems) {
                    MtzDiscoveryProvider provider = items.getProvider();
                    int itemsDiscovered = items.size();
                    items = provider.getNewAndMerged(items);
                    int itemsNew = items.size();
                    LOGGER.log(Level.INFO, "  {0}/{1} {2}", new Object[]{itemsNew, itemsDiscovered, items.getDescription()});
                    if (items.isEmpty()) continue;
                    mtzItems.add(items);
                }
                HashMap<PublicWebService, String> newServices = new HashMap<PublicWebService, String>(services);
                services.clear();
                PublicWebServices servicesRegistry = PublicWebServices.getDefault();
                for (Map.Entry entry : newServices.entrySet()) {
                    if (servicesRegistry.get(((PublicWebService)entry.getKey()).getName()) != null) continue;
                    services.put((PublicWebService)entry.getKey(), (String)entry.getValue());
                }
                LOGGER.log(Level.INFO, "  {0}/{1} Services", new Object[]{services.size(), newServices.size()});
            }
            if (transforms.isEmpty() && mtzItems.isEmpty() && services.isEmpty()) continue;
            remaining.add(listing);
        }
        return remaining.toArray(new TransformServerListing[remaining.size()]);
    }

    private void updateAuthenticators(HubSeedDescriptor hubSeed, Set<TransformDescriptor> transforms, Map<PublicWebService, String> publicWebServices) throws IOException {
        Set<String> authenticators = this.getAuthenticatorNames(transforms);
        this.removeMissing(publicWebServices, authenticators);
        this.importAuthenticators(hubSeed, "OAuth", publicWebServices);
    }

    private Set<String> getAuthenticatorNames(Set<TransformDescriptor> transforms) {
        HashSet<String> authenticators = new HashSet<String>();
        for (TransformDescriptor td : transforms) {
            String auth = td.getAuthenticator();
            if (StringUtilities.isNullOrEmpty((String)auth)) continue;
            authenticators.add(auth);
        }
        TransformRepository repository = TransformRepositoryRegistry.getDefault().getRepository("Remote");
        authenticators.addAll(this.getAuthenticators(repository));
        repository = TransformRepositoryRegistry.getDefault().getRepository("Local");
        authenticators.addAll(this.getAuthenticators(repository));
        return authenticators;
    }

    private Set<String> getAuthenticators(TransformRepository repository) {
        HashSet<String> auths = new HashSet<String>();
        if (repository != null) {
            for (TransformDefinition transform : repository.getAll()) {
                String auth = transform.getAuthenticator();
                if (StringUtilities.isNullOrEmpty((String)auth)) continue;
                auths.add(auth);
            }
        }
        return auths;
    }

    private void removeMissing(Map<PublicWebService, String> publicWebServices, Set<String> authenticators) {
        Set<Map.Entry<PublicWebService, String>> entrySet = publicWebServices.entrySet();
        Iterator<Map.Entry<PublicWebService, String>> itr = entrySet.iterator();
        while (itr.hasNext()) {
            PublicWebService pws = itr.next().getKey();
            String name = pws.getName();
            if (authenticators.contains(name)) continue;
            itr.remove();
        }
    }

    private void importAuthenticators(HubSeedDescriptor hubSeed, String type, Map<PublicWebService, String> publicWebServices) throws IOException {
        PublicWebServices services = PublicWebServices.getDefault();
        Iterator<Map.Entry<PublicWebService, String>> itr = publicWebServices.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<PublicWebService, String> entry = itr.next();
            PublicWebService pws = entry.getKey();
            String iconName = this.getIconName(pws);
            pws.setIconName(iconName);
            String imageBase64 = entry.getValue();
            this.importIcon(hubSeed, iconName, imageBase64);
            if (services.replace(type, pws.getName(), pws)) continue;
            itr.remove();
        }
    }

    private void importIcon(HubSeedDescriptor hubSeed, String iconName, String imageBase64) throws IOException {
        String iconCategory = "Accounts";
        IconRegistry iconRegistry = IconRegistry.getDefault();
        Optional iconOpt = iconRegistry.findRegistryIcon(new VirtualIcon(iconCategory, iconName));
        LinkedHashSet<String> hubItems = new LinkedHashSet<String>();
        if (iconOpt.isPresent()) {
            RegistryIcon icon = (RegistryIcon)iconOpt.get();
            iconRegistry.remove(icon);
            hubItems.addAll(icon.getHubItems());
        }
        BufferedImage image = ImageUtils.base64Decode((String)imageBase64);
        Map sizedIcons = IconUtils.createSizedIcons((Image)image);
        RegistryIcon icon = iconRegistry.addFromImages(iconCategory, iconName, sizedIcons);
        if (hubSeed != null) {
            hubItems.add(hubSeed.getName());
        }
        iconRegistry.setHubItems(icon, hubItems);
    }

    private String getIconName(PublicWebService service) {
        String iconName = service.getName() + ".discovered.icon";
        return IconUtils.makeValidIconName((String)iconName);
    }
}

