/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.discovery;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import org.openide.util.Lookup;

public abstract class TransformFinder {
    public static TransformFinder getDefault() {
        TransformFinder finder = (TransformFinder)Lookup.getDefault().lookup(TransformFinder.class);
        if (finder == null) {
            return new TrivialFinder();
        }
        return finder;
    }

    public DiscoveryResult<TransformServerReference> findServers(TransformSeed[] seeds) throws DiscoveryException {
        return this.findServers(seeds, null);
    }

    public abstract DiscoveryResult<TransformServerReference> findServers(TransformSeed[] var1, ProgressCallback var2) throws DiscoveryException;

    public DiscoveryResult<TransformServerDetail> getDetails(TransformServerReference[] references) throws DiscoveryException {
        return this.getDetails(references, null);
    }

    public abstract DiscoveryResult<TransformServerDetail> getDetails(TransformServerReference[] var1, ProgressCallback var2) throws DiscoveryException;

    public DiscoveryResult<TransformServerListing> listTransforms(TransformServerDetail[] references) throws DiscoveryException {
        return this.listTransforms(references, null);
    }

    public abstract DiscoveryResult<TransformServerListing> listTransforms(TransformServerDetail[] var1, ProgressCallback var2) throws DiscoveryException;

    private static class TrivialFinder
    extends TransformFinder {
        private TrivialFinder() {
        }

        @Override
        public DiscoveryResult<TransformServerReference> findServers(TransformSeed[] seeds, ProgressCallback cb) {
            throw new UnsupportedOperationException("No TransformFinder registered.");
        }

        @Override
        public DiscoveryResult<TransformServerDetail> getDetails(TransformServerReference[] references, ProgressCallback cb) {
            throw new UnsupportedOperationException("No TransformFinder registered.");
        }

        @Override
        public DiscoveryResult<TransformServerListing> listTransforms(TransformServerDetail[] references, ProgressCallback cb) {
            throw new UnsupportedOperationException("No TransformFinder registered.");
        }
    }
}

