/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformsCallback;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openide.util.Exceptions;

public class TransformsRunContext {
    private final GraphID targetGraphID;
    private final List<TransformDefinition> transforms;
    private final Map<EntityID, MaltegoEntity> allInputEntities;
    private final EntityRegistry entityRegistry;
    private final EntityFactory entityFactory;
    private final LinkFactory linkFactory;
    private final boolean popupErrors;
    private final TransformsCallback callback;

    public TransformsRunContext(GraphID targetGraphID, Collection<TransformDefinition> transforms, Map<EntityID, MaltegoEntity> inputEntities, EntityRegistry entityRegistry, EntityFactory entityFactory, LinkFactory linkFactory, boolean popupErrors) {
        this(targetGraphID, transforms, inputEntities, entityRegistry, entityFactory, linkFactory, popupErrors, null);
    }

    public TransformsRunContext(GraphID targetGraphID, Collection<TransformDefinition> transforms, Map<EntityID, MaltegoEntity> inputEntities, EntityRegistry entityRegistry, EntityFactory entityFactory, LinkFactory linkFactory, boolean popupErrors, TransformsCallback callback) {
        Args.notNull((Object)targetGraphID, (String)"targetGraphID");
        Args.notNull(transforms, (String)"transforms");
        Args.notNull(inputEntities, (String)"inputEntities");
        Args.notNull((Object)entityRegistry, (String)"entityRegistry");
        Args.notNull((Object)entityFactory, (String)"entityFactory");
        Args.notNull((Object)linkFactory, (String)"linkFactory");
        this.targetGraphID = targetGraphID;
        this.transforms = Collections.unmodifiableList(new ArrayList<TransformDefinition>(transforms));
        this.allInputEntities = Collections.unmodifiableMap(new LinkedHashMap<EntityID, MaltegoEntity>(inputEntities));
        this.entityRegistry = entityRegistry;
        this.entityFactory = entityFactory;
        this.linkFactory = linkFactory;
        this.popupErrors = popupErrors;
        this.callback = callback;
    }

    public GraphID getTargetGraphID() {
        return this.targetGraphID;
    }

    public List<TransformDefinition> getTransforms() {
        return this.transforms;
    }

    public Map<EntityID, MaltegoEntity> getAllInputEntities() {
        return this.allInputEntities;
    }

    public EntityRegistry getEntityRegistry() {
        return this.entityRegistry;
    }

    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public LinkFactory getLinkFactory() {
        return this.linkFactory;
    }

    public boolean isPopupErrors() {
        return this.popupErrors;
    }

    public Optional<TransformsCallback> getCallback() {
        return Optional.ofNullable(this.callback);
    }

    public void onTransformResultAddedToTargetGraph(TransformRunContext ctx, Collection<MaltegoEntity> newEntities, Collection<MaltegoEntity> mergedEntities) {
        this.getCallback().ifPresent(cb -> {
            try {
                cb.onTransformResultAddedToTargetGraph(ctx, newEntities, mergedEntities);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        });
    }

    public void onTransformError(TransformRunContext ctx, List<TransformMessage> messages) {
        this.getCallback().ifPresent(cb -> {
            try {
                cb.onTransformError(ctx, messages);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        });
    }

    public void onTransformComplete(TransformRunContext ctx) {
        this.getCallback().ifPresent(cb -> {
            try {
                cb.onTransformComplete(ctx);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        });
    }
}

