/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformsCallback;
import com.paterva.maltego.transform.runner.api.TransformsHandle;
import com.paterva.maltego.typing.DataSource;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;

public abstract class TransformRunManager {
    public static TransformRunManager getDefault() {
        TransformRunManager manager = (TransformRunManager)Lookup.getDefault().lookup(TransformRunManager.class);
        if (manager == null) {
            throw new IllegalStateException("TransformRunManager not found");
        }
        return manager;
    }

    public abstract TransformsHandle runTransforms(GraphID var1, Map<TransformDefinition, TransformServerInfo> var2, Map<TransformDefinition, DataSource> var3, Set<EntityID> var4, EntityRegistry var5, EntityFactory var6, LinkFactory var7, boolean var8, TransformsCallback var9);

    public TransformsHandle runTransform(GraphID targetGraphID, TransformDefinition transform, TransformServerInfo server, DataSource inputs, Set<EntityID> entityIDs, EntityRegistry entityRegistry, EntityFactory entityFactory, LinkFactory linkFactory, boolean popupErrors, TransformsCallback callback) {
        Map<TransformDefinition, TransformServerInfo> transforms = Collections.singletonMap(transform, server);
        Map<TransformDefinition, DataSource> transformInputs = Collections.singletonMap(transform, inputs);
        return this.runTransforms(targetGraphID, transforms, transformInputs, entityIDs, entityRegistry, entityFactory, linkFactory, false, callback);
    }

    public abstract void cancel(TransformsHandle var1);

    public abstract boolean isRunning(TransformsHandle var1);
}

