/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.transform.protocol.v2api.api.OAuthAuthenticatorInfo;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListResponse;
import java.util.ArrayList;
import java.util.Collection;

public class AuthenticatorTranslator {
    public Collection<OAuthAuthenticatorInfo> translateOAuth(TransformListResponse.AuthenticatorsDescriptor descriptor) {
        ArrayList<OAuthAuthenticatorInfo> info = new ArrayList<OAuthAuthenticatorInfo>();
        if (descriptor != null) {
            for (TransformListResponse.OAuthDescriptor d : descriptor.getOAuthAuthenticators()) {
                info.add(this.translate(d));
            }
        }
        return info;
    }

    private OAuthAuthenticatorInfo translate(TransformListResponse.OAuthDescriptor descriptor) {
        OAuthAuthenticatorInfo info = new OAuthAuthenticatorInfo();
        info.setAccessTokenEndpoint(descriptor.getAccessTokenEndpoint());
        info.setAccessTokenInput(descriptor.getAccessTokenInput());
        info.setAccessTokenPublicKey(descriptor.getAccessTokenPublicKey());
        info.setAppKey(descriptor.getAppKey());
        info.setAppSecret(descriptor.getAppSecret());
        info.setAuthorizationUrl(descriptor.getAuthorizationUrl());
        info.setCallbackPort(descriptor.getCallbackPort());
        info.setDescription(descriptor.getDescription());
        info.setDisplayName(descriptor.getDisplayName());
        info.setIcon(descriptor.getIcon());
        info.setName(descriptor.getName());
        info.setOAuthVersion(descriptor.getOAuthVersion());
        info.setRefreshTokenEndpoint(descriptor.getRefreshTokenEndpoint());
        info.setRequestTokenEndpoint(descriptor.getRequestTokenEndpoint());
        info.setRequestTypeForAccessToken(descriptor.getRequestTypeForAccessToken());
        info.setRequestTypeForAuthorizationUrl(descriptor.getRequestTypeForAuthorizationUrl());
        info.setRequestTypeForRequestToken(descriptor.getRequestTypeForRequestToken());
        info.setUseSSLHost(descriptor.useSSLHost());
        info.setUseClientAuthorizationHeader(descriptor.useClientAuthorizationHeader());
        return info;
    }
}

