/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.messaging;

import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;

public class MessagingHelper {
    private static final boolean ENABLE_RECEIVE_LOGGING = false;
    private static final boolean ENABLE_SEND_LOGGING = false;
    private static final Logger LOGGER = Logger.getLogger(MessagingHelper.class.getName());
    private static Schema schema;

    private MessagingHelper() {
    }

    public static MaltegoMessageWrapper read(InputStream stream, String encoding) throws IOException {
        if (encoding != null && encoding.contains("gzip")) {
            stream = new GZIPInputStream(stream);
        }
        return MessagingHelper.read(stream);
    }

    public static MaltegoMessageWrapper read(InputStream stream) throws IOException {
        String readBuffer = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        return MessagingHelper.read(readBuffer);
    }

    public static void write(MaltegoMessageWrapper wrapper, OutputStream stream) throws IOException {
        MessagingHelper.serializer().write((Object)wrapper, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MaltegoMessageWrapper read(String output) throws XmlSerializationException, IOException {
        if (StringUtilities.isNullOrEmpty((String)output)) {
            throw new IOException("<Empty Response>");
        }
        try {
            block43: {
                StringReader reader;
                block44: {
                    reader = new StringReader(output);
                    Throwable throwable = null;
                    try {
                        Validator validator = schema.newValidator();
                        validator.validate(new StreamSource(reader));
                        if (reader == null) break block43;
                        if (throwable == null) break block44;
                    }
                    catch (Throwable validator) {
                        try {
                            throwable = validator;
                            throw validator;
                        }
                        catch (Throwable throwable2) {
                            if (reader == null) throw throwable2;
                            if (throwable == null) {
                                ((Reader)reader).close();
                                throw throwable2;
                            }
                            try {
                                ((Reader)reader).close();
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                throw throwable2;
                            }
                        }
                    }
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable validator) {
                        throwable.addSuppressed(validator);
                    }
                }
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "MaltegoMessage failed XSD Schema Validation: " + e.getMessage());
        }
        finally {
            try (StringReader reader = new StringReader(output);){
                MaltegoMessageWrapper wrapper;
                MaltegoMessageWrapper maltegoMessageWrapper = wrapper = (MaltegoMessageWrapper)MessagingHelper.serializer().read(MaltegoMessageWrapper.class, (Reader)reader);
                return maltegoMessageWrapper;
            }
        }
    }

    private static XmlSerializer serializer() {
        return new XmlSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(MaltegoMessageWrapper wrapper) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        String result = null;
        try {
            MessagingHelper.write(wrapper, stream);
            is = new ByteArrayInputStream(stream.toByteArray());
            result = MessagingHelper.toString(is);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                stream.close();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(InputStream is) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return sb.toString();
    }

    static {
        try {
            URL xsdResource = MessagingHelper.class.getClassLoader().getResource("com/paterva/maltego/transform/protocol/v2api/messaging/MaltegoDomain.xsd");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = schemaFactory.newSchema(xsdResource);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to load Maltego XSD Schema", e);
        }
    }
}

