/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.api;

import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryInfo;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryResult;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryServer;
import com.paterva.maltego.transform.protocol.v2api.api.ProgressEvent;
import com.paterva.maltego.transform.protocol.v2api.api.ProgressListener;
import com.paterva.maltego.transform.protocol.v2api.api.TransformApplicationDescriptor;
import com.paterva.maltego.transform.protocol.v2api.api.TransformSource;
import com.paterva.maltego.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscoveryStrategy {
    private static final Logger LOG = Logger.getLogger(DiscoveryStrategy.class.getName());
    private final List<ProgressListener> _listeners = Collections.synchronizedList(new LinkedList());
    private final ExecutorService _executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("List Transforms"));

    public DiscoveryResult doDiscovery(TransformSource source, Collection<DiscoveryServer> servers) {
        List<TransformApplicationDescriptor> results = Collections.synchronizedList(new ArrayList());
        List<Exception> errors = Collections.synchronizedList(new ArrayList());
        for (DiscoveryServer server : servers) {
            this.findServers(server.getUrl().toString(), source, server, results, errors);
        }
        this._executor.shutdown();
        try {
            this._executor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return new DiscoveryResult(results, errors);
    }

    public void addProgressListener(ProgressListener pcl) {
        this._listeners.add(pcl);
    }

    public void removeProgressListener(ProgressListener pcl) {
        this._listeners.remove(pcl);
    }

    private void fireProgress(String message) {
        ProgressListener[] pcls;
        for (ProgressListener pcl : pcls = this._listeners.toArray(new ProgressListener[0])) {
            pcl.handleProgress(new ProgressEvent(this, message));
        }
    }

    private void findServers(String seedUrl, TransformSource source, DiscoveryServer startServer, List<TransformApplicationDescriptor> foundApps, List<Exception> errors) {
        this._executor.execute(() -> {
            try {
                this.fireProgress("Trying... " + startServer);
                String serverUrl = startServer.getUrl().toString();
                boolean isRootUrl = seedUrl.equals(serverUrl);
                DiscoveryInfo info = source.getDiscoveryInfo(seedUrl, serverUrl, !isRootUrl);
                foundApps.addAll(info.getApplications());
                int appsFound = info.getApplications().size();
                this.fireProgress("Found " + appsFound + " applications.");
                for (DiscoveryServer server : info.getServers()) {
                    try {
                        this.findServers(seedUrl, source, server, foundApps, errors);
                    }
                    catch (Exception ex) {
                        errors.add(ex);
                    }
                }
            }
            catch (CertificateNeedValidationException ex) {
                errors.add((Exception)((Object)ex));
            }
            catch (Exception ex) {
                errors.add(ex);
                LOG.log(Level.WARNING, "Error during discovery: {0}", ex.getMessage());
            }
        });
    }
}

