/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.protocol.v2api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v2api.EntityTranslator;
import com.paterva.maltego.transform.protocol.v2api.V2TransformRunner;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInput;
import com.paterva.maltego.transform.protocol.v2api.messaging.EntityDescriptor;
import com.paterva.maltego.transform.protocol.v2api.messaging.GenealogyType;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformRequest;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponse;
import com.paterva.maltego.transform.protocol.v2api.remote.ValueConverter;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.transform.runner.api.TransformTimeout;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openide.util.RequestProcessor;

class RemoteTransformRunner
extends V2TransformRunner {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("V2 Transform Server", 10, true);
    private final Proxy _proxy;
    private final String _transformName;
    private final TransformInput _input;
    private final String _forcedTypeName;

    public RemoteTransformRunner(GraphID graphID, TransformDescriptor transform, EntityFactory factory, EntityRegistry registry, Proxy proxy, String transformName, TransformInput transformInput, String forcedTypeName) {
        super(graphID, transform, factory, registry);
        this._input = transformInput;
        this._transformName = transformName;
        this._proxy = proxy;
        this._forcedTypeName = forcedTypeName;
    }

    @Override
    protected MaltegoMessageWrapper runTransform(MaltegoEntity input) throws TransformRunException, IOException {
        try {
            MaltegoMessageWrapper request = this.createRequest(input, this._input);
            if (Thread.interrupted()) {
                return null;
            }
            MaltegoMessageWrapper wrapper = this._proxy.doTransform(this._transformName, request, this._input.getKey(), this.getTimeout());
            this.limitEntities(wrapper);
            if (Thread.interrupted()) {
                return null;
            }
            return wrapper;
        }
        catch (Exception ex) {
            if (ex instanceof TransformRunException) {
                throw (TransformRunException)((Object)ex);
            }
            throw new TransformRunException(ex);
        }
    }

    private int getTimeout() {
        Object timeoutValue = this._input.getTransformParameters().get("maltego.transform.timeout");
        int timeout = -1;
        if (timeoutValue instanceof Integer) {
            timeout = (Integer)timeoutValue;
        }
        return timeout >= 0 ? timeout : TransformTimeout.getTimeout();
    }

    private MaltegoMessageWrapper createRequest(MaltegoEntity input, TransformInput transformInput) throws Exception {
        TransformRequest request = new TransformRequest();
        String actualType = input.getTypeName();
        if (!StringUtilities.isNullOrEmpty((String)this._forcedTypeName)) {
            input = input.createClone();
            input.setTypeName(this._forcedTypeName);
        }
        EntityDescriptor entity = EntityTranslator.instance().translate(input, this.getRegistry());
        this.addTypes(entity, actualType);
        request.getEntities().add(entity);
        request.setLimits(new TransformRequest.Limit(transformInput.getSoftLimit(), transformInput.getHardLimit()));
        RemoteTransformRunner.copyInputs(request, transformInput.getTransformParameters());
        return new MaltegoMessageWrapper(request);
    }

    private static void copyInputs(TransformRequest request, Map<String, Object> inputs) throws Exception {
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            TransformRequest.Input input = new TransformRequest.Input();
            input.setName(entry.getKey());
            Object value = entry.getValue();
            input.setValue(value == null ? "" : ValueConverter.write(value, value.getClass()));
            request.getInputs().add(input);
        }
    }

    @Override
    protected RequestProcessor processor() {
        return PROCESSOR;
    }

    private void limitEntities(MaltegoMessageWrapper wrapper) {
        Collection<EntityDescriptor> entities;
        TransformResponse response;
        A licenseMode = LicenseManager.A().A(false);
        if (licenseMode.Q() && (response = wrapper.getTransformResponse()) != null && (entities = response.getEntities()) != null && entities.size() > 12) {
            ArrayList<EntityDescriptor> entitiesList = new ArrayList<EntityDescriptor>(entities);
            entities.clear();
            entities.addAll(entitiesList.subList(0, 12));
        }
    }

    private void addTypes(EntityDescriptor entity, String actualType) {
        List<GenealogyType> genealogyTypes = entity.getGenealogy().getTypes();
        List types = InheritanceHelper.getInheritanceList((SpecRegistry)this.getRegistry(), (String)actualType);
        for (String type : types) {
            if ("maltego.Unknown".equals(type)) continue;
            String oldName = EntitySpecTranslator.getV2TypeName(type);
            if (type.equals(oldName)) {
                oldName = null;
            }
            String displayName = null;
            GenealogyType genealogyType = new GenealogyType(type, displayName, oldName);
            genealogyTypes.add(genealogyType);
        }
    }
}

