/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.transform.protocol.v2api.EntityPropertyMapper;
import com.paterva.maltego.transform.protocol.v2api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalField;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalFieldCollection;
import com.paterva.maltego.transform.protocol.v2api.messaging.DisplayInfo;
import com.paterva.maltego.transform.protocol.v2api.messaging.DisplayInfoCollection;
import com.paterva.maltego.transform.protocol.v2api.messaging.EntityDescriptor;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntityTranslator {
    private static final PropertyDescriptor ICON_URL_PROPERTY = new DisplayDescriptor(String.class, "icon-url", "Image");
    private static EntityTranslator _instance;
    private final EntityPropertyMapper[] _mappings = new EntityPropertyMapper[]{new EntityPropertyMapper.Type("maltego.Person", new String[]{"person.firstnames", "person.lastname"}, new String[]{"firstname", "lastname"}), new EntityPropertyMapper.Type("maltego.Domain", new String[]{"whois-info"}, new String[]{"whois"}), new EntityPropertyMapper.Type("maltego.IPv4Address", new String[]{"whois-info"}, new String[]{"whois"}), new EntityPropertyMapper.Type("maltego.URL", new String[]{"short-title", "url", "title"}, new String[]{"maltego.v2.value.property", "theurl", "fulltitle"}), new EntityPropertyMapper.Type("maltego.Document", new String[]{"title", "url", "document.meta-data"}, new String[]{"maltego.v2.value.property", "link", "metainfo"}), new EntityPropertyMapper.Type("maltego.Location", new String[]{"country", "city", "location.area", "countrycode", "longitude", "latitude"}, new String[]{"country", "city", "area", "countrysc", "long", "lat"}), new EntityPropertyMapper.Type("maltego.PhoneNumber", new String[]{"phonenumber.countrycode", "phonenumber.citycode", "phonenumber.areacode", "phonenumber.lastnumbers"}, new String[]{"countrycode", "citycode", "areacode", "lastnumbers"}), new EntityPropertyMapper.Type("maltego.affiliation.Spock", new String[]{"affiliation.network", "affiliation.uid", "affiliation.profile-url", "spock.websites"}, new String[]{"network", "uid", "profile_url", "spock_websites"}), new EntityPropertyMapper.Affiliation(new String[]{"affiliation.network", "affiliation.uid", "affiliation.profile-url"}, new String[]{"network", "uid", "profile_url"}), new EntityPropertyMapper.Type("maltego.Service", new String[]{"banner.text", "port.number"}, new String[]{"banner", "port"}), new EntityPropertyMapper.Type("maltego.Alias", new String[]{"alias"}, new String[]{"properties.alias"}), new EntityPropertyMapper.Type("maltego.Device", new String[]{"device"}, new String[]{"properties.device"}), new EntityPropertyMapper.Type("maltego.GPS", new String[]{"gps.coordinate"}, new String[]{"properties.gps"}), new EntityPropertyMapper.Type("maltego.CircularArea", new String[]{"radius"}, new String[]{"area"}), new EntityPropertyMapper.Type("maltego.Image", new String[]{"description", "url"}, new String[]{"properties.image", "fullImage"}), new EntityPropertyMapper.Type("maltego.BuiltWithTechnology", new String[]{"builtwith.technology"}, new String[]{"properties.builtwithtechnology"}), new EntityPropertyMapper.Type("maltego.FacebookObject", new String[]{"facebook.object"}, new String[]{"properties.facebookobject"})};

    private EntityTranslator() {
    }

    public static synchronized EntityTranslator instance() {
        if (_instance == null) {
            _instance = new EntityTranslator();
        }
        return _instance;
    }

    public Collection<MaltegoEntity> toEntities(Collection<EntityDescriptor> descriptors, EntityFactory factory, EntityRegistry registry) throws TypeInstantiationException {
        if (descriptors == null || descriptors.isEmpty()) {
            return new ArrayList<MaltegoEntity>(0);
        }
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(descriptors.size());
        for (EntityDescriptor desc : descriptors) {
            MaltegoEntity entity = this.translate(desc, factory, registry);
            if (InheritanceHelper.getValue((SpecRegistry)registry, (TypedPropertyBag)entity) == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    public Collection<EntityDescriptor> translate(Collection<MaltegoEntity> entities, EntityRegistry registry) {
        if (entities == null || entities.isEmpty()) {
            return new ArrayList<EntityDescriptor>(0);
        }
        ArrayList<EntityDescriptor> descriptors = new ArrayList<EntityDescriptor>(entities.size());
        for (MaltegoEntity entity : entities) {
            descriptors.add(this.translate(entity, registry));
        }
        return descriptors;
    }

    public MaltegoEntity translate(EntityDescriptor desc, EntityFactory factory, EntityRegistry registry) throws TypeInstantiationException {
        MaltegoEntity entity = (MaltegoEntity)factory.createInstance(EntitySpecTranslator.getV3TypeName(desc.getTypeName()), false, true);
        entity.setWeight(Integer.valueOf(desc.getWeight()));
        if (desc.getIconUrl() != null) {
            entity.addProperty(ICON_URL_PROPERTY);
            entity.setValue(ICON_URL_PROPERTY, (Object)desc.getIconUrl());
            entity.setImageExpression(ICON_URL_PROPERTY.getName());
        }
        this.copyDisplayInformation(entity.getOrCreateDisplayInformation(), desc.getDisplayInformation());
        String valueString = desc.getValue();
        String valuePropName = this.v3PropertyName(desc, "maltego.v2.value.property", null, registry);
        PropertyDescriptor valueProp = null;
        if (valuePropName != null) {
            valueProp = entity.getProperties().get(valuePropName);
        }
        if (valueProp == null) {
            valueProp = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entity, (boolean)false);
        }
        if (valueProp != null) {
            Object value = Converter.convertFrom((String)valueString, (Class)valueProp.getType());
            entity.setValue(valueProp, value);
        }
        this.copyProperties(entity, desc, registry);
        if (desc.getOverlays() != null) {
            desc.getOverlays().stream().map(o -> new OverlayDescriptor(o.propertyName, o.position, o.type)).forEach(overlay -> entity.addOverlay(overlay));
        }
        return entity;
    }

    private void copyDisplayInformation(DisplayInformationCollection dest, DisplayInfoCollection src) {
        for (DisplayInfo info : src) {
            dest.add(info.getName(), XMLEscapeUtils.unescape((String)info.getValue()));
        }
    }

    public EntityDescriptor translate(MaltegoEntity entity, EntityRegistry registry) {
        Object value;
        String s;
        EntityDescriptor desc = new EntityDescriptor();
        desc.setTypeName(EntitySpecTranslator.getV2TypeName(entity.getTypeName()));
        int bookmark = entity.getBookmark();
        if (bookmark >= 0) {
            desc.setBookmark(Integer.toString(bookmark));
        }
        this.copyProperties(desc, entity, registry);
        String valuePropName = this.v3PropertyName(desc, "maltego.v2.value.property", null, registry);
        PropertyDescriptor valueProp = null;
        if (valuePropName != null) {
            valueProp = entity.getProperties().get(valuePropName);
        }
        if (valueProp == null) {
            valueProp = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entity, (boolean)true);
        }
        if (valueProp != null && !StringUtilities.isNullOrEmpty((String)(s = Converter.convertTo((Object)(value = entity.getValue(valueProp)), (Class)valueProp.getType())))) {
            desc.setValue(s);
        }
        desc.setWeight(entity.getWeight());
        return desc;
    }

    private void copyProperties(MaltegoEntity to, EntityDescriptor from, EntityRegistry registry) {
        AdditionalFieldCollection fields = from.getFields();
        if (fields != null) {
            for (AdditionalField field : fields) {
                PropertyDescriptor dd = to.getProperties().get(this.v3PropertyName(from, field.getName(), field.getName(), registry));
                if (dd == null) {
                    dd = "maltego.automation.dob".equals(field.getName()) ? new PropertyDescriptor(DateTime.class, field.getName(), field.getDisplayName()) : new PropertyDescriptor(String.class, field.getName(), field.getDisplayName());
                    to.addProperty(dd);
                }
                to.setValue(dd, Converter.convertFrom((String)field.getValue(), (Class)dd.getType()));
            }
        }
    }

    public String v3PropertyName(EntityDescriptor from, String property, String defaultValue, EntityRegistry registry) {
        String type = EntitySpecTranslator.getV3TypeName(from.getTypeName());
        String result = null;
        List inheritedTypes = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
        for (EntityPropertyMapper mapper : this._mappings) {
            for (String inheritedType : inheritedTypes) {
                if (!mapper.matches(inheritedType)) continue;
                result = mapper.toNew(property);
                break;
            }
            if (result != null) break;
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String v2PropertyName(MaltegoEntity from, String property, String defaultValue, EntityRegistry registry) {
        String type = from.getTypeName();
        String result = null;
        List inheritedTypes = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
        for (EntityPropertyMapper mapper : this._mappings) {
            for (String inheritedType : inheritedTypes) {
                if (!mapper.matches(inheritedType)) continue;
                result = mapper.toOld(property);
                break;
            }
            if (result != null) break;
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private void copyProperties(EntityDescriptor to, MaltegoEntity from, EntityRegistry registry) {
        PropertyDescriptorCollection properties = from.getProperties();
        if (properties != null) {
            for (PropertyDescriptor p : properties) {
                String s;
                Object value = from.getValue(p);
                if (value == null || StringUtilities.isNullOrEmpty((String)(s = Converter.convertTo((Object)value, (Class)p.getType())))) continue;
                AdditionalField field = new AdditionalField();
                field.setName(this.v2PropertyName(from, p.getName(), p.getName(), registry));
                field.setDisplayName(p.getDisplayName());
                field.setValue(s);
                to.getFields().add(field);
            }
        }
    }
}

