/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.Level1EntityRegistry;
import com.paterva.maltego.entity.registry.Level2EntityRegistry;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EntitySpecTranslator {
    private static EntityRegistry _level1Registry;
    private static EntityRegistry _level2Registry;
    private static Map<String, String> _2to3;
    private static Map<String, String> _3to2;
    private static final String[] _mapping;

    public static String getV3TypeName(String v2TypeName) {
        if ("maltego.image".equals(v2TypeName)) {
            return "maltego.Image";
        }
        String v3 = EntitySpecTranslator.map2to3().get(v2TypeName);
        if (v3 == null) {
            v3 = v2TypeName;
        }
        return v3;
    }

    public static String getV2TypeName(String v3TypeName) {
        if ("maltego.Image".equals(v3TypeName)) {
            return "maltego.image";
        }
        String v2 = EntitySpecTranslator.map3to2().get(v3TypeName);
        if (v2 == null) {
            v2 = v3TypeName;
        }
        return v2;
    }

    public static Set<MaltegoEntitySpec> getEntities(TransformInfo info) {
        Set<MaltegoEntitySpec> entities = EntitySpecTranslator.level1Registry().getAll().stream().map(entity -> new MaltegoEntitySpec(entity)).collect(Collectors.toSet());
        MaltegoEntitySpec input = EntitySpecTranslator.getEntity(info.getInputEntityType());
        if (input != null) {
            entities.add(input);
        }
        for (String output : info.getOutputEntityTypes()) {
            MaltegoEntitySpec spec = EntitySpecTranslator.getEntity(output);
            if (spec == null) continue;
            entities.add(spec);
        }
        HashSet parents = new HashSet();
        for (MaltegoEntitySpec entity2 : entities) {
            parents.addAll(entity2.getBaseEntitySpecs());
        }
        for (String parent : parents) {
            MaltegoEntitySpec spec;
            if (parent == null || (spec = (MaltegoEntitySpec)EntitySpecTranslator.level2Registry().get(parent)) == null) continue;
            entities.add(spec);
        }
        return entities;
    }

    public static MaltegoEntitySpec getEntity(String type) {
        return (MaltegoEntitySpec)EntitySpecTranslator.level2Registry().get(EntitySpecTranslator.getV3TypeName(type));
    }

    private static synchronized Map<String, String> map2to3() {
        if (_2to3 == null) {
            _2to3 = new HashMap<String, String>();
            for (int i = 0; i < _mapping.length; i += 2) {
                _2to3.put(_mapping[i], _mapping[i + 1]);
            }
        }
        return _2to3;
    }

    private static synchronized Map<String, String> map3to2() {
        if (_3to2 == null) {
            _3to2 = new HashMap<String, String>();
            for (int i = 0; i < _mapping.length; i += 2) {
                _3to2.put(_mapping[i + 1], _mapping[i]);
            }
        }
        return _3to2;
    }

    private static synchronized EntityRegistry level1Registry() {
        if (_level1Registry == null) {
            _level1Registry = new Level1EntityRegistry();
        }
        return _level1Registry;
    }

    private static synchronized EntityRegistry level2Registry() {
        if (_level2Registry == null) {
            _level2Registry = new Level2EntityRegistry();
        }
        return _level2Registry;
    }

    static {
        _mapping = new String[]{"ASNumber", "maltego.AS", "AffiliationBebo", "maltego.affiliation.Bebo", "AffiliationFacebook", "maltego.affiliation.Facebook", "AffiliationFlickr", "maltego.affiliation.Flickr", "AffiliationLinkedin", "maltego.affiliation.LinkedIn", "AffiliationMySpace", "maltego.affiliation.Myspace", "AffiliationOrkut", "maltego.affiliation.Orkut", "AffiliationSpock", "maltego.affiliation.Spock", "AffiliationTwitter", "maltego.affiliation.Twitter", "IPAddress", "maltego.IPv4Address", "NSrecord", "maltego.NSRecord", "MXrecord", "maltego.MXRecord", "Document", "maltego.Document", "EmailAddress", "maltego.EmailAddress", "Person", "maltego.Person", "PhoneNumber", "maltego.PhoneNumber", "Phrase", "maltego.Phrase", "Twit", "maltego.Twit", "DNSName", "maltego.DNSName", "Domain", "maltego.Domain", "Location", "maltego.Location", "Netblock", "maltego.Netblock", "URL", "maltego.URL", "Website", "maltego.Website", "Webtitle", "maltego.WebTitle", "Webdir", "maltego.WebDir", "Vuln", "maltego.Vulnerability", "Service", "maltego.Service", "Port", "maltego.Port", "Banner", "maltego.Banner", "Alias", "maltego.Alias", "Device", "maltego.Device", "GPS", "maltego.GPS", "CircularArea", "maltego.CircularArea", "Image", "maltego.Image", "BuiltWith.Technology", "maltego.BuiltWithTechnology", "facebook.Object", "maltego.FacebookObject"};
    }
}

