/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressStringDivisionSeries;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressSection;
import java.util.Iterator;

public class MACAddressSegment
extends AddressDivision
implements AddressSegment,
Iterable<MACAddressSegment> {
    public static final MACAddressSegment ALL_RANGE_SEGMENT = new MACAddressSegment(0, 255);
    public static final MACAddressSegment FF_SEGMENT = MACAddress.getAddressCreator().createSegment(255);
    public static final MACAddressSegment FE_SEGMENT = MACAddress.getAddressCreator().createSegment(254);
    public static final MACAddressSegment ZERO_SEGMENT = MACAddress.getAddressCreator().createSegment(0);
    private static final long serialVersionUID = 3L;
    public static final int MAX_CHARS = 2;
    private final int value;
    private final int upperValue;

    public MACAddressSegment(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException();
        }
        this.value = this.upperValue = value;
    }

    public MACAddressSegment(int lower, int upper) {
        if (lower > upper) {
            int tmp = lower;
            lower = upper;
            upper = tmp;
        }
        if (lower < 0 || upper < 0 || upper > 255) {
            throw new IllegalArgumentException();
        }
        this.value = lower;
        this.upperValue = upper;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        return new byte[]{(byte)(low ? this.getLowerSegmentValue() : this.getUpperSegmentValue())};
    }

    protected MACAddressSegment toPrefixedSegment(Integer segmentPrefixLength) {
        return MACAddressSegment.toPrefixedSegment(this, segmentPrefixLength, MACAddressSegment.getSegmentCreator());
    }

    protected MACAddressSegment setPrefixedSegment(Integer oldPrefixLength, Integer segmentPrefixLength) {
        return MACAddressSegment.setPrefixedSegment(this, oldPrefixLength, segmentPrefixLength, MACAddressSegment.getSegmentCreator());
    }

    private static AddressNetwork.AddressSegmentCreator<MACAddressSegment> getSegmentCreator() {
        return MACAddress.network().getAddressCreator();
    }

    @Override
    public int getValueCount() {
        return this.upperValue - this.value + 1;
    }

    @Override
    public long getDivisionValueCount() {
        return this.getValueCount();
    }

    @Override
    public int getBitCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public long getMaxValue() {
        return 255L;
    }

    @Override
    public long getLowerValue() {
        return this.getLowerSegmentValue();
    }

    @Override
    public long getUpperValue() {
        return this.getUpperSegmentValue();
    }

    @Override
    public int getLowerSegmentValue() {
        return this.value;
    }

    @Override
    public int getUpperSegmentValue() {
        return this.upperValue;
    }

    private MACAddressSegment getLowestOrHighest(boolean lowest) {
        if (!this.isMultiple()) {
            return this;
        }
        return MACAddressSegment.getSegmentCreator().createSegment(lowest ? this.getLowerSegmentValue() : this.getUpperSegmentValue());
    }

    @Override
    public MACAddressSegment getLower() {
        return this.getLowestOrHighest(true);
    }

    @Override
    public MACAddressSegment getUpper() {
        return this.getLowestOrHighest(false);
    }

    @Override
    public MACAddressSegment reverseBits(boolean perByte) {
        return this.reverseBits();
    }

    public MACAddressSegment reverseBits() {
        if (this.isMultiple()) {
            if (MACAddressSegment.isReversibleRange(this)) {
                return this;
            }
            throw new AddressTypeException(this, "ipaddress.error.reverseRange");
        }
        int oldValue = this.value;
        int newValue = MACAddressSegment.reverseBits((byte)oldValue);
        if (oldValue == newValue) {
            return this;
        }
        AddressNetwork.AddressSegmentCreator<MACAddressSegment> creator = MACAddressSegment.getSegmentCreator();
        return creator.createSegment(newValue);
    }

    @Override
    public MACAddressSegment reverseBytes() {
        return this;
    }

    @Override
    public boolean isBoundedBy(int value) {
        return this.getUpperSegmentValue() < value;
    }

    @Override
    protected boolean isSameValues(AddressDivision other) {
        if (other instanceof MACAddressSegment) {
            return this.isSameValues((MACAddressSegment)other);
        }
        return false;
    }

    protected boolean isSameValues(MACAddressSegment otherSegment) {
        return this.value == otherSegment.value && this.upperValue == otherSegment.upperValue;
    }

    public int hashCode() {
        return MACAddressSegment.hash(this.value, this.upperValue, this.getBitCount());
    }

    static int hash(int lower, int upper, int bitCount) {
        return lower | upper << bitCount;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MACAddressSegment && this.isSameValues((MACAddressSegment)other);
    }

    public boolean contains(MACAddressSegment other) {
        return other.value >= this.value && other.upperValue <= this.upperValue;
    }

    @Override
    public boolean isFullRange() {
        return this.getLowerSegmentValue() == 0 && this.getUpperSegmentValue() == this.getMaxSegmentValue();
    }

    @Override
    public int getDefaultTextualRadix() {
        return 16;
    }

    @Override
    public int getMaxDigitCount() {
        return 2;
    }

    @Override
    public boolean matches(int value) {
        return super.matches(value);
    }

    @Override
    public boolean matchesWithMask(int value, int mask) {
        return super.matchesWithMask(value, mask);
    }

    void setString(CharSequence addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int originalLowerValue) {
        if (this.cachedString == null && isStandardString && (long)originalLowerValue == this.getLowerValue()) {
            this.cachedString = addressStr.subSequence(lowerStringStartIndex, lowerStringEndIndex).toString();
        }
    }

    void setString(CharSequence addressStr, boolean isStandardRangeString, int lowerStringStartIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedString == null) {
            if (this.isFullRange()) {
                this.cachedString = MACAddress.SEGMENT_WILDCARD_STR;
            } else if (isStandardRangeString && (long)rangeLower == this.getLowerValue() && (long)rangeUpper == this.getUpperValue()) {
                this.cachedString = addressStr.subSequence(lowerStringStartIndex, upperStringEndIndex).toString();
            }
        }
    }

    public Iterable<MACAddressSegment> getIterable() {
        return this;
    }

    @Override
    public Iterator<MACAddressSegment> iterator() {
        return MACAddressSegment.iterator(this, MACAddressSegment.getSegmentCreator(), true);
    }

    @Override
    public int getMaxSegmentValue() {
        return 255;
    }

    @Override
    public boolean contains(AddressSegment other) {
        return other instanceof MACAddressSegment && other.getLowerSegmentValue() >= this.value && other.getUpperSegmentValue() <= this.upperValue;
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        return this.toNormalizedString(with0xPrefix ? MACAddressSection.MACStringCache.hexPrefixedParams : MACAddressSection.MACStringCache.hexParams);
    }

    @Override
    public String toNormalizedString() {
        return this.toNormalizedString(MACAddressSection.MACStringCache.canonicalParams);
    }

    public String toNormalizedString(AddressDivisionGrouping.StringOptions options) {
        AddressDivisionGrouping.AddressStringParams<AddressStringDivisionSeries> params = MACAddressSection.toParams(options);
        StringBuilder builder = new StringBuilder(params.getDivisionStringLength(this));
        return params.appendDivision(builder, this).toString();
    }
}

