/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.format.AddressBitsDivision;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressStringDivisionSeries;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSegment;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntFunction;

public class MACAddressSection
extends AddressDivisionGrouping
implements AddressSection,
Iterable<MACAddressSection> {
    private static final long serialVersionUID = 3L;
    private static MACAddressNetwork.MACAddressCreator[][] creators = new MACAddressNetwork.MACAddressCreator[9][2];
    private transient MACStringCache stringCache;
    private transient AddressDivisionGrouping.SectionCache<MACAddressSection> sectionCache;
    public final int startIndex;
    public final boolean extended;

    public MACAddressSection(MACAddressSegment segment) {
        super(new MACAddressSegment[]{segment});
        this.startIndex = 0;
        this.extended = false;
    }

    public MACAddressSection(MACAddressSegment segment, int startIndex, boolean extended) {
        this(false, new MACAddressSegment[]{segment}, startIndex, extended);
    }

    public MACAddressSection(MACAddressSegment[] segments) {
        this(segments, 0, segments.length > 6);
    }

    public MACAddressSection(MACAddressSegment[] segments, int startIndex, boolean extended) {
        this(true, segments, startIndex, extended);
    }

    public MACAddressSection(MACAddressSegment[] segments, Integer prefixLength) {
        this(segments, 0, segments.length > 6, prefixLength);
    }

    public MACAddressSection(MACAddressSegment[] segments, int startIndex, boolean extended, Integer prefixLength) {
        this(false, (MACAddressSegment[])MACAddressSection.toPrefixedSegments((Integer)prefixLength, (AddressSegment[])segments, (int)8, MACAddressSection.getSegmentCreator(), (T seg, U prefLength) -> seg.toPrefixedSegment((Integer)prefLength), (boolean)true), startIndex, extended);
    }

    MACAddressSection(boolean cloneSegments, MACAddressSegment[] segments, int startIndex, boolean extended) {
        super(cloneSegments ? (AddressDivision[])segments.clone() : segments);
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (startIndex + segments.length > (extended ? 8 : 6)) {
            throw new IllegalArgumentException(String.valueOf(MACAddress.getMessage("ipaddress.error.exceeds.size")) + ' ' + segments.length);
        }
        this.startIndex = startIndex;
        this.extended = extended;
    }

    MACAddressSection(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int startIndex, boolean extended, Integer prefixLength) {
        super((AddressDivision[])AddressDivisionGrouping.toSegments((Address.SegmentValueProvider)lowerValueProvider, (Address.SegmentValueProvider)upperValueProvider, (int)(extended ? 8 : 6), (int)1, (int)8, (int)255, MACAddressSection.getSegmentCreator(), (Integer)prefixLength));
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.startIndex = startIndex;
        this.extended = extended;
    }

    MACAddressSection(byte[] bytes, int startIndex, boolean extended, Integer prefixLength, boolean cloneBytes) {
        super((AddressDivision[])AddressDivisionGrouping.toSegments((byte[])bytes, (int)bytes.length, (int)1, (int)8, (int)255, MACAddressSection.getSegmentCreator(), (Integer)prefixLength));
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (startIndex + bytes.length > (extended ? 8 : 6)) {
            throw new IllegalArgumentException(String.valueOf(MACAddress.getMessage("ipaddress.error.exceeds.size")) + ' ' + bytes.length);
        }
        this.startIndex = startIndex;
        this.extended = extended;
        this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
    }

    public MACAddressSection(byte[] bytes, int startIndex, boolean extended, Integer prefixLength) {
        this(bytes, startIndex, extended, prefixLength, true);
    }

    public MACAddressSection(byte[] bytes, int startIndex, boolean extended) {
        this(bytes, startIndex, extended, null, true);
    }

    public MACAddressSection(byte[] bytes, Integer prefixLength) {
        this(bytes, 0, bytes.length > 6, null, true);
    }

    public MACAddressSection(byte[] bytes) {
        this(bytes, null);
    }

    public MACAddressSection(long value, int startIndex, boolean extended, Integer prefixLength) {
        super(MACAddressSection.toPrefixedSegments(value, extended ? 8 : 6, 1, 8, 255, MACAddressSection.getSegmentCreator(), prefixLength));
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (!(extended || value <= 0xFFFFFFFFFFFFL && value >= 0L)) {
            throw new IllegalArgumentException(String.valueOf(MACAddress.getMessage("ipaddress.error.exceeds.size")) + ' ' + value);
        }
        this.startIndex = startIndex;
        this.extended = extended;
    }

    public MACAddressSection(long value, int startIndex, boolean extended) {
        this(value, startIndex, extended, null);
    }

    public MACAddressSection(long value, Integer prefixLength) {
        this(value, 0, false, prefixLength);
    }

    public MACAddressSection(long value) {
        this(value, 0, false, null);
    }

    protected static MACAddressSegment[] toPrefixedSegments(long value, int segmentCount, int bytesPerSegment, int bitsPerSegment, int maxValuePerSegment, AddressNetwork.AddressSegmentCreator<MACAddressSegment> creator, Integer prefixLength) {
        return (MACAddressSegment[])AddressDivisionGrouping.toSegments((long)value, (int)segmentCount, (int)segmentCount, (int)bytesPerSegment, (int)bitsPerSegment, (int)maxValuePerSegment, creator, (Integer)prefixLength);
    }

    private static MACAddressNetwork.MACAddressCreator getAddressCreator(final int startIndex, final boolean extended) {
        int extendedIndex = extended ? 1 : 0;
        MACAddressNetwork.MACAddressCreator result = creators[startIndex][extendedIndex];
        if (result == null) {
            MACAddressSection.creators[startIndex][extendedIndex] = result = new MACAddressNetwork.MACAddressCreator(){

                @Override
                protected MACAddressSection createSectionInternal(MACAddressSegment[] segments) {
                    return MACAddress.network().getAddressCreator().createSectionInternal(segments, startIndex, extended);
                }
            };
        }
        return result;
    }

    MACAddressNetwork.MACAddressCreator getAddressCreator() {
        return MACAddressSection.getAddressCreator(this.startIndex, this.extended);
    }

    private static AddressNetwork.AddressSegmentCreator<MACAddressSegment> getSegmentCreator() {
        return MACAddressSection.getAddressCreator(0, false);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MACAddressSection) {
            MACAddressSection other = (MACAddressSection)o;
            return this.startIndex == other.startIndex && this.isExtended() == other.isExtended() && other.isSameGrouping(this);
        }
        return false;
    }

    protected MACStringCache getStringCache() {
        return this.stringCache;
    }

    @Override
    protected boolean isSameGrouping(AddressDivisionGrouping other) {
        return other instanceof MACAddressSection && super.isSameGrouping(other);
    }

    public MACAddressSegment[] getSegments() {
        return (MACAddressSegment[])this.divisions.clone();
    }

    @Override
    public void getSegments(AddressSegment[] segs) {
        this.getSegments(0, this.getDivisionCount(), segs, 0);
    }

    @Override
    public void getSegments(int start, int end, AddressSegment[] segs, int destIndex) {
        System.arraycopy(this.divisions, start, segs, destIndex, end - start);
    }

    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public int getSegmentCount() {
        return this.getDivisionCount();
    }

    public boolean isEntireAddress(boolean extended) {
        return this.getSegmentCount() == (extended ? 8 : 6);
    }

    @Override
    public MACAddressSegment getSegment(int index) {
        return (MACAddressSegment)super.getDivision(index);
    }

    public void getSegments(Collection<? super MACAddressSegment> segs) {
        this.getSegments(0, this.getSegmentCount(), segs);
    }

    public void getSegments(int start, int end, Collection<? super MACAddressSegment> segs) {
        int i = start;
        while (i < end) {
            segs.add(this.getSegment(i));
            ++i;
        }
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount();
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() << 3;
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        byte[] bytes = new byte[this.getByteCount()];
        int segmentCount = this.getSegmentCount();
        int i = 0;
        while (i < segmentCount) {
            MACAddressSegment seg = this.getSegment(i);
            int val = low ? seg.getLowerSegmentValue() : seg.getUpperSegmentValue();
            bytes[i] = (byte)val;
            ++i;
        }
        return bytes;
    }

    @Override
    protected BigInteger getCountImpl() {
        long lastValue;
        int segCount = this.getSegmentCount();
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        long result = this.getSegment(0).getValueCount();
        int limit = Math.min(segCount, 7);
        int i = 1;
        while (i < limit) {
            result *= (long)this.getSegment(i).getValueCount();
            ++i;
        }
        if (segCount == 8 && (lastValue = (long)this.getSegment(7).getValueCount()) != 1L) {
            if (result <= 0x7FFFFFFFFFFFFFL) {
                result *= lastValue;
            } else {
                return BigInteger.valueOf(result).multiply(BigInteger.valueOf(lastValue));
            }
        }
        return BigInteger.valueOf(result);
    }

    @Override
    public boolean isPrefixed() {
        return this.getPrefixLength() != null;
    }

    public int getOUISegmentCount() {
        return Math.max(0, 3 - this.startIndex);
    }

    public int getODISegmentCount() {
        return this.getSegmentCount() - Math.max(0, 3 - this.startIndex);
    }

    @Override
    public Integer getPrefixLength() {
        Integer ret = this.cachedPrefix;
        if (ret == null) {
            int prefix = this.getMinPrefix();
            if (prefix == this.getBitCount()) {
                this.cachedPrefix = -1;
                return null;
            }
            this.cachedPrefix = prefix;
            return this.cachedPrefix;
        }
        if (this.cachedPrefix < 0) {
            return null;
        }
        return ret;
    }

    @Override
    public boolean isMultipleByPrefix() {
        return this.isPrefixed();
    }

    @Override
    public MACAddressSection getSection(int index) {
        return this.getSection(index, this.getSegmentCount());
    }

    @Override
    public MACAddressSection getSection(int index, int endIndex) {
        return MACAddressSection.getSection(index, endIndex, this, MACAddressSection.getAddressCreator(this.startIndex + index, this.extended));
    }

    public MACAddressSection getOUISection() {
        int segmentCount = this.getOUISegmentCount();
        return MACAddressSection.getSection(0, segmentCount, this, this.getAddressCreator());
    }

    public MACAddressSection getODISection() {
        int segmentCount = this.getOUISegmentCount();
        return MACAddressSection.getSection(segmentCount, this.getSegmentCount(), this, MACAddressSection.getAddressCreator(this.startIndex + segmentCount, this.extended));
    }

    public MACAddressSection toOUIPrefixed() {
        int ouiSegmentCount = this.getOUISegmentCount();
        int segmentCount = this.getSegmentCount();
        int i = ouiSegmentCount;
        while (i < segmentCount) {
            MACAddressSegment segment = this.getSegment(i);
            if (!segment.isFullRange()) {
                MACAddressNetwork.MACAddressCreator creator = this.getAddressCreator();
                MACAddressSegment[] newSegments = (MACAddressSegment[])MACAddressSection.toPrefixedSegments((Integer)(ouiSegmentCount * 8), (AddressSegment[])this.getSegments(), (int)8, (AddressNetwork.AddressSegmentCreator)creator, (T seg, U prefixLength) -> prefixLength == 0 ? MACAddressSegment.ALL_RANGE_SEGMENT : seg, (boolean)false);
                return creator.createSectionInternal(newSegments);
            }
            ++i;
        }
        return this;
    }

    public IPv6AddressSection toEUI64IPv6() {
        return IPv6Address.network().getAddressCreator().createSection(this);
    }

    public boolean isEUI64(boolean asMAC) {
        return this.isEUI64(asMAC, false);
    }

    public boolean isEUI64(boolean asMAC, boolean partial) {
        if (this.isExtended()) {
            int segmentCount = this.getSegmentCount();
            int endIndex = this.startIndex + segmentCount;
            if (this.startIndex <= 3) {
                if (endIndex > 4) {
                    int index3 = 3 - this.startIndex;
                    MACAddressSegment seg3 = this.getSegment(index3);
                    MACAddressSegment seg4 = this.getSegment(index3 + 1);
                    return seg4.matches(asMAC ? 255 : 254) && seg3.matches(255);
                }
                if (partial && endIndex == 4) {
                    MACAddressSegment seg3 = this.getSegment(3 - this.startIndex);
                    return seg3.matches(255);
                }
            } else if (partial && this.startIndex == 4 && endIndex > 4) {
                MACAddressSegment seg4 = this.getSegment(4 - this.startIndex);
                return seg4.matches(asMAC ? 255 : 254);
            }
            return partial;
        }
        return false;
    }

    public MACAddressSection toEUI64(boolean asMAC) {
        MACAddressSegment seg4;
        int originalSegmentCount = this.getSegmentCount();
        if (!this.isExtended()) {
            int frontCount;
            MACAddressNetwork.MACAddressCreator creator = MACAddressSection.getAddressCreator(this.startIndex, true);
            if (this.startIndex + originalSegmentCount < 3 || this.startIndex > 3) {
                return this;
            }
            AddressSegment[] segs = creator.createSegmentArray(originalSegmentCount + 2);
            if (this.startIndex < 3) {
                frontCount = 3 - this.startIndex;
                this.getSegments(0, frontCount, segs, 0);
            } else {
                frontCount = 0;
            }
            segs[frontCount] = MACAddressSegment.FF_SEGMENT;
            AddressSegment addressSegment = segs[frontCount + 1] = asMAC ? MACAddressSegment.FF_SEGMENT : MACAddressSegment.FE_SEGMENT;
            if (originalSegmentCount > frontCount) {
                this.getSegments(frontCount, originalSegmentCount, segs, frontCount + 2);
            }
            return creator.createSectionInternal((MACAddressSegment[])segs, this.startIndex, true);
        }
        int endIndex = this.startIndex + originalSegmentCount;
        if (this.startIndex <= 3) {
            MACAddressSegment seg3;
            if (endIndex > 4) {
                int index3 = 3 - this.startIndex;
                MACAddressSegment seg32 = this.getSegment(index3);
                MACAddressSegment seg42 = this.getSegment(index3 + 1);
                if (!seg42.matches(asMAC ? 255 : 254) || !seg32.matches(255)) {
                    throw new AddressTypeException(this, "ipaddress.mac.error.not.eui.convertible");
                }
            } else if (endIndex == 4 && !(seg3 = this.getSegment(3 - this.startIndex)).matches(255)) {
                throw new AddressTypeException(this, "ipaddress.mac.error.not.eui.convertible");
            }
        } else if (this.startIndex == 4 && endIndex > 4 && !(seg4 = this.getSegment(4 - this.startIndex)).matches(asMAC ? 255 : 254)) {
            throw new AddressTypeException(this, "ipaddress.mac.error.not.eui.convertible");
        }
        return this;
    }

    public MACAddressSection replace(MACAddressSection other, int index) {
        return MACAddressSection.replace(this, other, this.getAddressCreator(), index, false);
    }

    public MACAddressSection prepend(MACAddressSection other) {
        int otherSegmentCount = other.getSegmentCount();
        int newStartIndex = this.startIndex - otherSegmentCount;
        if (newStartIndex < 0) {
            throw new AddressTypeException(this, other, "ipaddress.error.exceeds.size");
        }
        if (otherSegmentCount == 0) {
            return this;
        }
        int segmentCount = this.getSegmentCount();
        if (this.startIndex == other.startIndex + otherSegmentCount && this.extended == other.extended && segmentCount == 0) {
            return other;
        }
        return MACAddressSection.append(other, this, MACAddressSection.getAddressCreator(newStartIndex, this.extended), false);
    }

    public MACAddressSection append(MACAddressSection other) {
        int otherSegmentCount = other.getSegmentCount();
        int segmentCount = this.getSegmentCount();
        int totalSegmentCount = segmentCount + otherSegmentCount;
        if (this.startIndex + totalSegmentCount > 8) {
            throw new AddressTypeException(this, other, "ipaddress.error.exceeds.size");
        }
        if (otherSegmentCount == 0) {
            return this;
        }
        if (this.startIndex == other.startIndex && this.extended == other.extended && segmentCount == 0) {
            return other;
        }
        return MACAddressSection.append(this, other, this.getAddressCreator(), false);
    }

    public boolean contains(MACAddressSection other) {
        if (this.startIndex != other.startIndex || this.isExtended() != other.isExtended() || this.getSegmentCount() != other.getSegmentCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getSegmentCount()) {
            if (!this.getSegment(i).contains(other.getSegment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private MACAddressSection getLowestOrHighestSection(boolean lowest) {
        return MACAddressSection.getLowestOrHighestSection(this, this.getAddressCreator(), lowest, i -> lowest ? this.getSegment(i).getLower() : this.getSegment(i).getUpper(), () -> MACAddressSection.getSectionCache(this, () -> this.sectionCache, () -> {
            this.sectionCache = new AddressDivisionGrouping.SectionCache();
            return this.sectionCache;
        }));
    }

    MACAddress getLowestOrHighest(MACAddress addr, boolean lowest) {
        return MACAddressSection.getLowestOrHighestAddress(addr, this.getAddressCreator(), lowest, () -> this.getLowestOrHighestSection(lowest), () -> MACAddressSection.getSectionCache(addr, () -> mACAddress.sectionCache, () -> {
            mACAddress.sectionCache = new AddressCache();
            return mACAddress.sectionCache;
        }));
    }

    @Override
    public MACAddressSection getLower() {
        return this.getLowestOrHighestSection(true);
    }

    @Override
    public MACAddressSection getUpper() {
        return this.getLowestOrHighestSection(false);
    }

    @Override
    public MACAddressSection reverseBits(boolean perByte) {
        return MACAddressSection.reverseBits(perByte, this, this.getAddressCreator(), i -> this.getSegment(i).reverseBits(perByte), false);
    }

    @Override
    public MACAddressSection reverseBytes() {
        return this.reverseSegments();
    }

    @Override
    public MACAddressSection reverseBytesPerSegment() {
        return this;
    }

    @Override
    public MACAddressSection reverseSegments() {
        if (this.getSegmentCount() <= 1) {
            return this;
        }
        return MACAddressSection.reverseSegments(this, this.getAddressCreator(), this::getSegment, false);
    }

    @Override
    public MACAddressSection removePrefixLength() {
        AddressSegment[] oldSegs = (MACAddressSegment[])this.divisions;
        MACAddressSegment[] newSegs = (MACAddressSegment[])MACAddressSection.removePrefix((AddressSection)this, (AddressSegment[])oldSegs, (int)8, (T seg, U oldPrefLength, V newPrefLength) -> seg.setPrefixedSegment((Integer)oldPrefLength, (Integer)newPrefLength));
        if (newSegs == oldSegs) {
            return this;
        }
        return this.getAddressCreator().createSectionInternal(newSegs, this.startIndex, this.extended);
    }

    @Override
    public MACAddressSection adjustPrefixBySegment(boolean nextSegment) {
        Integer existing = this.getPrefixLength();
        if (existing == null && nextSegment) {
            return this;
        }
        int prefix = this.getAdjustedPrefix(nextSegment, this.getBitsPerSegment(), true);
        return this.setPrefixLength(prefix);
    }

    @Override
    public MACAddressSection adjustPrefixLength(int adjustment) {
        if (adjustment == 0) {
            return this;
        }
        int prefix = this.getAdjustedPrefix(adjustment, true, true);
        return this.setPrefixLength(prefix);
    }

    @Override
    public MACAddressSection applyPrefixLength(int prefixLength) {
        return this.setPrefixLength(prefixLength, true);
    }

    @Override
    public MACAddressSection setPrefixLength(int networkPrefixLength) {
        return this.setPrefixLength(networkPrefixLength, false);
    }

    private MACAddressSection setPrefixLength(int prefixLength, boolean noShrink) {
        AddressSegment[] oldSegs = (MACAddressSegment[])this.divisions;
        MACAddressNetwork.MACAddressCreator creator = this.getAddressCreator();
        MACAddressSegment[] newSegs = (MACAddressSegment[])MACAddressSection.setPrefixed((AddressSection)this, (int)prefixLength, (AddressSegment[])oldSegs, (int)8, (boolean)noShrink, (AddressNetwork.AddressSegmentCreator)creator, (T seg, U prefLength) -> seg.toPrefixedSegment((Integer)prefLength), (T seg, U oldPrefLength, V newPrefLength) -> seg.setPrefixedSegment((Integer)oldPrefLength, (Integer)newPrefLength));
        if (newSegs == oldSegs) {
            return this;
        }
        return creator.createSectionInternal(newSegs, this.startIndex, this.extended);
    }

    public Iterable<MACAddressSection> getIterable() {
        return this;
    }

    @Override
    public Iterator<MACAddressSection> iterator() {
        boolean useOriginal = !this.isMultiple();
        return MACAddressSection.iterator(useOriginal, this, this.getAddressCreator(), useOriginal ? null : this.segmentsIterator());
    }

    public Iterator<MACAddressSegment[]> segmentsIterator() {
        return super.iterator(MACAddressSection.getSegmentCreator(), () -> this.getLower().getSegments(), index -> this.getSegment(index).iterator());
    }

    protected Iterator<MACAddress> iterator(MACAddress original) {
        MACAddressNetwork.MACAddressCreator creator = this.getAddressCreator();
        boolean useOriginal = !this.isMultiple();
        return MACAddressSection.iterator(original, creator, useOriginal, useOriginal ? null : this.iterator(creator, () -> (MACAddressSegment[])this.getLower().divisions, index -> this.getSegment(index).iterator()));
    }

    protected static <R extends MACAddressSection, S extends MACAddressSegment> S[] createSingle(R original, AddressNetwork.AddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer) {
        return (MACAddressSegment[])AddressDivisionGrouping.createSingle(original, segmentCreator, segProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            MACAddressSection mACAddressSection = this;
            synchronized (mACAddressSection) {
                block5: {
                    if (this.stringCache != null) break block5;
                    this.stringCache = new MACStringCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0xPrefix ? this.stringCache.hexStringPrefixed : this.stringCache.hexString) == null) {
            result = this.toHexString(with0xPrefix, null);
            if (with0xPrefix) {
                this.stringCache.hexStringPrefixed = result;
            } else {
                this.stringCache.hexString = result;
            }
        }
        return result;
    }

    protected String toHexString(boolean with0xPrefix, CharSequence zone) {
        if (this.isDualString()) {
            return MACAddressSection.toNormalizedStringRange(AddressDivisionGrouping.AddressStringParams.toParams(with0xPrefix ? MACStringCache.hexPrefixedParams : MACStringCache.hexParams), this.getLower(), this.getUpper(), null);
        }
        return this.toNormalizedString(with0xPrefix ? MACStringCache.hexPrefixedParams : MACStringCache.hexParams);
    }

    public String toNormalizedString(AddressDivisionGrouping.StringOptions stringOptions) {
        return MACAddressSection.toNormalizedString(stringOptions, this);
    }

    public static String toNormalizedString(AddressDivisionGrouping.StringOptions opts, AddressDivisionGrouping section) {
        return MACAddressSection.toParams(opts).toString(section);
    }

    @Override
    public String toNormalizedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().normalizedString) == null) {
            this.getStringCache().normalizedString = result = this.toNormalizedString(MACStringCache.normalizedParams);
        }
        return result;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().canonicalString) == null) {
            this.getStringCache().canonicalString = result = this.toNormalizedString(MACStringCache.canonicalParams);
        }
        return result;
    }

    @Override
    public String toCompressedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().compressedString) == null) {
            this.getStringCache().compressedString = result = this.toNormalizedString(MACStringCache.compressedParams);
        }
        return result;
    }

    public String toDottedString() {
        String result = null;
        if (this.hasNoStringCache() || (result = this.getStringCache().dottedString) == null) {
            AddressDivisionGrouping dottedGrouping = this.getDottedGrouping();
            this.getStringCache().dottedString = result = MACAddressSection.toNormalizedString(MACStringCache.dottedParams, dottedGrouping);
        }
        return result;
    }

    public String toSpaceDelimitedString() {
        String result = null;
        if (this.hasNoStringCache() || (result = this.getStringCache().spaceDelimitedString) == null) {
            this.getStringCache().spaceDelimitedString = result = this.toNormalizedString(MACStringCache.spaceDelimitedParams);
        }
        return result;
    }

    public String toDashedString() {
        return this.toCanonicalString();
    }

    public String toColonDelimitedString() {
        return this.toNormalizedString();
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }

    public AddressDivisionGrouping getDottedGrouping() {
        AddressDivisionGrouping dottedGrouping;
        int newSegIndex;
        int segIndex;
        AddressDivision[] newSegs;
        int start = this.startIndex;
        int segmentCount = this.getSegmentCount();
        int newSegmentBitCount = 16;
        if ((start & 1) == 0) {
            int newSegmentCount = segmentCount + 1 >>> 1;
            newSegs = new AddressDivision[newSegmentCount];
            segIndex = 0;
            newSegIndex = 0;
        } else {
            int newSegmentCount = (segmentCount >>> 1) + 1;
            newSegs = new AddressDivision[newSegmentCount];
            MACAddressSegment segment = this.getSegment(0);
            newSegs[0] = new AddressBitsDivision(segment.getLowerSegmentValue(), segment.getUpperSegmentValue(), newSegmentBitCount, 16);
            segIndex = 1;
            newSegIndex = 1;
        }
        while (segIndex + 1 < segmentCount) {
            MACAddressSegment segment1 = this.getSegment(segIndex++);
            MACAddressSegment segment2 = this.getSegment(segIndex++);
            if (segment1.isMultiple() && !segment2.isFullRange()) {
                throw new AddressTypeException(segment1, segIndex - 2, segment2, segIndex - 1, "ipaddress.error.invalid.joined.ranges");
            }
            AddressBitsDivision newSeg = new AddressBitsDivision(segment1.getLowerSegmentValue() << 8 | segment2.getLowerSegmentValue(), segment1.getUpperSegmentValue() << 8 | segment2.getUpperSegmentValue(), newSegmentBitCount, 16);
            newSegs[newSegIndex++] = newSeg;
        }
        if (segIndex < segmentCount) {
            MACAddressSegment segment = this.getSegment(segIndex);
            newSegs[newSegIndex] = new AddressBitsDivision(segment.getLowerSegmentValue() << 8, segment.getUpperSegmentValue() << 8, newSegmentBitCount, 16);
        }
        if (this.cachedPrefix == null) {
            dottedGrouping = new AddressDivisionGrouping(newSegs);
        } else {
            Integer prefLength = this.getPrefixLength();
            dottedGrouping = new AddressDivisionGrouping(newSegs, prefLength){
                {
                    this.cachedPrefix = n;
                }
            };
        }
        return dottedGrouping;
    }

    static String toNormalizedString(IPAddressSection.IPStringOptions opts, AddressStringDivisionSeries section) {
        return MACAddressSection.toParams(opts).toString(section);
    }

    @Override
    public boolean contains(AddressSection other) {
        return other instanceof MACAddressSection && this.contains((MACAddressSection)other);
    }

    protected static AddressDivisionGrouping.AddressStringParams<AddressStringDivisionSeries> toParams(AddressDivisionGrouping.StringOptions opts) {
        return AddressDivisionGrouping.AddressStringParams.toParams(opts);
    }

    static class AddressCache
    extends AddressDivisionGrouping.SectionCache<MACAddress> {
        AddressCache() {
        }
    }

    protected static class MACStringCache
    extends AddressDivisionGrouping.StringCache {
        public static final AddressDivisionGrouping.StringOptions hexParams = new MACStringOptions.Builder().setSeparator(null).setExpandedSegments(true).setRadix(16).toParams();
        public static final AddressDivisionGrouping.StringOptions hexPrefixedParams = new MACStringOptions.Builder().setSeparator(null).setExpandedSegments(true).setRadix(16).setAddressLabel("0x").toParams();
        public static final AddressDivisionGrouping.StringOptions canonicalParams;
        public static final AddressDivisionGrouping.StringOptions compressedParams;
        public static final AddressDivisionGrouping.StringOptions normalizedParams;
        public static final AddressDivisionGrouping.StringOptions dottedParams;
        public static final AddressDivisionGrouping.StringOptions spaceDelimitedParams;
        public String compressedString;
        public String normalizedString;
        public String dottedString;
        public String spaceDelimitedString;

        static {
            normalizedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf(':')).setExpandedSegments(true).setRadix(16).toParams();
            canonicalParams = new MACStringOptions.Builder().setSeparator(Character.valueOf('-')).setExpandedSegments(true).setRadix(16).setWildcards(new AddressDivisionGrouping.StringOptions.Wildcards(MACAddress.DASHED_SEGMENT_RANGE_SEPARATOR_STR, Address.SEGMENT_WILDCARD_STR, null)).toParams();
            compressedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf(':')).setRadix(16).toParams();
            dottedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf('.')).setExpandedSegments(true).setRadix(16).toParams();
            spaceDelimitedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf(' ')).setExpandedSegments(true).setRadix(16).toParams();
        }

        protected MACStringCache() {
        }
    }

    public static class MACStringOptions
    extends AddressDivisionGrouping.StringOptions {
        protected MACStringOptions(int base, boolean expandSegments, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, String label, boolean reverse, boolean splitDigits, boolean uppercase) {
            super(base, expandSegments, wildcards, segmentStrPrefix, separator, label, reverse, splitDigits, uppercase);
        }

        public static class Builder
        extends AddressDivisionGrouping.StringOptions.Builder {
            public Builder() {
                this(16, ':');
            }

            protected Builder(int base, char separator) {
                super(base, separator);
            }

            @Override
            public MACStringOptions toParams() {
                return new MACStringOptions(this.base, this.expandSegments, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }
}

