/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;

public class MACAddressNetwork
extends AddressNetwork {
    private MACAddressCreator creator = this.createAddressCreator();

    protected MACAddressCreator createAddressCreator() {
        return new MACAddressCreator();
    }

    public MACAddressCreator getAddressCreator() {
        return this.creator;
    }

    MACAddressNetwork() {
    }

    public static class MACAddressCreator
    extends AddressCreator<MACAddress, MACAddressSection, MACAddressSection, MACAddressSegment>
    implements AddressNetwork.AddressSegmentCreator<MACAddressSegment> {
        MACAddressSegment[] emptySegments = new MACAddressSegment[0];
        MACAddressSection[] emptySection = new MACAddressSection[0];
        private static MACAddressSegment[] segmentCache = new MACAddressSegment[256];

        public MACAddressSegment[] createSegmentArray(int length) {
            if (length == 0) {
                return this.emptySegments;
            }
            return new MACAddressSegment[length];
        }

        @Override
        public MACAddressSegment createSegment(int value) {
            MACAddressSegment result = segmentCache[value];
            if (result == null) {
                MACAddressCreator.segmentCache[value] = result = new MACAddressSegment(value);
            }
            return result;
        }

        @Override
        public MACAddressSegment createSegment(int value, Integer segmentPrefixLength) {
            if (segmentPrefixLength != null) {
                if (segmentPrefixLength == 0) {
                    return MACAddressSegment.ALL_RANGE_SEGMENT;
                }
                int max = 255;
                int mask = -1 << 8 - segmentPrefixLength & max;
                int newLower = value & mask;
                int newUpper = value | ~mask & max;
                return this.createSegment(newLower, newUpper);
            }
            return this.createSegment(value);
        }

        public MACAddressSegment createSegment(int lower, int upper) {
            if (lower != upper) {
                if (lower == 0 && upper == 255) {
                    return MACAddressSegment.ALL_RANGE_SEGMENT;
                }
                return new MACAddressSegment(lower, upper);
            }
            return this.createSegment(lower);
        }

        @Override
        public MACAddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            if (segmentPrefixLength == null) {
                return this.createSegment(lower, upper);
            }
            if (segmentPrefixLength == 0) {
                return MACAddressSegment.ALL_RANGE_SEGMENT;
            }
            int max = 255;
            int mask = -1 << 8 - segmentPrefixLength & max;
            int newLower = lower & mask;
            int newUpper = upper | ~mask & max;
            return this.createSegment(newLower, newUpper);
        }

        @Override
        protected MACAddressSegment createSegmentInternal(int value, Integer segmentPrefixLength, CharSequence addressStr, int originalVal, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex) {
            MACAddressSegment segment = this.createSegment(value, segmentPrefixLength);
            segment.setString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            return segment;
        }

        @Override
        protected MACAddressSegment createSegmentInternal(int lower, int upper, Integer segmentPrefixLength, CharSequence addressStr, int originalLower, int originalUpper, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex) {
            MACAddressSegment segment = this.createSegment(lower, upper, segmentPrefixLength);
            segment.setString(addressStr, isStandardRangeString, lowerStringStartIndex, upperStringEndIndex, originalLower, originalUpper);
            return segment;
        }

        MACAddressSection createSection(long bytes, int startIndex, boolean extended, Integer prefixLength) {
            return new MACAddressSection(bytes, startIndex, extended, prefixLength);
        }

        MACAddressSection createSection(byte[] bytes, int startIndex, boolean extended, Integer prefixLength) {
            return new MACAddressSection(bytes, startIndex, extended, prefixLength);
        }

        MACAddressSection createSection(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int startIndex, boolean extended, Integer prefixLength) {
            return new MACAddressSection(lowerValueProvider, upperValueProvider, startIndex, extended, prefixLength);
        }

        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments) {
            return new MACAddressSection(false, segments, 0, segments.length > 6);
        }

        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments, boolean extended) {
            return new MACAddressSection(false, segments, 0, extended);
        }

        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments, int startIndex, boolean extended) {
            return new MACAddressSection(false, segments, startIndex, extended);
        }

        MACAddressSection createSection(MACAddressSegment[] segments, boolean extended, Integer prefixLength) {
            return new MACAddressSection(segments, 0, extended, prefixLength);
        }

        protected MACAddress createAddressInternal(MACAddressSegment[] segments) {
            return this.createAddress(this.createSectionInternal(segments));
        }

        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, HostIdentifierString from) {
            MACAddress result = this.createAddress(section);
            result.cache(from);
            return result;
        }

        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, CharSequence zone, HostIdentifierString from) {
            MACAddress result = this.createAddress(section);
            result.cache(from);
            return result;
        }

        @Override
        public MACAddress createAddress(MACAddressSection section) {
            return new MACAddress(section);
        }
    }
}

