/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import java.util.Iterator;

public class IPv4AddressSegment
extends IPAddressSegment
implements Iterable<IPv4AddressSegment> {
    private static final long serialVersionUID = 3L;
    public static final int MAX_CHARS = 3;
    static final IPv4AddressSegment ZERO_SEGMENT = IPv4AddressSegment.getSegmentCreator().createSegment(0);
    static final IPv4AddressSegment ZERO_PREFIX_SEGMENT = new IPv4AddressSegment(0, 0);
    static final IPv4AddressSegment ALL_RANGE_SEGMENT = new IPv4AddressSegment(0, 255, null);

    public IPv4AddressSegment(int value) {
        super(value);
        if (value > 255) {
            throw new IllegalArgumentException();
        }
    }

    public IPv4AddressSegment(int value, Integer segmentPrefixLength) {
        super(value, segmentPrefixLength == null ? null : Integer.valueOf(Math.min(8, segmentPrefixLength)));
        if (this.getLowerSegmentValue() > 255) {
            throw new IllegalArgumentException();
        }
    }

    public IPv4AddressSegment(int lower, int upper, Integer segmentPrefixLength) {
        super(lower, upper, segmentPrefixLength == null ? null : Integer.valueOf(Math.min(8, segmentPrefixLength)));
        if (this.getUpperSegmentValue() > 255) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        return new byte[]{(byte)(low ? this.getLowerSegmentValue() : this.getUpperSegmentValue())};
    }

    @Override
    protected int getSegmentNetworkMask(int bits) {
        return IPv4Address.network().getSegmentNetworkMask(bits);
    }

    @Override
    protected int getSegmentHostMask(int bits) {
        return IPv4Address.network().getSegmentHostMask(bits);
    }

    @Override
    public int getMaxSegmentValue() {
        return IPv4AddressSegment.getMaxSegmentValue(IPAddress.IPVersion.IPV4);
    }

    @Override
    public IPv4AddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        return this.toNetworkSegment(segmentPrefixLength, true);
    }

    @Override
    public IPv4AddressSegment toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength) {
        if (this.isNetworkChangedByPrefix(segmentPrefixLength, withPrefixLength)) {
            return super.toNetworkSegment(segmentPrefixLength, withPrefixLength, IPv4AddressSegment.getSegmentCreator());
        }
        return this;
    }

    @Override
    public IPv4AddressSegment toHostSegment(Integer bits) {
        if (this.isHostChangedByPrefix(bits)) {
            return super.toHostSegment(bits, IPv4AddressSegment.getSegmentCreator());
        }
        return this;
    }

    @Override
    public IPv4AddressSegment toMaskedSegment(IPAddressSegment maskSegment, Integer segmentPrefixLength) throws AddressTypeException {
        if (this.isChangedByMask(maskSegment, segmentPrefixLength)) {
            if (!this.isMaskCompatibleWithRange(maskSegment, segmentPrefixLength)) {
                throw new AddressTypeException(this, maskSegment, "ipaddress.error.maskMismatch");
            }
            return IPv4AddressSegment.getSegmentCreator().createSegment(this.getLowerSegmentValue() & maskSegment.getLowerSegmentValue(), this.getUpperSegmentValue() & maskSegment.getLowerSegmentValue(), segmentPrefixLength);
        }
        return this;
    }

    protected boolean isChangedByMask(IPAddressSegment maskSegment, Integer segmentPrefixLength) throws AddressTypeException {
        if (!(maskSegment instanceof IPv4AddressSegment)) {
            throw new AddressTypeException(this, maskSegment, "ipaddress.error.typeMismatch");
        }
        return super.isChangedByMask(maskSegment.getLowerSegmentValue(), segmentPrefixLength);
    }

    @Override
    public IPv4AddressSegment getLower() {
        return IPv4AddressSegment.getLowestOrHighest(this, IPv4AddressSegment.getSegmentCreator(), true);
    }

    @Override
    public IPv4AddressSegment getUpper() {
        return IPv4AddressSegment.getLowestOrHighest(this, IPv4AddressSegment.getSegmentCreator(), false);
    }

    public static IPv4AddressNetwork.IPv4AddressCreator getSegmentCreator() {
        return IPv4Address.network().getAddressCreator();
    }

    public Iterable<IPv4AddressSegment> getIterable() {
        return this;
    }

    @Override
    public Iterator<IPv4AddressSegment> iterator() {
        return IPv4AddressSegment.iterator(this, IPv4AddressSegment.getSegmentCreator(), !this.isPrefixed());
    }

    static IPv4AddressSegment getZeroSegment() {
        return ZERO_SEGMENT;
    }

    @Override
    public int getBitCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 10;
    }

    @Override
    public int getMaxDigitCount() {
        return 3;
    }

    @Override
    public IPv4AddressSegment reverseBits(boolean perByte) {
        return this.reverseBits();
    }

    public IPv4AddressSegment reverseBits() {
        int newVal;
        if (this.isMultiple()) {
            if (IPv4AddressSegment.isReversibleRange(this)) {
                if (this.isPrefixed()) {
                    IPv4AddressNetwork.IPv4AddressCreator creator = IPv4AddressSegment.getSegmentCreator();
                    return (IPv4AddressSegment)creator.createSegment(this.getLowerSegmentValue(), this.getUpperSegmentValue(), null);
                }
                return this;
            }
            throw new AddressTypeException(this, "ipaddress.error.reverseRange");
        }
        int oldVal = this.getLowerSegmentValue();
        if (oldVal == (newVal = IPv4AddressSegment.reverseBits((byte)oldVal)) && !this.isPrefixed()) {
            return this;
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4AddressSegment.getSegmentCreator();
        return (IPv4AddressSegment)creator.createSegment(newVal);
    }

    @Override
    public IPv4AddressSegment reverseBytes() {
        return IPv4AddressSegment.removePrefix(this, false, IPv4AddressSegment.getSegmentCreator());
    }

    @Override
    public IPv4AddressSegment removePrefixLength(boolean zeroed) {
        return IPv4AddressSegment.removePrefix(this, zeroed, IPv4AddressSegment.getSegmentCreator());
    }

    @Override
    public IPv4AddressSegment removePrefixLength() {
        return this.removePrefixLength(true);
    }

    @Override
    public boolean contains(AddressSegment other) {
        return other instanceof IPv4AddressSegment && super.contains(other);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IPv4AddressSegment && this.isSameValues((IPv4AddressSegment)other);
    }
}

