/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import java.io.Serializable;
import java.util.Map;

public abstract class IPAddressNetwork
extends AddressNetwork {
    private static final IPAddressString[] subnetPrefixes = new IPAddressString[129];

    public IPAddress getNetworkMask(int networkPrefixLength) {
        return this.getNetworkMask(networkPrefixLength, true);
    }

    public abstract IPAddress getNetworkMask(int var1, boolean var2);

    public abstract IPAddressSection getNetworkMaskSection(int var1);

    public abstract IPAddress getHostMask(int var1);

    public abstract IPAddressSection getHostMaskSection(int var1);

    public abstract int getSegmentNetworkMask(int var1);

    public abstract int getSegmentHostMask(int var1);

    public abstract long getSegmentNetworkMask(int var1, int var2);

    public abstract long getSegmentHostMask(int var1, int var2);

    public abstract IPAddress getLoopback();

    public abstract String[] getStandardLoopbackStrings();

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public abstract IPAddress.IPVersion getIPVersion();

    public static IPAddressString getPrefix(int networkPrefixLength) throws AddressTypeException {
        return IPAddressNetwork.getPrefix(networkPrefixLength, subnetPrefixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IPAddressString getPrefix(int networkPrefixLength, IPAddressString[] cache) throws AddressTypeException {
        IPAddressString.validateNetworkPrefix(null, networkPrefixLength, false);
        int cacheIndex = networkPrefixLength;
        IPAddressString prefix = cache[cacheIndex];
        if (prefix != null) return prefix;
        IPAddressString[] iPAddressStringArray = cache;
        synchronized (cache) {
            prefix = cache[cacheIndex];
            if (prefix != null) return prefix;
            cache[cacheIndex] = prefix = new IPAddressString(new StringBuilder(HostIdentifierStringValidator.MAX_PREFIX_CHARS + 1).append('/').append(networkPrefixLength).toString());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return prefix;
        }
    }

    public static abstract class HostIdentifierStringCache<T extends HostIdentifierString>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Map<String, T> backingMap;

        public HostIdentifierStringCache(Map<String, T> backingMap) {
            this.backingMap = backingMap;
        }

        public Map<String, T> getBackingMap() {
            return this.backingMap;
        }

        protected void added(T added) {
        }

        public boolean contains(T value) {
            return this.backingMap.containsValue(value);
        }

        public T get(String key) {
            HostIdentifierString result = (HostIdentifierString)this.backingMap.get(key);
            if (result == null) {
                result = this.create(key);
                String normalizedKey = result.toNormalizedString();
                HostIdentifierString existing = this.backingMap.putIfAbsent(normalizedKey, result = this.create(normalizedKey));
                if (existing == null) {
                    this.added(result);
                } else {
                    result = existing;
                }
                if (!normalizedKey.equals(key)) {
                    this.backingMap.put(key, result);
                }
            }
            return (T)result;
        }

        public static Address.SegmentValueProvider getValueProvider(byte[] bytes) {
            return (segmentIndex, segmentByteCount) -> {
                int value = 0;
                int start = segmentIndex * segmentByteCount;
                int end = start + segmentByteCount;
                while (start < end) {
                    value = value << 8 | 0xFF & bytes[start];
                    ++start;
                }
                return value;
            };
        }

        public T get(byte[] bytes) {
            return this.get(bytes.length == 4 ? IPAddress.IPVersion.IPV4 : IPAddress.IPVersion.IPV6, HostIdentifierStringCache.getValueProvider(bytes), null, null, null);
        }

        public T get(IPAddress.IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength) {
            return this.get(version, lowerValueProvider, upperValueProvider, prefixLength, null);
        }

        public T get(IPAddress.IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, CharSequence zone) {
            String key = IPAddress.toNormalizedString(version, lowerValueProvider, upperValueProvider, prefixLength, zone);
            HostIdentifierString result = (HostIdentifierString)this.backingMap.get(key);
            if (result == null) {
                IPAddress addr = IPAddress.from(version, lowerValueProvider, upperValueProvider, prefixLength, zone);
                addr.cacheNormalizedString(key);
                result = this.create(addr);
                HostIdentifierString existing = this.backingMap.putIfAbsent(key, result);
                if (existing == null) {
                    this.added(result);
                } else {
                    result = existing;
                    this.cache(result, addr);
                }
            }
            return (T)result;
        }

        protected abstract T create(String var1);

        protected abstract T create(IPAddress var1);

        protected abstract void cache(T var1, IPAddress var2);
    }

    public static class HostNameCache
    extends HostIdentifierStringCache<HostName> {
        private static final long serialVersionUID = 1L;
        HostNameParameters options;

        public HostNameCache(Map<String, HostName> backingMap, HostNameParameters options) {
            super(backingMap);
            this.options = options;
        }

        public HostNameCache(Map<String, HostName> backingMap) {
            super(backingMap);
        }

        @Override
        protected HostName create(String key) {
            return this.options == null ? new HostName(key) : new HostName(key, this.options);
        }

        @Override
        protected HostName create(IPAddress addr) {
            return new HostName(addr);
        }

        @Override
        public HostName get(String key) {
            return (HostName)super.get(key);
        }

        @Override
        public HostName get(byte[] bytes) {
            return (HostName)super.get(bytes);
        }

        @Override
        public HostName get(IPAddress.IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength) {
            return (HostName)super.get(version, lowerValueProvider, upperValueProvider, prefixLength);
        }

        @Override
        public HostName get(IPAddress.IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, CharSequence zone) {
            return (HostName)super.get(version, lowerValueProvider, upperValueProvider, prefixLength, zone);
        }

        @Override
        protected void cache(HostName result, IPAddress addr) {
            result.cacheAddress(addr);
        }
    }

    public static class IPAddressStringCache
    extends HostIdentifierStringCache<IPAddressString> {
        private static final long serialVersionUID = 1L;
        IPAddressStringParameters options;

        public IPAddressStringCache(Map<String, IPAddressString> backingMap, IPAddressStringParameters options) {
            super(backingMap);
            this.options = options;
        }

        public IPAddressStringCache(Map<String, IPAddressString> backingMap) {
            super(backingMap);
        }

        @Override
        protected IPAddressString create(String addressString) {
            return this.options == null ? new IPAddressString(addressString) : new IPAddressString(addressString, this.options);
        }

        @Override
        protected IPAddressString create(IPAddress addr) {
            return addr.toAddressString();
        }

        @Override
        public IPAddressString get(String key) {
            return (IPAddressString)super.get(key);
        }

        @Override
        public IPAddressString get(byte[] bytes) {
            return (IPAddressString)super.get(bytes);
        }

        @Override
        public IPAddressString get(IPAddress.IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength) {
            return (IPAddressString)super.get(version, lowerValueProvider, upperValueProvider, prefixLength);
        }

        @Override
        public IPAddressString get(IPAddress.IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, CharSequence zone) {
            return (IPAddressString)super.get(version, lowerValueProvider, upperValueProvider, prefixLength, zone);
        }

        @Override
        protected void cache(IPAddressString result, IPAddress addr) {
            result.cacheAddress(addr);
        }
    }
}

