/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.Validator;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class HostName
implements HostIdentifierString,
Comparable<HostName> {
    private static final long serialVersionUID = 3L;
    public static final char LABEL_SEPARATOR = '.';
    public static final char IPV6_START_BRACKET = '[';
    public static final char IPV6_END_BRACKET = ']';
    public static final char PORT_SEPARATOR = ':';
    private static final HostNameParameters DEFAULT_BASIC_VALIDATION_OPTIONS = new HostNameParameters.Builder().toParams();
    private final String host;
    private transient String normalizedString;
    private transient String normalizedWildcardString;
    private ParsedHost parsedHost;
    private HostNameException validationException;
    IPAddress resolvedAddress;
    private boolean resolvedIsNull;
    private final HostNameParameters validationOptions;

    public HostName(IPAddress addr) {
        this.normalizedString = this.host = addr.toNormalizedString();
        this.parsedHost = new ParsedHost(this.host, addr.getProvider());
        this.validationOptions = null;
    }

    public HostName(InetAddress inetAddr) {
        this(IPAddress.from(inetAddr));
    }

    HostName(String hostStr, ParsedHost parsed) {
        this.host = hostStr;
        this.parsedHost = parsed;
        this.validationOptions = null;
    }

    public HostName(String host) {
        this(host, DEFAULT_BASIC_VALIDATION_OPTIONS);
    }

    public HostName(String host, HostNameParameters options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.validationOptions = options;
        this.host = host == null ? "" : host.trim();
    }

    void cacheAddress(IPAddress addr) {
        if (this.parsedHost == null) {
            this.parsedHost = new ParsedHost(this.host, addr.getProvider());
            this.normalizedString = addr.toNormalizedString();
        } else if (this.normalizedString == null) {
            this.normalizedString = addr.toNormalizedString();
        }
    }

    public HostNameParameters getValidationOptions() {
        return this.validationOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() throws HostNameException {
        if (this.parsedHost != null) {
            return;
        }
        if (this.validationException != null) {
            throw this.validationException;
        }
        HostName hostName = this;
        synchronized (hostName) {
            if (this.parsedHost != null) {
                return;
            }
            if (this.validationException != null) {
                throw this.validationException;
            }
            try {
                this.parsedHost = this.getValidator().validateHost(this);
            }
            catch (HostNameException e) {
                this.validationException = e;
                throw e;
            }
        }
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    public boolean isValid() {
        if (this.parsedHost != null) {
            return true;
        }
        if (this.validationException != null) {
            return false;
        }
        try {
            this.validate();
            return true;
        }
        catch (HostNameException e) {
            return false;
        }
    }

    public boolean resolvesToSelf() {
        return this.isSelf() || this.getAddress() != null && this.resolvedAddress.isLoopback();
    }

    public boolean isSelf() {
        return this.isLocalHost() || this.isLoopback();
    }

    public boolean isLocalHost() {
        return this.isValid() && this.host.equalsIgnoreCase("localhost");
    }

    public boolean isLoopback() {
        return this.isAddress() && this.asAddress().isLoopback();
    }

    public InetAddress toInetAddress() throws HostNameException, UnknownHostException {
        this.validate();
        return this.toAddress().toInetAddress();
    }

    @Override
    public String toNormalizedString() {
        String result = this.normalizedString;
        if (result == null) {
            this.normalizedString = result = this.toNormalizedString(false);
        }
        return result;
    }

    private String toNormalizedWildcardString() {
        String result = this.normalizedWildcardString;
        if (result == null) {
            this.normalizedWildcardString = result = this.toNormalizedString(true);
        }
        return result;
    }

    private String toNormalizedString(boolean wildcard) {
        if (this.isValid()) {
            StringBuilder builder = new StringBuilder();
            if (this.isAddress()) {
                IPAddress addr = this.asAddress();
                if (addr.isIPv6()) {
                    if (!wildcard && addr.isPrefixed()) {
                        int bits = addr.getNetworkPrefixLength();
                        IPAddress addrNoPrefix = addr.removePrefixLength();
                        builder.append('[').append(addrNoPrefix.toNormalizedString()).append(']').append('/').append(bits);
                    } else {
                        builder.append('[').append(addr.toNormalizedWildcardString()).append(']');
                    }
                } else {
                    builder.append(wildcard ? addr.toNormalizedWildcardString() : addr.toNormalizedString());
                }
            } else if (this.isAddressString()) {
                builder.append(this.asAddressString().toNormalizedString());
            } else {
                builder.append(this.parsedHost.getHost());
                Integer networkPrefixLength = this.parsedHost.getEquivalentPrefixLength();
                if (networkPrefixLength != null) {
                    builder.append('/').append(networkPrefixLength);
                } else {
                    IPAddress mask = this.parsedHost.getMask();
                    if (mask != null) {
                        builder.append('/').append(mask.toNormalizedString());
                    }
                }
            }
            Integer port = this.getPort();
            if (port != null) {
                builder.append(':').append(port);
            }
            return builder.toString();
        }
        return this.host;
    }

    public boolean equals(Object o) {
        return o instanceof HostName && this.matches((HostName)o);
    }

    public int hashCode() {
        return this.toNormalizedWildcardString().hashCode();
    }

    public String[] getNormalizedLabels() {
        if (this.isValid()) {
            return this.parsedHost.getNormalizedLabels();
        }
        if (this.host.length() == 0) {
            return new String[0];
        }
        return new String[]{this.host};
    }

    public String getHost() {
        if (this.isValid()) {
            return this.parsedHost.getHost();
        }
        return null;
    }

    public boolean matches(HostName host) {
        if (this == host) {
            return true;
        }
        if (this.isValid()) {
            if (host.isValid()) {
                String otherHost;
                if (this.isAddressString()) {
                    return host.isAddressString() && this.asAddressString().equals(host.asAddressString()) && Objects.equals(this.getPort(), host.getPort());
                }
                if (host.isAddressString()) {
                    return false;
                }
                String thisHost = this.parsedHost.getHost();
                if (!thisHost.equals(otherHost = host.parsedHost.getHost())) {
                    return false;
                }
                return Objects.equals(this.parsedHost.getEquivalentPrefixLength(), host.parsedHost.getEquivalentPrefixLength()) && Objects.equals(this.parsedHost.getMask(), host.parsedHost.getMask()) && Objects.equals(this.parsedHost.getPort(), host.parsedHost.getPort());
            }
            return false;
        }
        return !host.isValid() && this.toString().equals(host.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(HostName other) {
        if (this.isValid()) {
            if (!other.isValid()) return 1;
            if (this.isAddressString()) {
                if (!other.isAddressString()) return -1;
                int result = this.asAddressString().compareTo(other.asAddressString());
                if (result != 0) {
                    return result;
                }
            } else {
                if (other.isAddressString()) {
                    return 1;
                }
                String[] normalizedLabels = this.parsedHost.getNormalizedLabels();
                String[] otherNormalizedLabels = other.parsedHost.getNormalizedLabels();
                int oneLen = normalizedLabels.length;
                int twoLen = otherNormalizedLabels.length;
                int i = 1;
                int minLen = Math.min(oneLen, twoLen);
                while (i <= minLen) {
                    String one = normalizedLabels[oneLen - i];
                    String two = otherNormalizedLabels[twoLen - i];
                    int result = one.compareTo(two);
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                }
                if (oneLen != twoLen) {
                    return oneLen - twoLen;
                }
                Integer networkPrefixLength = this.parsedHost.getEquivalentPrefixLength();
                Integer otherPrefixLength = other.parsedHost.getEquivalentPrefixLength();
                if (networkPrefixLength != null) {
                    if (otherPrefixLength == null) return 1;
                    if (networkPrefixLength.intValue() != otherPrefixLength.intValue()) {
                        return otherPrefixLength - networkPrefixLength;
                    }
                } else {
                    if (otherPrefixLength != null) {
                        return -1;
                    }
                    IPAddress mask = this.parsedHost.getMask();
                    IPAddress otherMask = other.parsedHost.getMask();
                    if (mask != null) {
                        if (otherMask == null) return 1;
                        int ret = mask.compareTo(otherMask);
                        if (ret != 0) {
                            return ret;
                        }
                    } else if (otherMask != null) {
                        return -1;
                    }
                }
            }
            if (this.parsedHost.getPort() != null) {
                if (other.parsedHost.getPort() == null) return 1;
                return this.parsedHost.getPort() - other.parsedHost.getPort();
            }
            if (other.getPort() == null) return 0;
            return -1;
        }
        if (!other.isValid()) return this.toString().compareTo(other.toString());
        return -1;
    }

    public boolean isAddress(IPAddress.IPVersion version) {
        return this.isValid() && this.parsedHost.isAddressString() && this.parsedHost.asAddress(version) != null;
    }

    public boolean isAddress() {
        return this.isAddressString() && this.parsedHost.asAddress() != null;
    }

    public boolean isAddressString() {
        return this.isValid() && this.parsedHost.isAddressString();
    }

    public boolean isAllAddresses() {
        return this.isAddressString() && this.parsedHost.getAddressProvider().isAllAddresses();
    }

    public boolean isPrefixOnly() {
        return this.isAddressString() && this.parsedHost.getAddressProvider().isPrefixOnly();
    }

    public boolean isEmpty() {
        return this.isAddressString() && this.parsedHost.getAddressProvider().isEmpty();
    }

    public Integer getPort() {
        return this.isValid() ? this.parsedHost.getPort() : null;
    }

    public AddressStringException getAddressStringException() {
        if (this.isValid()) {
            return this.parsedHost.getAddressStringException();
        }
        return null;
    }

    public boolean isUNCIPv6Literal() {
        return this.isValid() && this.parsedHost.isUNCIPv6Literal();
    }

    public boolean isReverseDNS() {
        return this.isValid() && this.parsedHost.isReverseDNS();
    }

    public IPAddressString asAddressString() {
        if (this.isAddressString()) {
            return this.parsedHost.asGenericAddressString();
        }
        return null;
    }

    public IPAddress asAddress() {
        if (this.isAddress()) {
            return this.parsedHost.asAddress();
        }
        return null;
    }

    public IPAddress asAddress(IPAddress.IPVersion version) {
        if (this.isAddress(version)) {
            return this.parsedHost.asAddress(version);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPAddress toAddress() throws UnknownHostException, HostNameException {
        IPAddress addr = this.resolvedAddress;
        if (addr == null && !this.resolvedIsNull) {
            this.validate();
            HostName hostName = this;
            synchronized (hostName) {
                addr = this.resolvedAddress;
                if (addr == null && !this.resolvedIsNull) {
                    if (this.parsedHost.isAddressString()) {
                        addr = this.parsedHost.asAddress();
                        this.resolvedIsNull = addr == null;
                    } else {
                        String strHost = this.parsedHost.getHost();
                        if (strHost.length() == 0 && !this.validationOptions.emptyIsLoopback) {
                            addr = null;
                            this.resolvedIsNull = true;
                        } else {
                            IPAddressTypeNetwork.IPAddressCreator creator;
                            IPAddress mask;
                            InetAddress inetAddress = InetAddress.getByName(strHost);
                            byte[] bytes = inetAddress.getAddress();
                            Integer networkPrefixLength = this.parsedHost.getNetworkPrefixLength();
                            if (networkPrefixLength == null && (mask = this.parsedHost.getMask()) != null) {
                                byte[] maskBytes = mask.getBytes();
                                if (maskBytes.length != bytes.length) {
                                    throw new HostNameException(this.host, "ipaddress.error.ipMismatch");
                                }
                                int i = 0;
                                while (i < bytes.length) {
                                    int n = i;
                                    bytes[n] = (byte)(bytes[n] & maskBytes[i]);
                                    ++i;
                                }
                                networkPrefixLength = mask.getMaskPrefixLength(true);
                            }
                            if (bytes.length == 16) {
                                creator = IPv6Address.network().getAddressCreator();
                                addr = creator.createAddressInternal(bytes, networkPrefixLength, null, this);
                            } else {
                                creator = IPv4Address.network().getAddressCreator();
                                addr = creator.createAddressInternal(bytes, networkPrefixLength, this);
                            }
                        }
                    }
                    this.resolvedAddress = addr;
                }
            }
        }
        return addr;
    }

    @Override
    public IPAddress getAddress() {
        try {
            return this.toAddress();
        }
        catch (HostNameException | UnknownHostException exception) {
            return null;
        }
    }

    public String toString() {
        return this.host;
    }
}

