/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import inet.ipaddr.format.IPAddressJoinedSegments;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv4.IPv4JoinedSegments;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.util.Comparator;
import java.util.Objects;

abstract class BaseComparator
implements AddressComparator {
    BaseComparator() {
    }

    @Override
    public int compare(Address one, Address two) {
        if (one == two) {
            return 0;
        }
        int result = this.compare(one.getSection(), two.getSection());
        if (result == 0 && one instanceof IPv6Address) {
            IPv6Address oneIPv6 = (IPv6Address)one;
            IPv6Address twoIPv6 = (IPv6Address)two;
            result = Objects.compare(oneIPv6.getZone(), twoIPv6.getZone(), Comparator.nullsFirst(String::compareTo));
        }
        return result;
    }

    private static int mapGroupingClass(Class<?> clazz) {
        if (clazz.equals(AddressDivisionGrouping.class)) {
            return 1;
        }
        if (clazz.equals(MACAddressSection.class)) {
            return 2;
        }
        if (clazz.equals(IPAddressDivisionGrouping.class)) {
            return 3;
        }
        if (clazz.equals(IPv4AddressSection.class)) {
            return 4;
        }
        if (clazz.equals(IPv6AddressSection.IPv6v4MixedAddressSection.class)) {
            return 5;
        }
        if (clazz.equals(IPv6AddressSection.class)) {
            return 6;
        }
        return 0;
    }

    private static int mapDivisionClass(Class<?> clazz) {
        if (clazz.equals(MACAddressSegment.class)) {
            return 1;
        }
        if (clazz.equals(IPv4JoinedSegments.class)) {
            return 2;
        }
        if (clazz.equals(IPv4AddressSegment.class)) {
            return 3;
        }
        if (clazz.equals(IPv6AddressSegment.class)) {
            return 4;
        }
        return 0;
    }

    @Override
    public int compare(AddressSection one, AddressSection two) {
        Class<?> twoClass;
        if (one == two) {
            return 0;
        }
        Class<?> oneClass = one.getClass();
        if (!oneClass.equals(twoClass = two.getClass())) {
            return BaseComparator.mapGroupingClass(oneClass) - BaseComparator.mapGroupingClass(twoClass);
        }
        if (one instanceof IPv6AddressSection) {
            IPv6AddressSection o1 = (IPv6AddressSection)one;
            IPv6AddressSection o2 = (IPv6AddressSection)two;
            int result = o2.startIndex - o1.startIndex;
            if (result != 0) {
                return result;
            }
        } else if (one instanceof MACAddressSection) {
            MACAddressSection o1 = (MACAddressSection)one;
            MACAddressSection o2 = (MACAddressSection)two;
            int result = o2.startIndex - o1.startIndex;
            if (result != 0) {
                return result;
            }
        }
        return this.compareParts(one, two);
    }

    @Override
    public int compare(AddressDivisionSeries one, AddressDivisionSeries two) {
        Class<?> twoClass;
        if (one instanceof AddressSection && two instanceof AddressSection) {
            return this.compare((AddressSection)one, (AddressSection)two);
        }
        if (one == two) {
            return 0;
        }
        Class<?> oneClass = one.getClass();
        if (!oneClass.equals(twoClass = two.getClass())) {
            return BaseComparator.mapGroupingClass(oneClass) - BaseComparator.mapGroupingClass(twoClass);
        }
        return this.compareParts(one, two);
    }

    @Override
    public int compare(AddressSegment one, AddressSegment two) {
        Class<?> twoClass;
        if (one == two) {
            return 0;
        }
        Class<?> oneClass = one.getClass();
        if (!oneClass.equals(twoClass = two.getClass())) {
            return BaseComparator.mapDivisionClass(oneClass) - BaseComparator.mapDivisionClass(twoClass);
        }
        return this.compareValues(one.getUpperSegmentValue(), one.getLowerSegmentValue(), two.getUpperSegmentValue(), two.getLowerSegmentValue());
    }

    @Override
    public int compare(AddressDivision one, AddressDivision two) {
        Class<?> twoClass;
        if (one instanceof AddressSegment && two instanceof AddressSegment) {
            return this.compare((AddressSegment)((Object)one), (AddressSegment)((Object)two));
        }
        if (one == two) {
            return 0;
        }
        Class<?> oneClass = one.getClass();
        if (!oneClass.equals(twoClass = two.getClass())) {
            return BaseComparator.mapDivisionClass(oneClass) - BaseComparator.mapDivisionClass(twoClass);
        }
        if (one instanceof IPAddressJoinedSegments) {
            IPAddressJoinedSegments o1 = (IPAddressJoinedSegments)one;
            IPAddressJoinedSegments o2 = (IPAddressJoinedSegments)two;
            int result = o1.getJoinedCount() - o2.getJoinedCount();
            if (result != 0) {
                return result;
            }
        }
        return BaseComparator.convertResult(this.compareValues(one.getUpperValue(), one.getLowerValue(), two.getUpperValue(), two.getLowerValue()));
    }

    protected abstract int compareParts(AddressDivisionSeries var1, AddressDivisionSeries var2);

    protected abstract int compareParts(AddressSection var1, AddressSection var2);

    protected abstract long compareValues(long var1, long var3, long var5, long var7);

    protected abstract int compareValues(int var1, int var2, int var3, int var4);

    static int convertResult(long v) {
        return v == 0L ? 0 : (v > 0L ? 1 : -1);
    }
}

