/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.BaseComparator;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionSeries;
import java.util.Comparator;

public interface AddressComparator
extends Comparator<Address> {
    @Override
    public int compare(AddressDivisionSeries var1, AddressDivisionSeries var2);

    @Override
    public int compare(AddressDivision var1, AddressDivision var2);

    public static class CountComparator
    extends BaseComparator {
        private static int compareCount(AddressDivisionSeries one, AddressDivisionSeries two) {
            return one.isMore(two);
        }

        @Override
        protected int compareParts(AddressSection one, AddressSection two) {
            int result = one.getBitCount() - two.getBitCount();
            if (result == 0 && (result = CountComparator.compareCount(one, two)) == 0) {
                result = this.compareEqualSizedSections(one, two);
            }
            return result;
        }

        @Override
        protected int compareParts(AddressDivisionSeries one, AddressDivisionSeries two) {
            int result = one.getBitCount() - two.getBitCount();
            if (result == 0 && (result = CountComparator.compareCount(one, two)) == 0) {
                result = this.compareSegmentGroupings(one, two);
            }
            return result;
        }

        private int compareSegmentGroupings(AddressDivisionSeries one, AddressDivisionSeries two) {
            long twoLower;
            int twoIndex = 0;
            int oneIndex = 0;
            int twoBitCount = 0;
            int oneBitCount = 0;
            long twoUpper = twoLower = (long)0;
            long oneLower = twoLower;
            long oneUpper = twoLower;
            while (oneIndex < one.getDivisionCount() || twoIndex < two.getDivisionCount()) {
                if (oneBitCount == 0) {
                    AddressDivision oneCombo = one.getDivision(oneIndex++);
                    oneBitCount = oneCombo.getBitCount();
                    oneUpper = oneCombo.getUpperValue();
                    oneLower = oneCombo.getLowerValue();
                }
                if (twoBitCount == 0) {
                    AddressDivision twoCombo = two.getDivision(twoIndex++);
                    twoBitCount = twoCombo.getBitCount();
                    twoUpper = twoCombo.getUpperValue();
                    twoLower = twoCombo.getLowerValue();
                }
                long oneResultUpper = oneUpper;
                long oneResultLower = oneLower;
                long twoResultUpper = twoUpper;
                long twoResultLower = twoLower;
                if (twoBitCount == oneBitCount) {
                    twoBitCount = 0;
                    oneBitCount = 0;
                } else {
                    long mask;
                    int diffBits = twoBitCount - oneBitCount;
                    if (diffBits > 0) {
                        twoResultUpper >>= diffBits;
                        twoResultLower >>= diffBits;
                        mask = -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                        twoUpper &= mask;
                        twoLower &= mask;
                        twoBitCount = diffBits;
                        oneBitCount = 0;
                    } else {
                        diffBits = -diffBits;
                        oneResultUpper >>= diffBits;
                        oneResultLower >>= diffBits;
                        mask = -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                        oneUpper &= mask;
                        oneLower &= mask;
                        oneBitCount = diffBits;
                        twoBitCount = 0;
                    }
                }
                long result = this.compareValues(oneResultUpper, oneResultLower, twoResultUpper, twoResultLower);
                if (result == 0L) continue;
                return CountComparator.convertResult(result);
            }
            return 0;
        }

        protected int compareEqualSizedSections(AddressSection one, AddressSection two) {
            int segCount = one.getSegmentCount();
            int i = 0;
            while (i < segCount) {
                int twoLower;
                AddressSegment segOne = one.getSegment(i);
                AddressSegment segTwo = two.getSegment(i);
                int oneUpper = segOne.getUpperSegmentValue();
                int twoUpper = segTwo.getUpperSegmentValue();
                int oneLower = segOne.getLowerSegmentValue();
                int result = this.compareValues(oneUpper, oneLower, twoUpper, twoLower = segTwo.getLowerSegmentValue());
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }

        @Override
        protected int compareValues(int oneUpper, int oneLower, int twoUpper, int twoLower) {
            int result = oneUpper - oneLower - (twoUpper - twoLower);
            if (result == 0) {
                result = oneLower - twoLower;
            }
            return result;
        }

        @Override
        protected long compareValues(long oneUpper, long oneLower, long twoUpper, long twoLower) {
            long result = oneUpper - oneLower - (twoUpper - twoLower);
            if (result == 0L) {
                result = oneLower - twoLower;
            }
            return result;
        }
    }

    public static class ValueComparator
    extends BaseComparator {
        private final boolean compareHighValue;

        public ValueComparator(boolean compareHighValue) {
            this.compareHighValue = compareHighValue;
        }

        @Override
        protected int compareParts(AddressSection one, AddressSection two) {
            int sizeResult = one.getByteCount() - two.getByteCount();
            if (sizeResult != 0) {
                return sizeResult;
            }
            boolean compareHigh = this.compareHighValue;
            do {
                int segCount = one.getSegmentCount();
                int i = 0;
                while (i < segCount) {
                    int twoValue;
                    AddressSegment segOne = one.getSegment(i);
                    AddressSegment segTwo = two.getSegment(i);
                    int oneValue = compareHigh ? segOne.getUpperSegmentValue() : segOne.getLowerSegmentValue();
                    int result = oneValue - (twoValue = compareHigh ? segTwo.getUpperSegmentValue() : segTwo.getLowerSegmentValue());
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                }
            } while ((compareHigh = !compareHigh) != this.compareHighValue);
            return 0;
        }

        @Override
        protected int compareParts(AddressDivisionSeries one, AddressDivisionSeries two) {
            int sizeResult = one.getBitCount() - two.getBitCount();
            if (sizeResult != 0) {
                return sizeResult;
            }
            boolean compareHigh = this.compareHighValue;
            do {
                long twoValue;
                int twoIndex = 0;
                int oneIndex = 0;
                int twoBitCount = 0;
                int oneBitCount = 0;
                long oneValue = twoValue = (long)0;
                while (oneIndex < one.getDivisionCount() || twoIndex < two.getDivisionCount()) {
                    if (oneBitCount == 0) {
                        AddressDivision oneCombo = one.getDivision(oneIndex++);
                        oneBitCount = oneCombo.getBitCount();
                        long l = oneValue = compareHigh ? oneCombo.getUpperValue() : oneCombo.getLowerValue();
                    }
                    if (twoBitCount == 0) {
                        AddressDivision twoCombo = two.getDivision(twoIndex++);
                        twoBitCount = twoCombo.getBitCount();
                        twoValue = compareHigh ? twoCombo.getUpperValue() : twoCombo.getLowerValue();
                    }
                    long oneResultValue = oneValue;
                    long twoResultValue = twoValue;
                    if (twoBitCount == oneBitCount) {
                        twoBitCount = 0;
                        oneBitCount = 0;
                    } else {
                        int diffBits = twoBitCount - oneBitCount;
                        if (diffBits > 0) {
                            twoResultValue >>= diffBits;
                            twoValue &= -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                            twoBitCount = diffBits;
                            oneBitCount = 0;
                        } else {
                            diffBits = -diffBits;
                            oneResultValue >>= diffBits;
                            oneValue &= -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                            oneBitCount = diffBits;
                            twoBitCount = 0;
                        }
                    }
                    long result = oneResultValue - twoResultValue;
                    if (result == 0L) continue;
                    return ValueComparator.convertResult(result);
                }
            } while ((compareHigh = !compareHigh) != this.compareHighValue);
            return 0;
        }

        @Override
        protected long compareValues(long oneUpper, long oneLower, long twoUpper, long twoLower) {
            long result;
            if (this.compareHighValue) {
                result = oneUpper - twoUpper;
                if (result == 0L) {
                    result = oneLower - twoLower;
                }
            } else {
                result = oneLower - twoLower;
                if (result == 0L) {
                    result = oneUpper - twoUpper;
                }
            }
            return result;
        }

        @Override
        protected int compareValues(int oneUpper, int oneLower, int twoUpper, int twoLower) {
            int result;
            if (this.compareHighValue) {
                result = oneUpper - twoUpper;
                if (result == 0) {
                    result = oneLower - twoLower;
                }
            } else {
                result = oneLower - twoLower;
                if (result == 0) {
                    result = oneUpper - twoUpper;
                }
            }
            return result;
        }
    }
}

