/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionSeries;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class Address
implements AddressSegmentSeries,
Comparable<Address> {
    private static final long serialVersionUID = 3L;
    public static final String HEX_PREFIX = "0x";
    public static final String OCTAL_PREFIX = "0";
    public static final char RANGE_SEPARATOR = '-';
    public static final String RANGE_SEPARATOR_STR = String.valueOf('-');
    public static final char ALTERNATIVE_RANGE_SEPARATOR = '\u203a';
    public static final String ALTERNATIVE_RANGE_SEPARATOR_STR = String.valueOf('\u203a');
    public static final char SEGMENT_WILDCARD = '*';
    public static final String SEGMENT_WILDCARD_STR = String.valueOf('*');
    public static final String ALTERNATIVE_SEGMENT_WILDCARD_STR = "\u00bf";
    public static final char SEGMENT_SQL_WILDCARD = '%';
    public static final String SEGMENT_SQL_WILDCARD_STR = String.valueOf('%');
    public static final char SEGMENT_SQL_SINGLE_WILDCARD = '_';
    public static final String SEGMENT_SQL_SINGLE_WILDCARD_STR = String.valueOf('_');
    public static final AddressComparator addressComparator = new AddressComparator.CountComparator();
    final AddressSection addressSection;
    protected HostIdentifierString fromString;

    public Address(AddressSection section) {
        this.addressSection = section;
    }

    protected static String getMessage(String key) {
        return HostIdentifierException.getMessage(key);
    }

    @Override
    public int getSegmentCount() {
        return this.addressSection.getSegmentCount();
    }

    @Override
    public int getDivisionCount() {
        return this.addressSection.getDivisionCount();
    }

    @Override
    public int getBitCount() {
        return this.addressSection.getBitCount();
    }

    @Override
    public int getByteCount() {
        return this.addressSection.getByteCount();
    }

    public AddressSection getSection() {
        return this.addressSection;
    }

    @Override
    public AddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public AddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    @Override
    public AddressDivision getDivision(int index) {
        return this.addressSection.getDivision(index);
    }

    @Override
    public AddressSegment getSegment(int index) {
        return this.addressSection.getSegment(index);
    }

    @Override
    public AddressSegment[] getSegments() {
        return this.addressSection.getSegments();
    }

    @Override
    public void getSegments(AddressSegment[] segs) {
        this.addressSection.getSegments(segs);
    }

    @Override
    public void getSegments(int start, int end, AddressSegment[] segs, int index) {
        this.addressSection.getSegments(start, end, segs, index);
    }

    public abstract int getMaxSegmentValue();

    public abstract Iterable<? extends Address> getIterable();

    public abstract Iterator<? extends Address> iterator();

    @Override
    public Iterator<? extends AddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    @Override
    public abstract Address getLower();

    @Override
    public abstract Address getUpper();

    @Override
    public boolean isMultipleByPrefix() {
        return this.addressSection.isMultipleByPrefix();
    }

    @Override
    public boolean isMultiple() {
        return this.addressSection.isMultiple();
    }

    @Override
    public boolean isPrefixed() {
        return this.addressSection.isPrefixed();
    }

    @Override
    public Integer getPrefixLength() {
        return this.addressSection.getPrefixLength();
    }

    @Override
    public int getMinPrefix() {
        return this.getSection().getMinPrefix();
    }

    @Override
    public Integer getEquivalentPrefix() {
        return this.getSection().getEquivalentPrefix();
    }

    public abstract boolean isMulticast();

    @Override
    public BigInteger getCount() {
        return this.addressSection.getCount();
    }

    @Override
    public int isMore(AddressDivisionSeries other) {
        return this.addressSection.isMore(other);
    }

    @Override
    public byte[] getBytes() {
        return this.addressSection.getBytes();
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        return this.addressSection.getBytes(bytes);
    }

    @Override
    public byte[] getUpperBytes() {
        return this.addressSection.getUpperBytes();
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        return this.addressSection.getUpperBytes(bytes);
    }

    @Override
    public boolean isZero() {
        return this.addressSection.isZero();
    }

    @Override
    public boolean isFullRange() {
        return this.addressSection.isFullRange();
    }

    public abstract boolean isLocal();

    public int hashCode() {
        return this.addressSection.hashCode();
    }

    @Override
    public int compareTo(Address other) {
        if (this == other) {
            return 0;
        }
        return addressComparator.compare(this, other);
    }

    protected abstract boolean isFromSameString(HostIdentifierString var1);

    public boolean isSameAddress(Address other) {
        return other == this || this.getSection().equals(other.getSection());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Address) {
            Address other = (Address)o;
            if (this.isFromSameString(other.fromString)) {
                return true;
            }
            return this.isSameAddress(other);
        }
        return false;
    }

    public abstract boolean contains(Address var1);

    @Override
    public boolean isRangeEquivalentToPrefix() {
        return this.addressSection.isRangeEquivalentToPrefix();
    }

    public HostIdentifierString toAddressString() {
        return this.fromString;
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        return this.addressSection.toHexString(with0xPrefix);
    }

    @Override
    public String toNormalizedString() {
        return this.addressSection.toNormalizedString();
    }

    @Override
    public String toCanonicalString() {
        return this.addressSection.toCanonicalString();
    }

    @Override
    public String toCompressedString() {
        return this.addressSection.toCompressedString();
    }

    public String toString() {
        return this.toNormalizedString();
    }

    @Override
    public abstract Address reverseSegments();

    @Override
    public abstract Address reverseBits(boolean var1);

    @Override
    public abstract Address reverseBytes();

    @Override
    public abstract Address reverseBytesPerSegment();

    @Override
    public abstract Address removePrefixLength();

    @Override
    public abstract Address adjustPrefixBySegment(boolean var1);

    @Override
    public abstract Address adjustPrefixLength(int var1);

    @Override
    public abstract Address setPrefixLength(int var1);

    @Override
    public abstract Address applyPrefixLength(int var1);

    public static interface SegmentValueProvider {
        public int getValue(int var1, int var2);
    }
}

