/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.ex;

import com.paterva.maltego.importexport.wizard.ItemSelectionController;
import com.paterva.maltego.importexport.wizard.ex.ExportFileController;
import com.paterva.maltego.importexport.wizard.ex.ExportProgressController;
import com.paterva.maltego.importexport.wizard.ex.MainSelectionController;
import com.paterva.maltego.util.ui.dialog.PasswordEditController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Component;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

final class ExportWizardIterator<Data>
implements WizardDescriptor.Iterator<Data> {
    private WizardDescriptor _wd;
    private WizardDescriptor.Panel _panelMainSelection;
    private WizardDescriptor.Panel _panelItemSelection;
    private WizardDescriptor.Panel _panelFile;
    private WizardDescriptor.Panel _panelPassword;
    private WizardDescriptor.Panel _panelProgress;
    private ArrayList<WizardDescriptor.Panel> _panelsVisible;
    private int _index = 0;

    ExportWizardIterator() {
    }

    public void initialize(WizardDescriptor wd) {
        this._wd = wd;
        this.createPanels();
    }

    private void createPanels() {
        this._panelMainSelection = new MainSelectionController();
        this._panelItemSelection = new ItemSelectionController();
        this._panelFile = new ExportFileController();
        this._panelPassword = new PasswordEditController(true);
        this._panelProgress = new ExportProgressController();
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this._panelMainSelection, this._panelItemSelection, this._panelFile, this._panelPassword, this._panelProgress};
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        this.updateVisiblePanels();
    }

    public WizardDescriptor.Panel<Data> current() {
        return this._panelsVisible.get(this._index);
    }

    public String name() {
        return "Export";
    }

    public boolean hasNext() {
        return this._index < this._panelsVisible.size() - 1;
    }

    public boolean hasPrevious() {
        return this._index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this._index;
        this.updateVisiblePanels();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this._index;
        this.updateVisiblePanels();
    }

    private void updateVisiblePanels() {
        boolean exportEverything = (Boolean)this._wd.getProperty("selectEverything");
        boolean encrypt = (Boolean)this._wd.getProperty("encrypt");
        this._wd.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        this._panelsVisible = new ArrayList();
        this._panelsVisible.add(this._panelMainSelection);
        if (!exportEverything) {
            this._panelsVisible.add(this._panelItemSelection);
        }
        this._panelsVisible.add(this._panelFile);
        if (encrypt) {
            this._panelsVisible.add(this._panelPassword);
        }
        this._panelsVisible.add(this._panelProgress);
        this.updateContentPane();
    }

    private void updateContentPane() {
        String[] steps = this.getContentData();
        for (int i = 0; i < this._panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this._panelsVisible.get(i);
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private String[] getContentData() {
        ArrayList<String> steps = new ArrayList<String>();
        for (int i = 0; i < this._panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this._panelsVisible.get(i);
            steps.add(panel.getComponent().getName());
            if (i < this._index || panel != this._panelMainSelection && panel != this._panelFile) continue;
            steps.add("...");
            break;
        }
        return steps.toArray(new String[steps.size()]);
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }
}

