/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.map;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.serializers.map.PartMapTranslator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.IPAddress;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.PhoneNumber;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.types.Blob;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PartMapWriter
extends PartMapTranslator {
    private static final Logger LOG = Logger.getLogger(PartMapWriter.class.getName());

    public <ID extends Guid, Part extends MaltegoPart<ID>> List<Map<String, Object>> toMaps(Collection<Part> parts, boolean addDefaults) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(parts.size());
        for (MaltegoPart part : parts) {
            list.add(this.toMap(part, addDefaults));
        }
        return list;
    }

    public Map<String, Object> toMap(MaltegoPart part, boolean addDefaults) {
        MaltegoEntity entity;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(13);
        map.put("id", part.getID().toString());
        map.put("type", this.getTypeName(part));
        map.put("valueStr", part.getValueString());
        map.put("displayValueStr", part.getDisplayString());
        if (part instanceof MaltegoEntity) {
            entity = (MaltegoEntity)part;
            this.putIfNotNullOrEmpty(map, "imageValue", this.translateValue(entity.getCachedImageKey().orElse(null)), addDefaults);
        }
        map.put("hasAttachments", part.hasAttachments());
        map.put("labelReadOnly", part.isLabelReadonly());
        if (addDefaults || part.getBookmark() >= 0) {
            map.put("bookmark", part.getBookmarkValue());
        }
        if (addDefaults || !StringUtilities.isNullOrEmpty((String)part.getNotes()) || part.isShowNotes()) {
            map.put("notes", this.notesToMap(part));
        }
        if (part instanceof MaltegoEntity) {
            entity = (MaltegoEntity)part;
            if (addDefaults || entity.getWeight() > 0) {
                map.put("weight", entity.getWeightValue().orElse(null));
            }
        }
        if (part instanceof MaltegoLink) {
            MaltegoLink link = (MaltegoLink)part;
            if (addDefaults || Boolean.TRUE.equals(link.isReversed())) {
                map.put("reversed", link.isReversed());
            }
        }
        if (part instanceof MaltegoEntity) {
            entity = (MaltegoEntity)part;
            this.putIfNotNullOrEmpty(map, "valuePropName", part.getValuePropertyName(), addDefaults);
            this.putIfNotNullOrEmpty(map, "displayPropName", part.getDisplayValueExpression().orElse(null), addDefaults);
            this.putIfNotNullOrEmpty(map, "imagePropName", entity.getNonBlankImageExpression().orElse(null), addDefaults);
            this.putOverlaysToMap(entity, map);
        }
        this.putIfNotNullOrEmpty(map, "properties", this.propertiesToMap(part, addDefaults), addDefaults);
        map.put("propText", this.propertiesToText(part, addDefaults, propertyDescriptor -> propertyDescriptor.isHidden()));
        map.put("hiddenPropText", this.propertiesToText(part, addDefaults, propertyDescriptor -> !propertyDescriptor.isHidden()));
        this.putIfNotNullOrEmpty(map, "displayInfo", this.displayInfoToArray(part), addDefaults);
        LOG.log(Level.FINE, "Part:\n{0}\nMap:\n{1}", new Object[]{part, map});
        return map;
    }

    void putOverlaysToMap(MaltegoEntity entity, Map<String, Object> map) {
        OverlayDescriptorSet overlaySet = entity.getOverlaySet();
        if (overlaySet == null || overlaySet.isEmpty()) {
            return;
        }
        HashMap overlayMap = new HashMap();
        map.put("overlays", overlayMap);
        for (OverlayDescriptor overlay : overlaySet) {
            String position = overlay.getPosition().code;
            String type = overlay.getType().type;
            String key = position + type;
            HashMap<String, String> valueMap = new HashMap<String, String>();
            overlayMap.put(key, valueMap);
            valueMap.put("propertyName", overlay.getPropertyName());
            valueMap.put("position", position);
            valueMap.put("type", type);
        }
    }

    private String getTypeName(MaltegoPart part) {
        if (part instanceof MaltegoEntity) {
            return part.getTypeName();
        }
        return this.getLinkMappings().linkTypeNameToShortName(part.getTypeName());
    }

    private void putIfNotNullOrEmpty(Map<String, Object> map, String key, Object value, boolean addDefaults) {
        if (addDefaults || value != null && !StringUtilities.isNullString((Object)value)) {
            map.put(key, value);
        }
    }

    private Map<String, Object> notesToMap(MaltegoPart part) {
        LinkedHashMap<String, Object> notesMap = new LinkedHashMap<String, Object>(2);
        notesMap.put("value", part.getNotes());
        notesMap.put("show", part.isShowNotesValue());
        return notesMap;
    }

    private Map[] displayInfoToArray(MaltegoPart part) {
        DisplayInformationCollection displayInfos = part.getDisplayInformation();
        ArrayList displayInfoList = null;
        if (displayInfos != null && !displayInfos.isEmpty()) {
            displayInfoList = new ArrayList();
            for (DisplayInformation di : displayInfos) {
                String name = di.getName();
                String value = di.getValue();
                if (StringUtilities.isNullOrEmpty((String)name) || StringUtilities.isNullOrEmpty((String)value)) continue;
                HashMap<String, String> diMap = new HashMap<String, String>();
                diMap.put("name", name);
                diMap.put("value", value);
                displayInfoList.add(diMap);
            }
        }
        LOG.log(Level.FINE, "Display Info: {0}", displayInfoList);
        return displayInfoList == null ? null : displayInfoList.toArray(new Map[displayInfoList.size()]);
    }

    private Map<String, Object> displayInfoToMap(MaltegoPart part) {
        DisplayInformationCollection displayInfos = part.getDisplayInformation();
        LinkedHashMap displayInfoMap = null;
        if (displayInfos != null && !displayInfos.isEmpty()) {
            LinkedHashMap<String, ArrayList<String>> arrayListMap = new LinkedHashMap<String, ArrayList<String>>();
            for (DisplayInformation di : displayInfos) {
                String name = di.getName();
                ArrayList<String> values = (ArrayList<String>)arrayListMap.get(name);
                if (values == null) {
                    values = new ArrayList<String>(1);
                    arrayListMap.put(name, values);
                }
                values.add(di.getValue());
            }
            displayInfoMap = new LinkedHashMap();
            for (Map.Entry entry : arrayListMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    value = ((List)value).toArray();
                }
                displayInfoMap.put(key, value);
            }
        }
        return displayInfoMap;
    }

    private Map<String, Object> propertiesToMap(MaltegoPart part, boolean addDefaults) {
        LinkedHashMap<String, Map<String, Object>> propertiesMap = null;
        PropertyDescriptorCollection properties = part.getProperties();
        if (properties != null && !properties.isEmpty()) {
            propertiesMap = new LinkedHashMap<String, Map<String, Object>>(properties.size());
            for (PropertyDescriptor property : properties) {
                if (!addDefaults && this.isLinkPropertyDefaultValue(part, property)) continue;
                propertiesMap.put(this.getPropertyName(part, property), this.propertyToMap(part, property, addDefaults));
            }
        }
        return propertiesMap;
    }

    private String[] propertiesToText(MaltegoPart part, boolean addDefaults, Predicate<PropertyDescriptor> ignoreFilter) {
        LinkedList<String> textList = new LinkedList<String>();
        PropertyDescriptorCollection properties = part.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyDescriptor property : properties) {
                Object value;
                if (ignoreFilter.test(property) || !addDefaults && this.isLinkPropertyDefaultValue(part, property) || (value = part.getValue(property)) == null) continue;
                textList.add(value.toString());
            }
        }
        return textList.toArray(new String[textList.size()]);
    }

    private String getPropertyName(MaltegoPart part, PropertyDescriptor property) {
        if (part instanceof MaltegoEntity) {
            return property.getName();
        }
        return this.getLinkMappings().linkPropNameToShortName(property.getName());
    }

    private Map<String, Object> propertyToMap(MaltegoPart part, PropertyDescriptor property, boolean addDefaults) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        TypeDescriptor td = TypeRegistry.getDefault().getType(property.getType());
        if (addDefaults || !property.getName().equals(property.getDisplayName())) {
            propertyMap.put("displayName", property.getDisplayName());
        }
        propertyMap.put("value", this.translateValue(td.getType(), part.getValue(property)));
        propertyMap.put("type", td.getTypeName());
        if (addDefaults || property.isHidden()) {
            propertyMap.put("hidden", property.isHidden());
        }
        if (addDefaults || property.isReadonly()) {
            propertyMap.put("readonly", property.isReadonly());
        }
        if (addDefaults || !property.isNullable()) {
            propertyMap.put("nullable", property.isNullable());
        }
        return propertyMap;
    }

    private boolean isLinkPropertyDefaultValue(MaltegoPart part, PropertyDescriptor property) {
        if (part instanceof MaltegoLink) {
            String name = property.getName();
            Object value = part.getValue(property);
            if ("maltego.link.color".equals(name)) {
                return value == null;
            }
            if ("maltego.link.label".equals(name) || "maltego.link.manual.description".equals(name) || "maltego.link.manual.type".equals(name)) {
                return StringUtilities.isNullString((Object)value);
            }
            if ("maltego.link.show-label".equals(name)) {
                return value == null || Integer.valueOf(0).equals(value);
            }
            if ("maltego.link.style".equals(name) || "maltego.link.thickness".equals(name)) {
                return value == null || Integer.valueOf(-1).equals(value);
            }
            if ("maltego.link.transform.version".equals(name)) {
                return value == null || "1.0.0".equals(value);
            }
        }
        return false;
    }

    private Object translateValue(Object value) {
        if (value != null) {
            value = this.translateValue(value.getClass(), value);
        }
        return value;
    }

    public Object translateValue(Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.toString((Byte)value);
        }
        if (Character.TYPE.equals(type)) {
            return Character.toString(((Character)value).charValue());
        }
        if (DateTime.class.equals((Object)type)) {
            return ((DateTime)value).getDate().getTime();
        }
        if (TimeSpan.class.equals((Object)type)) {
            return ((TimeSpan)value).getMilliseconds();
        }
        if (FastURL.class.equals((Object)type)) {
            return value.toString();
        }
        if (InternalFile.class.equals((Object)type)) {
            return ((InternalFile)value).fileStoreIndex;
        }
        if (Color.class.equals((Object)type)) {
            return ColorUtilities.encode((Color)((Color)value));
        }
        if (Attachments.class.equals((Object)type)) {
            return this.toMap((Attachments)value);
        }
        if (File.class.equals((Object)type)) {
            return value.toString();
        }
        if (DateRange.class.equals((Object)type)) {
            return value.toString();
        }
        if (Image.class.isAssignableFrom(type)) {
            return new Blob(ImageUtils.imageToBytes((Image)((Image)value), (String)"png"));
        }
        if (IPAddress.class.equals((Object)type)) {
            IPAddress address = (IPAddress)value;
            return address.toStringIPv6Uncompressed() + "-" + address.getCreationString();
        }
        if (PhoneNumber.class.equals((Object)type)) {
            PhoneNumber phonenumber = (PhoneNumber)value;
            return phonenumber.toStringInternational() + "@" + phonenumber.getCreationString();
        }
        return value;
    }

    private Map<String, Object> toMap(Attachments attachments) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Attachment primaryImage = attachments.getPrimaryImage();
        if (primaryImage != null) {
            int primaryID = primaryImage.getId();
            map.put("primary", primaryID);
        }
        HashMap<String, String> innerMap = new HashMap<String, String>();
        for (Attachment attachment : attachments) {
            innerMap.put(Integer.toString(attachment.getId()), attachment.getSource().toString());
        }
        map.put("atts", innerMap);
        return map;
    }

    public void convertAttachmentIDsToPaths(Map<String, Object> artifact, Map<Integer, String> idToPaths) {
        Map<String, Object> attsMap;
        int attsCount = 0;
        Map<String, Map<String, Object>> attachmentPropertyMaps = this.getAttachmentPropertyMaps(artifact);
        for (Map.Entry<String, Map<String, Object>> entry : attachmentPropertyMaps.entrySet()) {
            Map<String, Object> propMap = entry.getValue();
            attsCount += this.convertAttachmentMapIDsToPaths(propMap, idToPaths);
        }
        artifact.put("hasAttachments", attsCount != 0);
        Object imgPropName = artifact.get("imagePropName");
        if (imgPropName instanceof String && (attsMap = attachmentPropertyMaps.get((String)imgPropName)) != null) {
            artifact.put("imageValue", attsMap);
        }
    }

    private int convertAttachmentMapIDsToPaths(Map<String, Object> map, Map<Integer, String> idToPaths) {
        Object primaryObj;
        int attsCount = 0;
        Object attsObj = map.get("atts");
        if (attsObj instanceof Map) {
            Map oldAttsMap = (Map)attsObj;
            HashMap<String, String> newAttsMap = new HashMap<String, String>();
            for (Map.Entry entry : oldAttsMap.entrySet()) {
                String id = (String)entry.getKey();
                String source = (String)entry.getValue();
                String path = idToPaths.get(Integer.valueOf(id));
                if (path == null) {
                    LOG.log(Level.WARNING, "Path not found for attachment ID {0}, trying to match by source: {0}", new Object[]{id, source});
                    path = this.findPathForSource(idToPaths, source);
                    if (path != null) {
                        LOG.log(Level.WARNING, "Path found: {0}", path);
                    }
                }
                if (path != null) {
                    LOG.log(Level.FINE, "Replacing attachment id with path: {0}->{1}", new Object[]{id, path});
                    newAttsMap.put(this.escapeDots(path), source);
                    continue;
                }
                LOG.log(Level.WARNING, "Path not found for attachment ID: {0}", id);
            }
            map.put("atts", newAttsMap);
            attsCount = newAttsMap.size();
        }
        if ((primaryObj = map.get("primary")) instanceof Integer) {
            Integer id = (Integer)primaryObj;
            String path = idToPaths.get(id);
            if (path != null) {
                LOG.log(Level.FINE, "Replacing primary id with path: {0}->{1}", new Object[]{id, path});
            } else {
                LOG.log(Level.WARNING, "Path not found for attachment ID: {0}", id);
            }
            map.put("primary", path);
        }
        return attsCount;
    }

    public void convertAttachmentPathsToIDs(Map<String, Object> artifact, Map<Integer, String> idToPaths) {
        Map<String, Object> attsMap;
        int attsCount = 0;
        Map<String, Map<String, Object>> attachmentPropertyMaps = this.getAttachmentPropertyMaps(artifact);
        for (Map.Entry<String, Map<String, Object>> entry : attachmentPropertyMaps.entrySet()) {
            Map<String, Object> propMap = entry.getValue();
            attsCount += this.convertAttachmentMapPathsToIDs(propMap, idToPaths);
        }
        artifact.put("hasAttachments", attsCount != 0);
        Object imgPropName = artifact.get("imagePropName");
        if (imgPropName instanceof String && (attsMap = attachmentPropertyMaps.get(this.escapeDots((String)imgPropName))) != null) {
            artifact.put("imageValue", attsMap);
        }
    }

    public int convertAttachmentMapPathsToIDs(Map<String, Object> map, Map<Integer, String> idToPaths) {
        Object primaryObj;
        int attsCount = 0;
        Object attsObj = map.get("atts");
        HashMap<String, Integer> replaced = new HashMap<String, Integer>();
        if (attsObj instanceof Map) {
            Map oldAttsMap = (Map)attsObj;
            HashMap<String, String> newAttsMap = new HashMap<String, String>();
            for (Map.Entry entry : oldAttsMap.entrySet()) {
                String path = this.unescapeDots((String)entry.getKey());
                String source = (String)entry.getValue();
                Integer id = this.getIdForPath(idToPaths, path);
                if (id == null) {
                    LOG.log(Level.WARNING, "ID not found for attachment {0}, trying to match by source: {0}", new Object[]{path, source});
                    id = this.findIDForSource(idToPaths, source);
                    if (id != null) {
                        LOG.log(Level.WARNING, "ID found: {0}", id);
                    }
                }
                if (id != null) {
                    LOG.log(Level.FINE, "Replacing attachment path with id: {0}->{1}", new Object[]{path, id});
                    replaced.put(path, id);
                    newAttsMap.put(Integer.toString(id), source);
                    continue;
                }
                LOG.log(Level.WARNING, "ID not found for attachment: {0}", path);
            }
            map.put("atts", newAttsMap);
            attsCount = newAttsMap.size();
        }
        if ((primaryObj = map.get("primary")) != null) {
            String path = primaryObj.toString();
            Integer id = (Integer)replaced.get(path);
            if (id == null) {
                id = this.getIdForPath(idToPaths, path);
            }
            if (id != null) {
                LOG.log(Level.FINE, "Replacing primary path with id: {0}->{1}", new Object[]{path, id});
            } else {
                LOG.log(Level.WARNING, "ID not found for attachment: {0}", path);
            }
            map.put("primary", id);
        }
        return attsCount;
    }

    private Map<String, Map<String, Object>> getAttachmentPropertyMaps(Map<String, Object> artifact) {
        HashMap<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>();
        Object propsObj = artifact.get("properties");
        if (propsObj instanceof Map) {
            Map propsMap = (Map)propsObj;
            for (Map.Entry entry : propsMap.entrySet()) {
                Map propValueMap;
                Map<String, Object> attsValueMap;
                Object propValue = entry.getValue();
                if (!(propValue instanceof Map) || (attsValueMap = this.getAttachmentsValueMap(propValueMap = (Map)propValue)) == null) continue;
                maps.put((String)entry.getKey(), attsValueMap);
            }
        }
        return maps;
    }

    private Map<String, Object> getAttachmentsValueMap(Map<String, Object> propValueMap) {
        Object valueObj;
        if ("attachments".equals(propValueMap.get("type")) && (valueObj = propValueMap.get("value")) instanceof Map) {
            Map valueMap = (Map)valueObj;
            return valueMap;
        }
        return null;
    }

    private Integer getIdForPath(Map<Integer, String> idToPaths, String path) {
        for (Map.Entry<Integer, String> entry : idToPaths.entrySet()) {
            Integer id = entry.getKey();
            String pathValue = entry.getValue();
            if (!path.equals(pathValue)) continue;
            return id;
        }
        return null;
    }

    private String findPathForSource(Map<Integer, String> idToPaths, String source) {
        for (Map.Entry<Integer, String> entry : idToPaths.entrySet()) {
            String path = entry.getValue();
            path = new File(path).getName();
            if (!source.toLowerCase().contains(path.toLowerCase())) continue;
            return path;
        }
        return null;
    }

    private Integer findIDForSource(Map<Integer, String> idToPaths, String source) {
        for (Map.Entry<Integer, String> entry : idToPaths.entrySet()) {
            Integer id = entry.getKey();
            String path = entry.getValue();
            path = new File(path).getName();
            if (!source.toLowerCase().contains(path.toLowerCase())) continue;
            return id;
        }
        return null;
    }
}

