/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.Vector;

public class PlanetModel {
    public static final PlanetModel SPHERE = new PlanetModel(1.0, 1.0);
    public static final double WGS84_MEAN = 6371009.0;
    public static final double WGS84_POLAR = 6356752.314245;
    public static final double WGS84_EQUATORIAL = 6378137.0;
    public static final PlanetModel WGS84 = new PlanetModel(1.0011188180710464, 0.9977622562211103);
    public final double ab;
    public final double c;
    public final double inverseAb;
    public final double inverseC;
    public final double inverseAbSquared;
    public final double inverseCSquared;
    public final double flattening;
    public final double squareRatio;
    public final GeoPoint NORTH_POLE;
    public final GeoPoint SOUTH_POLE;
    public final GeoPoint MIN_X_POLE;
    public final GeoPoint MAX_X_POLE;
    public final GeoPoint MIN_Y_POLE;
    public final GeoPoint MAX_Y_POLE;

    public PlanetModel(double ab, double c) {
        this.ab = ab;
        this.c = c;
        this.inverseAb = 1.0 / ab;
        this.inverseC = 1.0 / c;
        this.flattening = (ab - c) * this.inverseAb;
        this.squareRatio = (ab * ab - c * c) / (c * c);
        this.inverseAbSquared = this.inverseAb * this.inverseAb;
        this.inverseCSquared = this.inverseC * this.inverseC;
        this.NORTH_POLE = new GeoPoint(c, 0.0, 0.0, 1.0, 1.5707963267948966, 0.0);
        this.SOUTH_POLE = new GeoPoint(c, 0.0, 0.0, -1.0, -1.5707963267948966, 0.0);
        this.MIN_X_POLE = new GeoPoint(ab, -1.0, 0.0, 0.0, 0.0, -Math.PI);
        this.MAX_X_POLE = new GeoPoint(ab, 1.0, 0.0, 0.0, 0.0, 0.0);
        this.MIN_Y_POLE = new GeoPoint(ab, 0.0, -1.0, 0.0, 0.0, -1.5707963267948966);
        this.MAX_Y_POLE = new GeoPoint(ab, 0.0, 1.0, 0.0, 0.0, 1.5707963267948966);
    }

    public double getMinimumMagnitude() {
        return Math.min(this.ab, this.c);
    }

    public double getMaximumMagnitude() {
        return Math.max(this.ab, this.c);
    }

    public double getMinimumXValue() {
        return -this.ab;
    }

    public double getMaximumXValue() {
        return this.ab;
    }

    public double getMinimumYValue() {
        return -this.ab;
    }

    public double getMaximumYValue() {
        return this.ab;
    }

    public double getMinimumZValue() {
        return -this.c;
    }

    public double getMaximumZValue() {
        return this.c;
    }

    public boolean pointOnSurface(Vector v) {
        return this.pointOnSurface(v.x, v.y, v.z);
    }

    public boolean pointOnSurface(double x, double y, double z) {
        return Math.abs(x * x * this.inverseAb * this.inverseAb + y * y * this.inverseAb * this.inverseAb + z * z * this.inverseC * this.inverseC - 1.0) < 1.0E-12;
    }

    public boolean pointOutside(Vector v) {
        return this.pointOutside(v.x, v.y, v.z);
    }

    public boolean pointOutside(double x, double y, double z) {
        return (x * x + y * y) * this.inverseAb * this.inverseAb + z * z * this.inverseC * this.inverseC - 1.0 > 1.0E-12;
    }

    public double surfaceDistance(GeoPoint p1, GeoPoint p2) {
        double lambdaP;
        double cos2SigmaM;
        double cosLambda;
        double cosSigma;
        double sigma;
        double sinSigma;
        double sinLambda;
        double sinAlpha;
        double cos2Alpha;
        double c;
        double latA = p1.getLatitude();
        double lonA = p1.getLongitude();
        double latB = p2.getLatitude();
        double lonB = p2.getLongitude();
        double L = lonB - lonA;
        double oF = 1.0 - this.flattening;
        double U1 = Math.atan(oF * Math.tan(latA));
        double U2 = Math.atan(oF * Math.tan(latB));
        double sU1 = Math.sin(U1);
        double cU1 = Math.cos(U1);
        double sU2 = Math.sin(U2);
        double cU2 = Math.cos(U2);
        double lambda = L;
        double iters = 100.0;
        do {
            if (!(Math.abs(sinSigma = Math.sqrt(cU2 * (sinLambda = Math.sin(lambda)) * (cU2 * sinLambda) + (cU1 * sU2 - sU1 * cU2 * (cosLambda = Math.cos(lambda))) * (cU1 * sU2 - sU1 * cU2 * cosLambda))) < 1.0E-12)) continue;
            return 0.0;
        } while (!(Math.abs((lambda = L + (1.0 - (c = this.flattening * 0.625 * (cos2Alpha = 1.0 - (sinAlpha = cU1 * cU2 * sinLambda / sinSigma) * sinAlpha) * (4.0 + this.flattening * (4.0 - 3.0 * cos2Alpha)))) * this.flattening * sinAlpha * ((sigma = Math.atan2(sinSigma, cosSigma = sU1 * sU2 + cU1 * cU2 * cosLambda)) + c * sinSigma * ((cos2SigmaM = cosSigma - 2.0 * sU1 * sU2 / cos2Alpha) + c * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) < 1.0E-12) && (iters -= 1.0) > 0.0);
        if (iters == 0.0) {
            return 0.0;
        }
        double uSq = cos2Alpha * this.squareRatio;
        double A = 1.0 + uSq * 6.103515625E-5 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq * 9.765625E-4 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B * 0.25 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B * 0.16666666666666666 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return this.c * A * (sigma - deltaSigma);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlanetModel)) {
            return false;
        }
        PlanetModel other = (PlanetModel)o;
        return this.ab == other.ab && this.c == other.c;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.ab);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        if (this.equals(SPHERE)) {
            return "PlanetModel.SPHERE";
        }
        if (this.equals(WGS84)) {
            return "PlanetModel.WGS84";
        }
        return "PlanetModel(ab=" + this.ab + " c=" + this.c + ")";
    }
}

