/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora;

import java.lang.reflect.Array;
import org.apache.commons.lang3.ArrayUtils;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Class getDeepType(Object input) {
        Class<?> type = input.getClass();
        if (!type.isArray()) {
            return type;
        }
        Class<?> innerType = type.getComponentType();
        if (Object.class == innerType) {
            Object[] arr = (Object[])input;
            innerType = null;
            for (Object innerObj : arr) {
                if (innerObj == null) continue;
                if (innerType == null) {
                    innerType = innerObj.getClass();
                    continue;
                }
                if (innerType.equals(innerObj.getClass())) continue;
                return Object.class;
            }
        }
        return innerType;
    }

    public static <T> T[] toObject(T ... args) {
        if (TypeUtils.isPrimitive2DArray(args.getClass())) {
            if (Array.getLength(args) > 0) {
                return TypeUtils.toObjectArray(Array.get(args, 0));
            }
            throw new IllegalArgumentException("Not supported: " + args.getClass().getName());
        }
        return args;
    }

    private static boolean isPrimitive2DArray(Class type) {
        if (type.isArray() && type.getComponentType().isArray()) {
            return type.getComponentType().getComponentType().isPrimitive();
        }
        return false;
    }

    public static void arrayToString(Object array) {
        StringBuilder buffer = new StringBuilder("[");
        for (int i = 0; i < Array.getLength(array); ++i) {
            buffer.append(Array.get(array, i));
            buffer.append(",");
        }
        buffer.append("]");
        System.out.println(buffer);
    }

    private static <T> T[] toObjectArray(Object array) {
        if (array instanceof boolean[]) {
            return ArrayUtils.toObject((boolean[])((boolean[])array));
        }
        if (array instanceof byte[]) {
            return ArrayUtils.toObject((byte[])((byte[])array));
        }
        if (array instanceof char[]) {
            return ArrayUtils.toObject((char[])((char[])array));
        }
        if (array instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])array));
        }
        if (array instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])array));
        }
        if (array instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])array));
        }
        if (array instanceof short[]) {
            return ArrayUtils.toObject((short[])((short[])array));
        }
        throw new IllegalArgumentException("Unsupported type: " + array.getClass().getName());
    }
}

