/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.DiscoveryEntityMerger;
import com.paterva.maltego.archive.mtz.discover.DiscoveryMergingRules;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryItems;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.imex.EntityImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EntitySpecDiscoveryProvider
extends MtzDiscoveryProvider<MtzEntitySpecs> {
    public MtzEntitySpecs read(DiscoveryContext ctx, MaltegoArchiveReader reader) throws IOException {
        EntityImporter importer = new EntityImporter();
        return new MtzEntitySpecs(importer.readEntities(reader), ctx);
    }

    public void apply(MtzEntitySpecs specs) {
        DiscoveryMergingRules.EntityRule rule = specs.getContext().getMergingRules().getEntityRule();
        EntityImporter importer = new EntityImporter();
        importer.applyEntities(specs.getEntitySpecs(), rule);
    }

    public MtzEntitySpecs getNewAndMerged(MtzEntitySpecs items) {
        List<MaltegoEntitySpec> specs = items.getEntitySpecs();
        DiscoveryMergingRules.EntityRule rule = items.getContext().getMergingRules().getEntityRule();
        EntityRegistry registry = EntityRegistry.getDefault();
        ArrayList<MaltegoEntitySpec> newSpecs = new ArrayList<MaltegoEntitySpec>();
        for (MaltegoEntitySpec newSpec : specs) {
            MaltegoEntitySpec newEntity = DiscoveryEntityMerger.getNewEntity((EntityRegistry)registry, (DiscoveryMergingRules.EntityRule)rule, (MaltegoEntitySpec)newSpec);
            if (newEntity == null) continue;
            newSpecs.add(newSpec);
        }
        return new MtzEntitySpecs(newSpecs, items.getContext());
    }

    public class MtzEntitySpecs
    extends MtzDiscoveryItems {
        private final List<MaltegoEntitySpec> _entitySpecs;

        public MtzEntitySpecs(List<MaltegoEntitySpec> entitySpecs, DiscoveryContext context) {
            super((MtzDiscoveryProvider)EntitySpecDiscoveryProvider.this, context);
            this._entitySpecs = entitySpecs;
        }

        public String getDescription() {
            return "Entities";
        }

        public List<MaltegoEntitySpec> getEntitySpecs() {
            return this._entitySpecs;
        }

        public int size() {
            return this._entitySpecs.size();
        }
    }
}

