/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.data;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.data.EntitySpecCookie;
import com.paterva.maltego.entity.manager.palette.FavouriteEntities;
import com.paterva.maltego.util.ColorUtilities;
import java.awt.Color;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;

public class EntityDataNode
extends DataNode {
    public EntityDataNode(DataObject obj, Lookup lookup) {
        super(obj, Children.LEAF, lookup);
    }

    public String getDisplayName() {
        StackTraceElement ste;
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        if (stes != null && stes.length >= 7 && (ste = stes[6]).getClassName().equals("org.netbeans.modules.palette.Utils$RemoveItemAction") && ste.getMethodName().equals("actionPerformed")) {
            return this.getHtmlDisplayName();
        }
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        String nameFg = ColorUtilities.encode((Color)laf.getColor("palette-item-name-fg"));
        String descriptionFg = ColorUtilities.encode((Color)laf.getColor("palette-item-description-fg"));
        int size = new JLabel().getFont().getSize();
        String label = "<html><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"font-size:" + ((double)size - 2.5) + "px;\">&nbsp;<font color=\"" + nameFg + "\"><b>" + this.getHtmlDisplayName() + "</b></font></td></tr><tr><td style=\"font-size:" + ((double)size - 2.5) + "px; color:" + descriptionFg + "\">&nbsp;" + this.getShortDescription() + "</font></td></tr></table></html>";
        return label;
    }

    public String getHtmlDisplayName() {
        return this.getEntitySpec().map(spec -> spec.getDisplayName()).orElse("Missing Entity");
    }

    public String getShortDescription() {
        return this.getEntitySpec().map(spec -> spec.getDescription()).orElse("");
    }

    public String getName() {
        return this.getEntitySpec().map(spec -> spec.getTypeName()).orElse("entity.missing");
    }

    public Image getIcon(int i) {
        int size = 48;
        if (i == 1 || i == 3) {
            size = 16;
        } else if (i == 2 || i == 4) {
            size = 32;
        }
        int finalSize = size;
        Image icon = this.getEntitySpec().map(spec -> spec.getIcon(finalSize)).orElse(null);
        return icon != null ? icon : super.getIcon(i);
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> types) {
        super.createPasteTypes(transferable, types);
    }

    public PasteType getDropType(Transferable transferable, int arg1, int arg2) {
        return super.getDropType(transferable, arg1, arg2);
    }

    public boolean canCut() {
        return this.isFavouritesEntityNode() ? false : super.canCut();
    }

    public boolean canCopy() {
        return this.isFavouritesEntityNode() ? false : super.canCopy();
    }

    public boolean canDestroy() {
        return this.isFavouritesEntityNode() ? false : super.canDestroy();
    }

    public boolean canRename() {
        return this.isFavouritesEntityNode() ? false : super.canRename();
    }

    private boolean isFavouritesEntityNode() {
        boolean favouriteEntity = false;
        String name = super.getName();
        if (FavouriteEntities.isFavChild(name)) {
            favouriteEntity = true;
        }
        return favouriteEntity;
    }

    private Optional<MaltegoEntitySpec> getEntitySpec() {
        return Optional.ofNullable(((EntitySpecCookie)this.getDataObject().getCookie(EntitySpecCookie.class)).getEntitySpec());
    }
}

