import re
from typing import Any, Dict, Callable, Generator, List, Optional, Sequence, Tuple, Union
from leo.core.leoCommands import Commands as Cmdr

class NodeIndices:
    def __init__(self, id_: str) -> None: ...
    def check_gnx(self, c: Cmdr, gnx: str, v: "VNode") -> None: ...
    def compute_last_index(self, c: Cmdr) -> None: ...
    def computeNewIndex(self) -> str: ...
    def getDefaultId(self) -> str: ...
    def setDefaultId(self, theId: str) -> None: ...
    def getNewIndex(self, v: "VNode", cached: bool=False) -> str: ...
    def new_vnode_helper(self, c: Cmdr, gnx: Optional[str], v: "VNode") -> None: ...
    def scanGnx(self, s: str, i: int=0) -> Tuple[Optional[str], Optional[str], Optional[str]]: ...
    def setTimestamp(self) -> None: ...
    def tupleToString(self, aTuple: Tuple[str, str, Any]) -> str: ...
    def update(self) -> str: ...
    def updateLastIndex(self, gnx: str) -> None: ...
class Position:
    def __eq__(self, p2: Any) -> bool: ...
    def __ne__(self, p2: Any) -> bool: ...
    def __init__(self,
        v: "VNode",
        childIndex: int=0,
        stack: List[Tuple["VNode", int]]=None
    ): ...
    def __ge__(self, other: "Position") -> bool: ...
    def __le__(self, other: "Position") -> bool: ...
    def __lt__(self, other: "Position") -> bool: ...
    def __gt__(self, other: "Position") -> bool: ...
    def __bool__(self) -> bool: ...
    def __str__(self) -> str: ...
    def archivedPosition(self, root_p: "Position"=None) -> List[int]: ...
    def dumpLink(self, link: str) -> str: ...
    def dump(self, label: str="") -> None: ...
    def key(self) -> str: ...
    def sort_key(self, p: "Position") -> List[int]: ...
    def convertTreeToString(self) -> str: ...
    def moreHead(self, firstLevel: int, useVerticalBar: bool=False) -> str: ...
    def moreBody(self) -> str: ...
    def children(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def following_siblings(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def nearest_roots(self, copy: bool=True, predicate: Optional[Callable]=None) -> Generator["Position", None, None]: ...
        # def default_predicate(p: "Position") -> bool: ...
    def nearest_unique_roots(self, copy: bool=True, predicate: Optional[Callable]=None) -> Generator["Position", None, None]: ...
        # def default_predicate(p: "Position") -> bool: ...
    def nodes(self) -> Generator["VNode", None, None]: ...
    def parents(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def self_and_parents(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def self_and_siblings(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def self_and_subtree(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def subtree(self, copy: bool=True) -> Generator["Position", None, None]: ...
    def unique_nodes(self) -> Generator["VNode", None, None]: ...
    def unique_subtree(self) -> Generator["Position", None, None]: ...
    def anyAtFileNodeName(self) -> str: ...
    def atAutoNodeName(self) -> str: ...
    def atCleanNodeName(self) -> str: ...
    def atEditNodeName(self) -> str: ...
    def atFileNodeName(self) -> str: ...
    def atNoSentinelsFileNodeName(self) -> str: ...
    def atShadowFileNodeName(self) -> str: ...
    def atSilentFileNodeName(self) -> str: ...
    def atThinFileNodeName(self) -> str: ...
    def isAnyAtFileNode(self) -> bool: ...
    def isAtAllNode(self) -> bool: ...
    def isAtAutoNode(self) -> bool: ...
    def isAtAutoRstNode(self) -> bool: ...
    def isAtCleanNode(self) -> bool: ...
    def isAtEditNode(self) -> bool: ...
    def isAtFileNode(self) -> bool: ...
    def isAtIgnoreNode(self) -> bool: ...
    def isAtNoSentinelsFileNode(self) -> bool: ...
    def isAtOthersNode(self) -> bool: ...
    def isAtRstFileNode(self) -> bool: ...
    def isAtSilentFileNode(self) -> bool: ...
    def isAtShadowFileNode(self) -> bool: ...
    def isAtThinFileNode(self) -> bool: ...
    def matchHeadline(self, pattern: str) -> bool: ...
    def bodyString(self) -> str: ...
    def headString(self) -> str: ...
    def isDirty(self) -> bool: ...
    def isMarked(self) -> bool: ...
    def isOrphan(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isTopBitSet(self) -> bool: ...
    def isVisited(self) -> bool: ...
    def status(self) -> int: ...
    def childIndex(self) -> int: ...
    def directParents(self) -> List["VNode"]: ...
    def hasChildren(self) -> int: ...
    def numberOfChildren(self) -> int: ...
    def getBack(self) -> "Position": ...
    def getFirstChild(self) -> "Position": ...
    def getLastChild(self) -> "Position": ...
    def getLastNode(self) -> "Position": ...
    def getNext(self) -> "Position": ...
    def getNodeAfterTree(self) -> "Position": ...
    def getNthChild(self, n: int) -> "Position": ...
    def getParent(self) -> "Position": ...
    def getThreadBack(self) -> "Position": ...
    def getThreadNext(self) -> "Position": ...
    def getVisBack(self, c: Cmdr) -> "Position": ...
    def getVisNext(self, c: Cmdr) -> "Position": ...
    def get_UNL(
        self,
        with_file: bool=True,
        with_proto: bool=False,
        with_index: bool=True,
        with_count: bool=False,
    ) -> str: ...
    def hasBack(self) -> bool: ...
    def hasNext(self) -> bool: ...
    def hasParent(self) -> bool: ...
    def hasThreadBack(self) -> bool: ...
    def hasThreadNext(self) -> bool: ...
    def findRootPosition(self) -> "Position": ...
    def isAncestorOf(self, p2: "Position") -> bool: ...
    def isCloned(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isVisible(self, c: Cmdr) -> bool: ...
        # def visible(p: "Position", root: "Position"=None) -> bool: ...
    def level(self) -> int: ...
    def positionAfterDeletedTree(self) -> "Position": ...
    def textOffset(self) -> Optional[int]: ...
    def isOutsideAnyAtFileTree(self) -> bool: ...
    def _adjustPositionBeforeUnlink(self, p2: "Position") -> None: ...
    def _linkAfter(self, p_after: "Position") -> None: ...
    def _linkCopiedAfter(self, p_after: "Position") -> None: ...
    def _linkAsNthChild(self, parent: "Position", n: int) -> None: ...
    def _linkCopiedAsNthChild(self, parent: "Position", n: int) -> None: ...
    def _linkAsRoot(self) -> "Position": ...
    def _parentVnode(self) -> Optional["VNode"]: ...
    def _relinkAsCloneOf(self, p2: "Position") -> None: ...
    def _unlink(self) -> None: ...
    def badUnlink(self, parent_v: "VNode", n: int, child: "VNode") -> None: ...
    def moveToBack(self) -> "Position": ...
    def moveToFirstChild(self) -> "Position": ...
    def moveToLastChild(self) -> "Position": ...
    def moveToLastNode(self) -> "Position": ...
    def moveToNext(self) -> "Position": ...
    def moveToNodeAfterTree(self) -> "Position": ...
    def moveToNthChild(self, n: int) -> "Position": ...
    def moveToParent(self) -> "Position": ...
    def moveToThreadBack(self) -> "Position": ...
    def moveToThreadNext(self) -> "Position": ...
    def moveToVisBack(self, c: Cmdr) -> "Position": ...
    def checkVisBackLimit(self, limit: "Position", limitIsVisible: bool, p: "Position") -> Tuple[bool, Optional["Position"]]: ...
    def moveToVisNext(self, c: Cmdr) -> "Position": ...
    def checkVisNextLimit(self, limit: "Position", p: "Position") -> bool: ...
    def safeMoveToThreadNext(self) -> "Position": ...
    def clone(self) -> "Position": ...
    def copy(self) -> "Position": ...
    def copyTreeAfter(self, copyGnxs: bool=False) -> "Position": ...
    def copyTreeFromSelfTo(self, p2: "Position", copyGnxs: bool=False) -> None: ...
    def copyWithNewVnodes(self, copyMarked: bool=False) -> "Position": ...
    def createNodeHierarchy(self, heads: List[str], forcecreate: bool=False) -> "Position": ...
    def deleteAllChildren(self) -> None: ...
    def doDelete(self, newNode: "Position"=None) -> None: ...
    def insertAfter(self) -> "Position": ...
    def insertAsLastChild(self) -> "Position": ...
    def insertAsNthChild(self, n: int) -> "Position": ...
    def insertBefore(self) -> "Position": ...
    def invalidOutline(self, message: str) -> None: ...
    def moveAfter(self, a: "Position") -> "Position": ...
    def moveToFirstChildOf(self, parent: "Position") -> "Position": ...
    def moveToLastChildOf(self, parent: "Position") -> "Position": ...
    def moveToNthChildOf(self, parent: "Position", n: int) -> "Position": ...
    def moveToRoot(self) -> "Position": ...
    def promote(self) -> None: ...
    def validateOutlineWithParent(self, pv: "Position") -> bool: ...
    def __get_b(self) -> str: ...
    def __set_b(self, val: str) -> None: ...
    def __get_h(self) -> str: ...
    def __set_h(self, val: str) -> None: ...
    def __get_gnx(self) -> str: ...
    def __get_script(self) -> str: ...
    def __get_nosentinels(self) -> str: ...
    def __get_u(self) -> Dict[Any, Any]: ...
    def __set_u(self, val: Dict) -> None: ...
    def contract(self) -> None: ...
    def expand(self) -> None: ...
    def isExpanded(self) -> bool: ...
    def clearMarked(self) -> None: ...
    def clearOrphan(self) -> None: ...
    def clearVisited(self) -> None: ...
    def initExpandedBit(self) -> None: ...
    def initMarkedBit(self) -> None: ...
    def initStatus(self, status: int) -> None: ...
    def setMarked(self) -> None: ...
    def setOrphan(self) -> None: ...
    def setSelected(self) -> None: ...
    def setVisited(self) -> None: ...
    def computeIcon(self) -> int: ...
    def setIcon(self) -> None: ...
    def setSelection(self, start: int, length: int) -> None: ...
    def restoreCursorAndScroll(self) -> None: ...
    def saveCursorAndScroll(self) -> None: ...
    def setBodyString(self, s: str) -> None: ...
    def initHeadString(self, s: str) -> None: ...
    def setHeadString(self, s: str) -> None: ...
    def clearVisitedInTree(self) -> None: ...
    def clearAllVisitedInTree(self) -> None: ...
    def clearDirty(self) -> None: ...
    def inAtIgnoreRange(self) -> bool: ...
    def setAllAncestorAtFileNodesDirty(self) -> None: ...
    def setDirty(self) -> None: ...
    def is_at_all(self) -> bool: ...
    def in_at_all_tree(self) -> bool: ...
    def is_at_ignore(self) -> bool: ...
    def in_at_ignore_tree(self) -> bool: ...
class PosList(list):
    def children(self) -> "PosList": ...
    def filter_h(self, regex: Any, flags: Any=re.IGNORECASE) -> "PosList": ...
    def filter_b(self, regex: Any, flags: Any=re.IGNORECASE) -> "PosList": ...
class VNode:
    def __init__(self, context: Cmdr, gnx: Optional[str]=None) -> None: ...
    def __repr__(self) -> str: ...
    def dumpLink(self, link: str) -> str: ...
    def dump(self, label: str="") -> None: ...
    def findAtFileName(self, names: Sequence[str], h: str='') -> str: ...
    def anyAtFileNodeName(self) -> str: ...
    def atAutoNodeName(self, h: str=None) -> str: ...
    def atAutoRstNodeName(self, h: str=None) -> str: ...
    def atCleanNodeName(self) -> str: ...
    def atEditNodeName(self) -> str: ...
    def atFileNodeName(self) -> str: ...
    def atNoSentinelsFileNodeName(self) -> str: ...
    def atRstFileNodeName(self) -> str: ...
    def atShadowFileNodeName(self) -> str: ...
    def atSilentFileNodeName(self) -> str: ...
    def atThinFileNodeName(self) -> str: ...
    def isAtAllNode(self) -> bool: ...
    def isAnyAtFileNode(self) -> bool: ...
    def isAtAutoNode(self) -> bool: ...
    def isAtAutoRstNode(self) -> bool: ...
    def isAtCleanNode(self) -> bool: ...
    def isAtEditNode(self) -> bool: ...
    def isAtFileNode(self) -> bool: ...
    def isAtRstFileNode(self) -> bool: ...
    def isAtNoSentinelsFileNode(self) -> bool: ...
    def isAtSilentFileNode(self) -> bool: ...
    def isAtShadowFileNode(self) -> bool: ...
    def isAtThinFileNode(self) -> bool: ...
    def isAtIgnoreNode(self) -> bool: ...
    def isAtOthersNode(self) -> bool: ...
    def matchHeadline(self, pattern: str) -> bool: ...
    def copyTree(self, copyMarked: bool=False) -> "VNode": ...
    def bodyString(self) -> str: ...
    def firstChild(self) -> Optional["VNode"]: ...
    def hasChildren(self) -> bool: ...
    def lastChild(self) -> Optional["VNode"]: ...
    def nthChild(self, n: int) -> Optional["VNode"]: ...
    def numberOfChildren(self) -> int: ...
    def directParents(self) -> List["VNode"]: ...
    def hasBody(self) -> bool: ...
    def headString(self) -> str: ...
    def isNthChildOf(self, n: int, parent_v: "VNode") -> bool: ...
    def isCloned(self) -> bool: ...
    def isDirty(self) -> bool: ...
    def isMarked(self) -> bool: ...
    def isOrphan(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isTopBitSet(self) -> bool: ...
    def isVisited(self) -> bool: ...
    def isWriteBit(self) -> bool: ...
    def status(self) -> int: ...
    def clearClonedBit(self) -> None: ...
    def clearDirty(self) -> None: ...
    def clearMarked(self) -> None: ...
    def clearOrphan(self) -> None: ...
    def clearVisited(self) -> None: ...
    def clearWriteBit(self) -> None: ...
    def contract(self) -> None: ...
    def expand(self) -> None: ...
    def initExpandedBit(self) -> None: ...
    def isExpanded(self) -> bool: ...
    def initStatus(self, status: int) -> None: ...
    def setClonedBit(self) -> None: ...
    def initClonedBit(self, val: bool) -> None: ...
    def setDirty(self) -> None: ...
    def setMarked(self) -> None: ...
    def initMarkedBit(self) -> None: ...
    def setOrphan(self) -> None: ...
    def setSelected(self) -> None: ...
    def setVisited(self) -> None: ...
    def setWriteBit(self) -> None: ...
    def childrenModified(self) -> None: ...
    def computeIcon(self) -> int: ...
    def setIcon(self) -> None: ...
    def contentModified(self) -> None: ...
    def restoreCursorAndScroll(self) -> None: ...
    def saveCursorAndScroll(self) -> None: ...
    def setAllAncestorAtFileNodesDirty(self) -> None: ...
        # def v_and_parents(v: "VNode") -> Generator["VNode", None, None]: ...
    def setBodyString(self, s: Union[str, bytes]) -> None: ...
    def setHeadString(self, s: Union[str, bytes]) -> None: ...
    def setSelection(self, start: int, length: int) -> None: ...
    def cloneAsNthChild(self, parent_v: "VNode", n: int) -> "VNode": ...
    def insertAsFirstChild(self) -> "VNode": ...
    def insertAsLastChild(self) -> "VNode": ...
    def insertAsNthChild(self, n: int) -> "VNode": ...
    def _addCopiedLink(self, childIndex: int, parent_v: "VNode") -> None: ...
    def _addLink(self, childIndex: int, parent_v: "VNode") -> None: ...
    def _addParentLinks(self, parent: "VNode") -> None: ...
    def _cutLink(self, childIndex: int, parent_v: "VNode") -> None: ...
    def _cutParentLinks(self, parent: "VNode") -> None: ...
    def _deleteAllChildren(self) -> None: ...
    def _linkAsNthChild(self, parent_v: "VNode", n: int) -> None: ...
    def __get_b(self) -> str: ...
    def __set_b(self, val: str) -> None: ...
    def __get_h(self) -> str: ...
    def __set_h(self, val: str) -> None: ...
    def __get_u(self) -> dict: ...
    def __set_u(self, val: Any) -> None: ...
    def __get_gnx(self) -> Optional[str]: ...
