/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.ui;

import com.jsql.util.LogLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BorderRoundBlu
extends AbstractBorder {
    private static final Logger LOGGER = LogManager.getRootLogger();

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = 5;
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(x, y, (float)width - 1.0f, (float)height - 1.0f, r, r);
        Container parent = c.getParent();
        if (parent != null) {
            g2.setColor(parent.getBackground());
            Area corner = new Area(new Rectangle2D.Float(x, y, width, height));
            corner.subtract(new Area(round));
            try {
                g2.fill(corner);
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        g2.setColor(Color.GRAY);
        try {
            g2.draw(round);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(4, 8, 4, 8);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = 8;
        insets.left = 8;
        insets.bottom = 4;
        insets.top = 4;
        return insets;
    }
}

