/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.tree.ActionCheckUncheck;
import com.jsql.view.swing.tree.CellRendererNode;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellEditorNode
extends AbstractCellEditor
implements TreeCellEditor,
TreeSelectionListener,
MouseListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private CellRendererNode defaultTreeRenderer = new CellRendererNode();
    private transient AbstractNodeModel nodeModel;

    public CellEditorNode() {
        MediatorHelper.treeDatabase().addTreeSelectionListener(this);
        MediatorHelper.treeDatabase().addMouseListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object nodeRenderer, boolean selected, boolean expanded, boolean leaf, int row) {
        Component componentRenderer = this.defaultTreeRenderer.getTreeCellRendererComponent(tree, nodeRenderer, true, expanded, leaf, row, true);
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodeRenderer;
        Object currentNodeModel = currentNode.getUserObject();
        try {
            this.nodeModel = (AbstractNodeModel)currentNodeModel;
            if (componentRenderer instanceof JCheckBox) {
                ((JCheckBox)componentRenderer).addActionListener(new ActionCheckUncheck(this.nodeModel, currentNode));
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        return componentRenderer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.nodeModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        AbstractNodeModel dataModel;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)MediatorHelper.treeDatabase().getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getUserObject() instanceof AbstractNodeModel && !(dataModel = (AbstractNodeModel)node.getUserObject()).isLoaded()) {
            dataModel.runAction();
        }
    }

    private void showPopup(MouseEvent e) {
        AbstractNodeModel currentTableModel;
        if (!e.isPopupTrigger()) {
            return;
        }
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode currentTableNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (currentTableNode.getUserObject() instanceof AbstractNodeModel && (currentTableModel = (AbstractNodeModel)currentTableNode.getUserObject()).isPopupDisplayable()) {
            currentTableModel.showPopup(currentTableNode, path, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

