/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab.dnd;

import com.jsql.view.swing.action.ActionCloseTabResult;
import com.jsql.view.swing.tab.dnd.GhostGlassPane;
import com.jsql.view.swing.ui.CustomMetalTabbedPaneUI;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;

public class DnDTabbedPane
extends JTabbedPane {
    private static final int SCROLL_SIZE = 20;
    private static final int BUTTON_SIZE = 30;
    private static final int LINE_WIDTH = 3;
    private static final Rectangle RECT_BACKWARD = new Rectangle();
    private static final Rectangle RECT_FORWARD = new Rectangle();
    protected static final Rectangle RECT_LINE = new Rectangle();
    protected int dragTabIndex = -1;
    private transient DnDDropLocation dropLocation;

    private void clickArrowButton(String actionKey) {
        JButton scrollForwardButton = null;
        JButton scrollBackwardButton = null;
        for (Component c : this.getComponents()) {
            if (!(c instanceof JButton)) continue;
            if (scrollForwardButton == null) {
                scrollForwardButton = (JButton)c;
                continue;
            }
            if (scrollBackwardButton != null) continue;
            scrollBackwardButton = (JButton)c;
        }
        JButton button = "scrollTabsForwardAction".equals(actionKey) ? scrollForwardButton : scrollBackwardButton;
        Optional.ofNullable(button).filter(Component::isEnabled).ifPresent(AbstractButton::doClick);
    }

    public void autoScrollTest(Point pt) {
        Rectangle r = this.getTabAreaBounds();
        if (DnDTabbedPane.isTopBottomTabPlacement(this.getTabPlacement())) {
            RECT_BACKWARD.setBounds(r.x, r.y, 20, r.height);
            RECT_FORWARD.setBounds(r.x + r.width - 20 - 30, r.y, 50, r.height);
        } else {
            RECT_BACKWARD.setBounds(r.x, r.y, r.width, 20);
            RECT_FORWARD.setBounds(r.x, r.y + r.height - 20 - 30, r.width, 50);
        }
        if (RECT_BACKWARD.contains(pt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (RECT_FORWARD.contains(pt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    protected DnDTabbedPane() {
        this.setUI(new CustomMetalTabbedPaneUI());
        this.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UiUtil.COLOR_COMPONENT_BORDER));
        Handler h = new Handler();
        this.addMouseListener(h);
        this.addMouseMotionListener(h);
        this.addPropertyChangeListener(h);
    }

    public DnDDropLocation dropLocationForPointDnD(Point p) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getBoundsAt(i).contains(p)) continue;
            return new DnDDropLocation(p, i);
        }
        if (this.getTabAreaBounds().contains(p)) {
            return new DnDDropLocation(p, this.getTabCount());
        }
        return new DnDDropLocation(p, -1);
    }

    public Object setDropLocation(TransferHandler.DropLocation location, boolean forDrop) {
        DnDDropLocation old = this.dropLocation;
        if (Objects.isNull(location) || !forDrop) {
            this.dropLocation = new DnDDropLocation(new Point(), -1);
        } else if (location instanceof DnDDropLocation) {
            this.dropLocation = (DnDDropLocation)location;
        }
        this.firePropertyChange("dropLocation", old, this.dropLocation);
        return null;
    }

    public void exportTab(int dragIndex, JTabbedPane target, int targetIndex) {
        Component cmp = this.getComponentAt(dragIndex);
        Component tab = this.getTabComponentAt(dragIndex);
        String title = this.getTitleAt(dragIndex);
        Icon icon = this.getIconAt(dragIndex);
        String tip = this.getToolTipTextAt(dragIndex);
        boolean isEnabled = this.isEnabledAt(dragIndex);
        this.remove(dragIndex);
        target.insertTab(title, icon, cmp, tip, targetIndex);
        target.setEnabledAt(targetIndex, isEnabled);
        target.setTabComponentAt(targetIndex, tab);
        target.setSelectedIndex(targetIndex);
        if (tab instanceof JComponent) {
            ((JComponent)tab).scrollRectToVisible(tab.getBounds());
        }
    }

    public void convertTab(int prev, int next) {
        Component cmp = this.getComponentAt(prev);
        Component tab = this.getTabComponentAt(prev);
        String title = this.getTitleAt(prev);
        Icon icon = this.getIconAt(prev);
        String tip = this.getToolTipTextAt(prev);
        boolean isEnabled = this.isEnabledAt(prev);
        int tgtindex = prev > next ? next : next - 1;
        this.remove(prev);
        this.insertTab(title, icon, cmp, tip, tgtindex);
        this.setEnabledAt(tgtindex, isEnabled);
        if (isEnabled) {
            this.setSelectedIndex(tgtindex);
        }
        this.setTabComponentAt(tgtindex, tab);
    }

    public Optional<Rectangle> getDropLineRect() {
        int index = Optional.ofNullable(this.getDropLocation()).filter(DnDDropLocation::isDroppable).map(DnDDropLocation::getIndex).orElse(-1);
        if (index < 0) {
            RECT_LINE.setBounds(0, 0, 0, 0);
            return Optional.empty();
        }
        int a = Math.min(index, 1);
        Rectangle r = this.getBoundsAt(a * (index - 1));
        if (DnDTabbedPane.isTopBottomTabPlacement(this.getTabPlacement())) {
            RECT_LINE.setBounds(r.x - 1 + r.width * a, r.y, 3, r.height);
        } else {
            RECT_LINE.setBounds(r.x, r.y - 1 + r.height * a, r.width, 3);
        }
        return Optional.of(RECT_LINE);
    }

    public Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        int xx = tabbedRect.x;
        int yy = tabbedRect.y;
        Rectangle compRect = Optional.ofNullable(this.getSelectedComponent()).map(Component::getBounds).orElseGet(Rectangle::new);
        int tabPlacement = this.getTabPlacement();
        if (DnDTabbedPane.isTopBottomTabPlacement(tabPlacement)) {
            tabbedRect.height -= compRect.height;
            if (tabPlacement == 3) {
                tabbedRect.y += compRect.y + compRect.height;
            }
        } else {
            tabbedRect.width -= compRect.width;
            if (tabPlacement == 4) {
                tabbedRect.x += compRect.x + compRect.width;
            }
        }
        tabbedRect.translate(-xx, -yy);
        return tabbedRect;
    }

    public static boolean isTopBottomTabPlacement(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3;
    }

    public final DnDDropLocation getDropLocation() {
        return this.dropLocation;
    }

    private class Handler
    extends MouseAdapter
    implements PropertyChangeListener {
        private Point startPt;
        private final int gestureMotionThreshold = DragSource.getDragThreshold();

        private Handler() {
        }

        private void repaintDropLocation() {
            Component c = DnDTabbedPane.this.getRootPane().getGlassPane();
            if (c instanceof GhostGlassPane) {
                GhostGlassPane glassPane = (GhostGlassPane)c;
                glassPane.setTargetTabbedPane(DnDTabbedPane.this);
                glassPane.repaint();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("dropLocation".equals(propertyName)) {
                this.repaintDropLocation();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean isOnlyOneTab;
            DnDTabbedPane src = (DnDTabbedPane)e.getComponent();
            boolean bl = isOnlyOneTab = src.getTabCount() <= 1;
            if (isOnlyOneTab) {
                this.startPt = null;
                return;
            }
            Point tabPt = e.getPoint();
            int idx = src.indexAtLocation(tabPt.x, tabPt.y);
            boolean flag = idx < 0 || !src.isEnabledAt(idx) || Objects.isNull(src.getComponentAt(idx));
            this.startPt = flag ? null : tabPt;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point tabPt = e.getPoint();
            if (Objects.nonNull(this.startPt) && this.startPt.distance(tabPt) > (double)this.gestureMotionThreshold) {
                DnDTabbedPane src = (DnDTabbedPane)e.getComponent();
                TransferHandler th = src.getTransferHandler();
                DnDTabbedPane.this.dragTabIndex = src.indexAtLocation(tabPt.x, tabPt.y);
                th.exportAsDrag(src, e, 2);
                RECT_LINE.setBounds(0, 0, 0, 0);
                src.getRootPane().getGlassPane().setVisible(true);
                src.setDropLocation(new DnDDropLocation(tabPt, -1), true);
                this.startPt = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point tabPt = e.getPoint();
            JTabbedPane src = (JTabbedPane)e.getSource();
            int i = src.indexAtLocation(tabPt.x, tabPt.y);
            if (-1 < i && e.getButton() == 2) {
                ActionCloseTabResult.perform(i);
            }
        }
    }

    public static final class DnDDropLocation
    extends TransferHandler.DropLocation {
        private final int index;
        private boolean dropable = true;

        protected DnDDropLocation(Point p, int index) {
            super(p);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setDroppable(boolean flag) {
            this.dropable = flag;
        }

        public boolean isDroppable() {
            return this.dropable;
        }
    }
}

