/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.sql.lexer;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.sql.lexer.DocPosition;
import com.jsql.view.swing.sql.lexer.DocPositionComparator;
import com.jsql.view.swing.sql.lexer.DocumentReader;
import com.jsql.view.swing.sql.lexer.HighlightedDocument;
import com.jsql.view.swing.sql.lexer.TokenStyles;
import com.jsql.view.swing.sql.lexer.syntax.Lexer;
import com.jsql.view.swing.sql.lexer.syntax.Token;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Colorer
extends Thread {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private WeakReference<HighlightedDocument> document;
    private TreeSet<DocPosition> iniPositions = new TreeSet<DocPosition>(DocPositionComparator.instance);
    private HashSet<DocPosition> newPositions = new HashSet();
    private volatile LinkedList<RecolorEvent> events = new LinkedList();
    private Object eventsLock = new Object();
    private volatile int change = 0;
    private volatile int lastPosition = -1;

    public Colorer(HighlightedDocument document) {
        super("ThreadColorer");
        this.document = new WeakReference<HighlightedDocument>(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void color(int position, int adjustment) {
        if (position < this.lastPosition) {
            this.change = this.lastPosition < position - adjustment ? (this.change -= this.lastPosition - position) : (this.change += adjustment);
        }
        Object object = this.eventsLock;
        synchronized (object) {
            if (!this.events.isEmpty()) {
                RecolorEvent curLast = this.events.getLast();
                if (adjustment < 0 && curLast.getAdjustment() < 0) {
                    if (position == curLast.getPosition()) {
                        curLast.setAdjustment(curLast.getAdjustment() + adjustment);
                        return;
                    }
                } else if (adjustment >= 0 && curLast.getAdjustment() >= 0) {
                    if (position == curLast.getPosition() + curLast.getAdjustment()) {
                        curLast.setAdjustment(curLast.getAdjustment() + adjustment);
                        return;
                    }
                    if (curLast.getPosition() == position + adjustment) {
                        curLast.setPosition(position);
                        curLast.setAdjustment(curLast.getAdjustment() + adjustment);
                        return;
                    }
                }
            }
            this.events.add(new RecolorEvent(position, adjustment));
            this.eventsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.document.get() != null) {
            try {
                RecolorEvent re = new RecolorEvent(0, 0);
                Object object = this.eventsLock;
                synchronized (object) {
                    while (this.events.isEmpty() && this.document.get() != null) {
                        this.eventsLock.wait(1000L);
                    }
                    if (!this.events.isEmpty()) {
                        re = this.events.removeFirst();
                    }
                }
                this.processEvent(re.getPosition(), re.getAdjustment());
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(int position, int adjustment) {
        Iterator workingIt;
        SortedSet<DocPosition> workingSet;
        HighlightedDocument doc = (HighlightedDocument)this.document.get();
        if (doc == null) {
            return;
        }
        AttributeSet globalStyle = doc.getGlobalStyle();
        Lexer syntaxLexer = doc.getSyntaxLexer();
        DocumentReader documentReader = doc.getDocumentReader();
        Object docLock = doc.getDocumentLock();
        if (globalStyle != null) {
            int start = Math.min(position, position + adjustment);
            int stop = Math.max(position, position + adjustment);
            Object object = docLock;
            synchronized (object) {
                doc.setCharacterAttributes(start, stop - start, globalStyle, true);
            }
            return;
        }
        DocPosition startRequest = new DocPosition(position);
        DocPosition endRequest = new DocPosition(position + Math.abs(adjustment));
        DocPosition dpStart = null;
        try {
            workingSet = this.iniPositions.headSet(startRequest);
            dpStart = workingSet.last();
        }
        catch (NoSuchElementException e) {
            dpStart = new DocPosition(0);
            LOGGER.log(LogLevel.IGNORE, e);
        }
        if (adjustment < 0) {
            workingSet = this.iniPositions.subSet(startRequest, endRequest);
            workingIt = workingSet.iterator();
            while (workingIt.hasNext()) {
                workingIt.next();
                workingIt.remove();
            }
        }
        workingSet = this.iniPositions.tailSet(startRequest);
        workingIt = workingSet.iterator();
        while (workingIt.hasNext()) {
            ((DocPosition)workingIt.next()).adjustPosition(adjustment);
        }
        workingSet = this.iniPositions.tailSet(dpStart);
        workingIt = workingSet.iterator();
        DocPosition dp = null;
        if (workingIt.hasNext()) {
            dp = (DocPosition)workingIt.next();
        }
        try {
            Token t;
            boolean done = false;
            DocPosition dpEnd = dpStart;
            Object object = docLock;
            synchronized (object) {
                syntaxLexer.reset(documentReader, 0, dpStart.getPosition(), 0);
                documentReader.seek(dpStart.getPosition());
                t = syntaxLexer.getNextToken();
            }
            this.newPositions.add(dpStart);
            while (!done && t != null) {
                if (t.getCharEnd() <= doc.getLength()) {
                    doc.setCharacterAttributes(t.getCharBegin() + this.change, t.getCharEnd() - t.getCharBegin(), TokenStyles.getStyle(t.getDescription()), true);
                    dpEnd = new DocPosition(t.getCharEnd());
                }
                this.lastPosition = t.getCharEnd() + this.change;
                if (t.getState() == 0) {
                    while (dp != null && dp.getPosition() <= t.getCharEnd()) {
                        if (dp.getPosition() == t.getCharEnd() && dp.getPosition() >= endRequest.getPosition()) {
                            done = true;
                            dp = null;
                            continue;
                        }
                        if (workingIt.hasNext()) {
                            dp = (DocPosition)workingIt.next();
                            continue;
                        }
                        dp = null;
                    }
                    this.newPositions.add(dpEnd);
                }
                object = docLock;
                synchronized (object) {
                    t = syntaxLexer.getNextToken();
                }
            }
            workingIt = this.iniPositions.subSet(dpStart, dpEnd).iterator();
            while (workingIt.hasNext()) {
                workingIt.next();
                workingIt.remove();
            }
            workingIt = this.iniPositions.tailSet(new DocPosition(doc.getLength())).iterator();
            while (workingIt.hasNext()) {
                workingIt.next();
                workingIt.remove();
            }
            this.iniPositions.addAll(this.newPositions);
            this.newPositions.clear();
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.IGNORE, e);
        }
        Object object = docLock;
        synchronized (object) {
            this.lastPosition = -1;
            this.change = 0;
        }
    }

    public void stopThread() {
        this.document.clear();
    }

    private static class RecolorEvent {
        private int position;
        private int adjustment;

        public RecolorEvent(int position, int adjustment) {
            this.position = position;
            this.adjustment = adjustment;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public int getAdjustment() {
            return this.adjustment;
        }

        public void setAdjustment(int adjustment) {
            this.adjustment = adjustment;
        }
    }
}

