/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.scrollpane;

import com.jsql.util.LogLevel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JScrollIndicator
extends JLayeredPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final int SCROLL_BAR_ALPHA_ROLLOVER = 100;
    private static final int SCROLL_BAR_ALPHA = 25;
    private static final Color THUMB_COLOR = Color.DARK_GRAY;
    private static final int THUMB_THICKNESS = 15;
    private static final int THUMB_MIN_SIZE = 48;
    private static final int THUMB_MARGIN = 0;
    private final JScrollPane scrollPane;
    private final ControlPanel controlPanel;

    public JScrollIndicator(JComponent view) {
        this(view, 20, 30);
    }

    public JScrollIndicator(JComponent view, int scrollPaneConstants) {
        this(view, 20, scrollPaneConstants);
    }

    public JScrollIndicator(JComponent view, int vsbPolicy, int hsbPolicy) {
        this.scrollPane = new JScrollPane(view, vsbPolicy, hsbPolicy);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.scrollPane, JLayeredPane.DEFAULT_LAYER);
        this.controlPanel = new ControlPanel(this.scrollPane);
        this.add((Component)this.controlPanel, JLayeredPane.PALETTE_LAYER);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollIndicator.this.scrollPane.setSize(JScrollIndicator.this.getSize());
                JScrollIndicator.this.scrollPane.getViewport().revalidate();
                JScrollIndicator.this.controlPanel.setSize(JScrollIndicator.this.getSize());
                JScrollIndicator.this.controlPanel.revalidate();
            }
        });
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public class MyScrollBarUI
    extends BasicScrollBarUI {
        private JMyScrollBar myScrollBar;
        private int alpha = 0;

        private MyScrollBarUI(JMyScrollBar scrollBar) {
            this.myScrollBar = scrollBar;
        }

        @Override
        protected void installComponents() {
            this.incrButton = new JButton();
            this.decrButton = new JButton();
            if (this.myScrollBar.getOrientation() == 0) {
                int size = 15;
                this.incrButton.setPreferredSize(new Dimension(size, size));
            } else {
                this.incrButton.setPreferredSize(new Dimension(0, 0));
            }
            this.decrButton.setPreferredSize(new Dimension(0, 0));
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            int w = this.minimumThumbSize.width;
            int h = this.minimumThumbSize.height;
            if (this.myScrollBar.getOrientation() == 1) {
                h = Math.max(h, Math.min(this.maximumThumbSize.height, 48));
            } else {
                w = Math.max(w, Math.min(this.maximumThumbSize.width, 48));
            }
            this.minimumThumbSize = new Dimension(w, h);
        }

        private void paintThumb(Graphics g) {
            int alphaThumb = this.isThumbRollover() ? 100 : 25;
            g.setColor(new Color(this.getAlphaColor(THUMB_COLOR).getRed(), this.getAlphaColor(THUMB_COLOR).getGreen(), this.getAlphaColor(THUMB_COLOR).getBlue(), alphaThumb));
            Rectangle thumbBounds = this.getThumbBounds();
            int x = thumbBounds.x;
            int y = thumbBounds.y;
            int w = thumbBounds.width;
            int h = thumbBounds.height;
            if (this.myScrollBar.getOrientation() == 1) {
                w += 0;
            } else {
                h += 0;
            }
            g.fillRect(x, y, w, h);
        }

        private Color getAlphaColor(Color color) {
            if (this.alpha == 100) {
                return color;
            }
            int rgb = color.getRGB() & 0xFFFFFF;
            return new Color(rgb |= this.alpha / 100 * 255 << 24, true);
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
            this.myScrollBar.repaint(this.getThumbBounds());
        }

        public void setVisible() {
            this.myScrollBar.repaint(this.getThumbBounds());
        }
    }

    private class JMyScrollBar
    extends JScrollBar {
        protected final transient MyScrollBarUI scrollUI;

        public JMyScrollBar(int direction) {
            super(direction);
            this.scrollUI = new MyScrollBarUI(this);
            super.setUI(this.scrollUI);
            this.setUnitIncrement(64);
            int size = 15;
            this.setPreferredSize(new Dimension(size, size));
            this.scrollUI.setVisible();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    JMyScrollBar.this.scrollUI.setVisible();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JMyScrollBar.this.scrollUI.setVisible();
                }
            });
            this.addAdjustmentListener(adjustmentEvent -> this.scrollUI.setVisible());
        }

        @Override
        public void setUI(ScrollBarUI ui) {
        }

        @Override
        public void updateUI() {
        }

        @Override
        public void paint(Graphics g) {
            this.scrollUI.paintThumb(g);
        }

        @Override
        public void repaint(Rectangle r) {
            JScrollIndicator scrollIndicator = JScrollIndicator.this;
            try {
                Rectangle rect = SwingUtilities.convertRectangle(this, r, scrollIndicator);
                rect.grow(1, 1);
                scrollIndicator.repaint(rect);
            }
            catch (NullPointerException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
    }

    private class ControlPanel
    extends JPanel {
        private final JMyScrollBar vScrollBar;
        private final JMyScrollBar hScrollBar;

        private ControlPanel(JScrollPane scrollPane) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.vScrollBar = new JMyScrollBar(1);
            scrollPane.setVerticalScrollBar(this.vScrollBar);
            scrollPane.remove(this.vScrollBar);
            if (scrollPane.getVerticalScrollBarPolicy() != 21) {
                this.add((Component)this.vScrollBar, "East");
            }
            this.hScrollBar = new JMyScrollBar(0);
            scrollPane.setHorizontalScrollBar(this.hScrollBar);
            scrollPane.remove(this.hScrollBar);
            if (scrollPane.getHorizontalScrollBarPolicy() != 31) {
                this.add((Component)this.hScrollBar, "South");
            }
        }
    }
}

