/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.consoles;

import com.jsql.model.bean.util.HttpHeader;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.util.StringUtil;
import com.jsql.view.swing.panel.util.HTMLEditorKitTextPaneWrap;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextPanePlaceholder;
import com.jsql.view.swing.ui.CustomMetalTabbedPaneUI;
import com.jsql.view.swing.util.I18nViewUtil;
import java.awt.FontMetrics;
import java.util.AbstractMap;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public class TabbedPaneNetworkTab
extends TabbedPaneWheeled {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private JTextArea textAreaNetworkTabUrl = (JTextArea)new JPopupTextArea("Request URL").getProxy();
    private JTextArea textAreaNetworkTabResponse = (JTextArea)new JPopupTextArea("Header server response").getProxy();
    private JTextArea textAreaNetworkTabSource = (JTextArea)new JPopupTextArea("Raw page source").getProxy();
    private JTextPane textAreaNetworkTabPreview = new JTextPanePlaceholder("Web browser rendering");
    private JTextArea textAreaNetworkTabHeader = (JTextArea)new JPopupTextArea("Header client request").getProxy();
    private JTextArea textAreaNetworkTabParams = (JTextArea)new JPopupTextArea("HTTP POST parameters").getProxy();

    public TabbedPaneNetworkTab() {
        this.setUI(new CustomMetalTabbedPaneUI(){

            @Override
            protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
                return Math.max(65, super.calculateTabWidth(tabPlacement, tabIndex, metrics));
            }
        });
        Stream.of(new AbstractMap.SimpleEntry<String, JTextArea>("NETWORK_TAB_URL_LABEL", this.textAreaNetworkTabUrl), new AbstractMap.SimpleEntry<String, JTextArea>("NETWORK_TAB_RESPONSE_LABEL", this.textAreaNetworkTabResponse), new AbstractMap.SimpleEntry<String, JTextArea>("NETWORK_TAB_SOURCE_LABEL", this.textAreaNetworkTabSource), new AbstractMap.SimpleEntry<String, JTextPane>("NETWORK_TAB_PREVIEW_LABEL", this.textAreaNetworkTabPreview), new AbstractMap.SimpleEntry<String, JTextArea>("NETWORK_TAB_HEADERS_LABEL", this.textAreaNetworkTabHeader), new AbstractMap.SimpleEntry<String, JTextArea>("NETWORK_TAB_PARAMS_LABEL", this.textAreaNetworkTabParams)).forEach(entry -> {
            this.addTab(I18nUtil.valueByKey((String)entry.getKey()), new LightScrollPane(1, 1, 0, 0, (JComponent)entry.getValue()));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            this.setTabComponentAt(this.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
            DefaultCaret caret = (DefaultCaret)((JTextComponent)entry.getValue()).getCaret();
            caret.setUpdatePolicy(1);
        });
        this.textAreaNetworkTabHeader.setLineWrap(true);
        this.textAreaNetworkTabParams.setLineWrap(true);
        this.textAreaNetworkTabResponse.setLineWrap(true);
        this.textAreaNetworkTabUrl.setLineWrap(true);
        this.textAreaNetworkTabSource.setLineWrap(true);
        this.textAreaNetworkTabPreview.setEditorKit(new HTMLEditorKitTextPaneWrap());
        this.textAreaNetworkTabPreview.setContentType("text/html");
        this.textAreaNetworkTabPreview.setEditable(false);
    }

    public void changeTextNetwork(HttpHeader networkData) {
        this.textAreaNetworkTabParams.setText(networkData.getPost());
        this.textAreaNetworkTabUrl.setText(networkData.getUrl());
        this.textAreaNetworkTabHeader.setText("");
        this.textAreaNetworkTabResponse.setText("");
        for (String key : networkData.getHeader().keySet()) {
            this.textAreaNetworkTabHeader.append(key + ": " + networkData.getHeader().get(key));
            this.textAreaNetworkTabHeader.append("\n");
        }
        for (String key : networkData.getResponse().keySet()) {
            this.textAreaNetworkTabResponse.append(key + ": " + networkData.getResponse().get(key));
            this.textAreaNetworkTabResponse.append("\n");
        }
        try {
            this.textAreaNetworkTabSource.setText(StringUtil.detectUtf8(networkData.getSource()).replaceAll("#{5,}", "#*").trim());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.textAreaNetworkTabPreview.getEditorKit().createDefaultDocument();
        try {
            this.textAreaNetworkTabPreview.setText(Jsoup.clean(String.format("<html>%s</html>", StringUtil.detectUtf8(networkData.getSource())).replaceAll("<img[^>]*>", "").replaceAll("<input[^>]*type=\"?hidden\"?.*>", "").replaceAll("<input[^>]*type=\"?(submit|button)\"?.*>", "<div style=\"background-color:#eeeeee;text-align:center;border:1px solid black;width:100px;\">button</div>").replaceAll("<input[^>]*>", "<div style=\"text-align:center;border:1px solid black;width:100px;\">input</div>"), Whitelist.relaxed().addTags("center", "div", "span").addAttributes(":all", "style")));
        }
        catch (Exception | ExceptionInInitializerError e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, e);
        }
    }

    public void reset() {
        this.textAreaNetworkTabUrl.setText("");
        this.textAreaNetworkTabHeader.setText("");
        this.textAreaNetworkTabParams.setText("");
        this.textAreaNetworkTabResponse.setText("");
        try {
            this.textAreaNetworkTabSource.setText("");
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        try {
            this.textAreaNetworkTabPreview.setText("");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

