/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel;

import com.jsql.view.swing.action.ActionCheckIP;
import com.jsql.view.swing.panel.preferences.ActionListenerSave;
import com.jsql.view.swing.panel.preferences.PanelAuth;
import com.jsql.view.swing.panel.preferences.PanelConnection;
import com.jsql.view.swing.panel.preferences.PanelGeneral;
import com.jsql.view.swing.panel.preferences.PanelInjection;
import com.jsql.view.swing.panel.preferences.PanelProxy;
import com.jsql.view.swing.panel.preferences.PanelTampering;
import com.jsql.view.swing.panel.preferences.PanelUserAgent;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.text.WordUtils;

public class PanelPreferences
extends JPanel {
    private transient ActionListener actionListenerSave = new ActionListenerSave(this);
    private PanelTampering panelTamperingPreferences = new PanelTampering(this);
    private PanelInjection panelInjectionPreferences = new PanelInjection(this);
    private PanelProxy panelProxyPreferences = new PanelProxy(this);
    private PanelAuth panelAuthPreferences = new PanelAuth(this);
    private PanelGeneral panelGeneralPreferences = new PanelGeneral(this);
    private PanelUserAgent panelUserAgentPreferences = new PanelUserAgent();
    private PanelConnection panelConnectionPreferences = new PanelConnection(this);
    private static final JPanel panelInjection = new JPanel(new BorderLayout());
    private static final JPanel panelAuth = new JPanel(new BorderLayout());
    private static final JPanel panelProxy = new JPanel(new BorderLayout());
    private static final JPanel panelGeneral = new JPanel(new BorderLayout());
    private static final JPanel panelUserAgent = new JPanel(new BorderLayout());
    private static final JPanel panelTampering = new JPanel(new BorderLayout());
    private static final JPanel panelConnection = new JPanel(new BorderLayout());
    private transient Border panelBorder = BorderFactory.createEmptyBorder(10, 15, 0, 15);

    public PanelPreferences() {
        BorderLayout borderLayoutPreferences = new BorderLayout();
        this.setLayout(borderLayoutPreferences);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JList<CategoryPreference> categories = this.getCategories(borderLayoutPreferences);
        this.add(categories, "Before");
        panelInjection.setBorder(this.panelBorder);
        panelInjection.add((Component)new JLabel("<html><b>Injection</b> / Process configuration</html>"), "North");
        panelInjection.add((Component)this.panelInjectionPreferences, "Center");
        panelTampering.setBorder(this.panelBorder);
        panelTampering.add((Component)new JLabel("<html><b>Tampering</b> / SQL transform to bypass Web Application Firewall</html>"), "North");
        panelTampering.add((Component)this.panelTamperingPreferences, "Center");
        panelConnection.setBorder(this.panelBorder);
        panelConnection.add((Component)new JLabel("<html><b>Connection</b> / Network and threads</html>"), "North");
        panelConnection.add((Component)this.panelConnectionPreferences, "Center");
        panelAuth.setBorder(this.panelBorder);
        panelAuth.add((Component)new JLabel("<html><b>Authentication</b> / Basic, Digest, NTLM or Kerberos connection</html>"), "North");
        panelAuth.add((Component)this.panelAuthPreferences, "Center");
        panelUserAgent.setBorder(this.panelBorder);
        panelUserAgent.add((Component)new JLabel("<html><b>User Agent</b> / Network connection agents</html>"), "North");
        panelUserAgent.add((Component)this.panelUserAgentPreferences, "Center");
        this.initializePanelProxy();
        panelGeneral.setBorder(this.panelBorder);
        panelGeneral.add((Component)new JLabel("<html><b>General</b> / Basic options</html>"), "North");
        panelGeneral.add((Component)this.panelGeneralPreferences, "Center");
        this.add((Component)panelInjection, "Center");
    }

    private void initializePanelProxy() {
        panelProxy.setLayout(new BoxLayout(panelProxy, 1));
        panelProxy.setBorder(this.panelBorder);
        JButton buttonCheckIp = new JButton("Check your IP");
        buttonCheckIp.addActionListener(new ActionCheckIP());
        buttonCheckIp.setToolTipText("<html><b>Verify what public IP address is used by jSQL</b><br>Usually it's your own public IP if you don't use a proxy. If you use a proxy<br>like TOR then your public IP is hidden and another one is used instead.</html>");
        buttonCheckIp.setContentAreaFilled(true);
        buttonCheckIp.setBorder(UiUtil.BORDER_ROUND_BLU);
        FlatButtonMouseAdapter flatButtonMouseAdapter = new FlatButtonMouseAdapter(buttonCheckIp);
        flatButtonMouseAdapter.setContentVisible(true);
        buttonCheckIp.addMouseListener(flatButtonMouseAdapter);
        JLabel labelProxy = new JLabel("<html><b>Proxy</b> / Settings for tools like Burp and Tor</html>");
        panelProxy.removeAll();
        panelProxy.add((Component)labelProxy, "North");
        panelProxy.add(this.panelProxyPreferences);
        JPanel panelCheckIp = new JPanel(new FlowLayout(3, 0, 0));
        panelCheckIp.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        panelCheckIp.add(buttonCheckIp);
        panelCheckIp.add(Box.createGlue());
        panelProxy.add(panelCheckIp);
        labelProxy.setAlignmentX(0.0f);
        this.panelProxyPreferences.setAlignmentX(0.0f);
        panelCheckIp.setAlignmentX(0.0f);
    }

    private JList<CategoryPreference> getCategories(BorderLayout borderLayoutPreferences) {
        JList<CategoryPreference> categories = new JList<CategoryPreference>(CategoryPreference.values());
        categories.setSelectionMode(0);
        categories.setSelectedIndex(0);
        categories.setBorder(BorderFactory.createLineBorder(UiUtil.COLOR_COMPONENT_BORDER));
        categories.addListSelectionListener(e -> {
            this.remove(borderLayoutPreferences.getLayoutComponent("Center"));
            this.add(((CategoryPreference)((Object)((Object)categories.getSelectedValue()))).getPanel(), "Center");
            this.revalidate();
            this.repaint();
        });
        categories.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel labelItemList = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (isSelected) {
                    labelItemList.setBackground(UiUtil.COLOR_FOCUS_GAINED);
                    labelItemList.setForeground(Color.BLACK);
                }
                labelItemList.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(3, 3, 0, 3, Color.WHITE), isSelected ? BorderFactory.createLineBorder(UiUtil.COLOR_COMPONENT_BORDER) : labelItemList.getBorder()));
                return labelItemList;
            }
        });
        return categories;
    }

    public PanelAuth getPanelAuth() {
        return this.panelAuthPreferences;
    }

    public PanelProxy getPanelProxy() {
        return this.panelProxyPreferences;
    }

    public PanelInjection getPanelInjection() {
        return this.panelInjectionPreferences;
    }

    public PanelTampering getPanelTampering() {
        return this.panelTamperingPreferences;
    }

    public PanelGeneral getPanelGeneral() {
        return this.panelGeneralPreferences;
    }

    public PanelUserAgent getPanelUserAgent() {
        return this.panelUserAgentPreferences;
    }

    public PanelConnection getPanelConnection() {
        return this.panelConnectionPreferences;
    }

    public ActionListener getActionListenerSave() {
        return this.actionListenerSave;
    }

    private static enum CategoryPreference {
        INJECTION(panelInjection),
        TAMPERING(panelTampering),
        CONNECTION(panelConnection),
        AUTH(panelAuth),
        USER_AGENT(panelUserAgent),
        PROXY(panelProxy),
        GENERAL(panelGeneral);

        private Component panel;

        private CategoryPreference(Component panel) {
            this.panel = panel;
        }

        public String toString() {
            return "  " + WordUtils.capitalizeFully(this.name()).replace('_', ' ') + "  ";
        }

        public Component getPanel() {
            return this.panel;
        }
    }
}

