/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.console.JTextPaneAppender;
import com.jsql.view.swing.console.JavaConsoleAdapter;
import com.jsql.view.swing.console.SimpleConsoleAdapter;
import com.jsql.view.swing.panel.consoles.NetworkTable;
import com.jsql.view.swing.panel.consoles.TabbedPaneNetworkTab;
import com.jsql.view.swing.panel.split.SplitHorizontalTopBottom;
import com.jsql.view.swing.scrollpane.JScrollIndicator;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.splitpane.JSplitPaneWithZeroSizeDivider;
import com.jsql.view.swing.tab.TabConsoles;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextAreaPlaceholderConsole;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.ui.CustomMetalTabbedPaneUI;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.OverlayLayout;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelConsoles
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private JavaConsoleAdapter javaTextPane = new JavaConsoleAdapter("Java", "Java unhandled exception");
    private JTextArea chunkTextArea;
    private JSplitPaneWithZeroSizeDivider networkSplitPane;
    private JTextArea binaryTextArea;
    private TabConsoles tabConsoles = new TabConsoles();
    private TabbedPaneNetworkTab tabbedPaneNetworkTab;
    private NetworkTable networkTable;
    private BasicArrowButton buttonShowNorth = new BasicArrowButton(1);
    private int location = 0;

    public PanelConsoles() {
        ((JTextPane)this.javaTextPane.getProxy()).setEditable(false);
        JTextPaneAppender.register(this.javaTextPane);
        this.initializeSplit();
        MediatorHelper.register(this.tabConsoles);
        this.initializeTabsConsoles();
        this.setLayout(new OverlayLayout(this));
        JPanel expandPanel = this.initializeExpandPanel();
        this.add(expandPanel);
        this.add(this.tabConsoles);
        expandPanel.setAlignmentX(4.0f);
        expandPanel.setAlignmentY(0.0f);
        this.tabConsoles.setAlignmentX(3.0f);
        this.tabConsoles.setAlignmentY(0.0f);
    }

    private void initializeSplit() {
        this.networkSplitPane = new JSplitPaneWithZeroSizeDivider(1);
        this.networkSplitPane.setResizeWeight(1.0);
        this.networkSplitPane.setDividerSize(0);
        this.networkSplitPane.setDividerLocation(600);
        this.networkSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPaneNetworkTab = new TabbedPaneNetworkTab();
        this.networkSplitPane.setRightComponent(this.tabbedPaneNetworkTab);
        this.networkTable = new NetworkTable(this.tabbedPaneNetworkTab);
        JScrollIndicator scrollerNetwork = this.initializeScrollerTable();
        this.networkSplitPane.setLeftComponent(scrollerNetwork);
    }

    private JScrollIndicator initializeScrollerTable() {
        JScrollIndicator scrollerNetwork = new JScrollIndicator(this.networkTable, 31);
        scrollerNetwork.getScrollPane().setBorder(BorderFactory.createEmptyBorder(0, 0, -1, -1));
        scrollerNetwork.getScrollPane().setViewportBorder(BorderFactory.createEmptyBorder(0, 0, -1, -1));
        AdjustmentListener singleItemScroll = adjustmentEvent -> {
            if (adjustmentEvent.getAdjustmentType() == 5) {
                adjustmentEvent.getAdjustable().setBlockIncrement(100);
                adjustmentEvent.getAdjustable().setUnitIncrement(100);
            }
        };
        scrollerNetwork.getScrollPane().getVerticalScrollBar().addAdjustmentListener(singleItemScroll);
        scrollerNetwork.getScrollPane().getHorizontalScrollBar().addAdjustmentListener(singleItemScroll);
        return scrollerNetwork;
    }

    private void initializeTabsConsoles() {
        this.chunkTextArea = (JTextArea)new JPopupTextArea(new JTextAreaPlaceholderConsole("Raw data extracted during injection")).getProxy();
        this.chunkTextArea.setEditable(false);
        this.binaryTextArea = (JTextArea)new JPopupTextArea(new JTextAreaPlaceholderConsole("Characters extracted during blind or time injection")).getProxy();
        this.binaryTextArea.setEditable(false);
        this.chunkTextArea.setLineWrap(true);
        this.binaryTextArea.setLineWrap(true);
        SimpleConsoleAdapter consoleTextPane = new SimpleConsoleAdapter("Console", "Event logging");
        ((JTextPane)consoleTextPane.getProxy()).setEditable(false);
        JTextPaneAppender.register(consoleTextPane);
        this.tabConsoles.setUI(new CustomMetalTabbedPaneUI(){

            @Override
            protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
                return Math.max(80, super.calculateTabWidth(tabPlacement, tabIndex, metrics));
            }
        });
        this.tabConsoles.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.buildI18nTab("CONSOLE_MAIN_LABEL", "CONSOLE_MAIN_TOOLTIP", UiUtil.ICON_CONSOLE, new LightScrollPane(1, 0, 0, 0, (JComponent)consoleTextPane.getProxy()), 0);
        Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        if (preferences.getBoolean("java_visible", false)) {
            this.insertJavaTab();
        }
        if (preferences.getBoolean("header_visible", true)) {
            this.insertNetworkTab();
        }
        if (preferences.getBoolean("chunk_visible", true)) {
            this.insertChunkTab();
        }
        if (preferences.getBoolean("binary_visible", true)) {
            this.insertBooleanTab();
        }
        this.tabConsoles.addChangeListener(changeEvent -> {
            Component currentTabHeader;
            TabConsoles tabs = this.tabConsoles;
            if (tabs.getSelectedIndex() > -1 && (currentTabHeader = tabs.getTabComponentAt(tabs.getSelectedIndex())) != null) {
                currentTabHeader.setFont(currentTabHeader.getFont().deriveFont(0));
                currentTabHeader.setForeground(Color.BLACK);
            }
        });
    }

    private JPanel initializeExpandPanel() {
        BasicArrowButton buttonShowSouth = new BasicArrowButton(5);
        buttonShowSouth.setName("buttonShowSouth");
        buttonShowSouth.setBorderPainted(false);
        buttonShowSouth.setPreferredSize(new Dimension(buttonShowSouth.getPreferredSize().width, buttonShowSouth.getPreferredSize().height));
        buttonShowSouth.setMaximumSize(buttonShowSouth.getPreferredSize());
        buttonShowSouth.setOpaque(false);
        buttonShowSouth.setBorder(BorderFactory.createEmptyBorder());
        buttonShowSouth.addActionListener(SplitHorizontalTopBottom.getActionHideShowConsole());
        this.buttonShowNorth.setBorderPainted(false);
        this.buttonShowNorth.setPreferredSize(new Dimension(this.buttonShowNorth.getPreferredSize().width, this.buttonShowNorth.getPreferredSize().height));
        this.buttonShowNorth.setMaximumSize(this.buttonShowNorth.getPreferredSize());
        this.buttonShowNorth.setOpaque(false);
        this.buttonShowNorth.setBorder(BorderFactory.createEmptyBorder());
        this.buttonShowNorth.addActionListener(SplitHorizontalTopBottom.getActionHideShowResult());
        this.buttonShowNorth.setName("buttonShowNorth");
        JPanel arrowDownPanel = new JPanel();
        arrowDownPanel.setLayout(new BorderLayout());
        arrowDownPanel.setOpaque(false);
        arrowDownPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        arrowDownPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 26));
        arrowDownPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 26));
        JPanel panelExpander = new JPanel(new BorderLayout());
        panelExpander.setBorder(BorderFactory.createEmptyBorder());
        panelExpander.add((Component)buttonShowSouth, "After");
        panelExpander.add((Component)this.buttonShowNorth, "Before");
        arrowDownPanel.add((Component)panelExpander, "After");
        return arrowDownPanel;
    }

    public void reset() {
        this.networkTable.getListHttpHeader().clear();
        this.getChunkTab().setText("");
        this.getBinaryTab().setText("");
        try {
            ((DefaultTableModel)this.networkTable.getModel()).setRowCount(0);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        ((JTextPane)this.javaTextPane.getProxy()).setText("");
        this.tabbedPaneNetworkTab.reset();
    }

    public void insertChunkTab() {
        this.buildI18nTab("CONSOLE_CHUNK_LABEL", "CONSOLE_CHUNK_TOOLTIP", UiUtil.ICON_CHUNK, new LightScrollPane(1, 0, 0, 0, this.chunkTextArea), 1);
    }

    public void insertBooleanTab() {
        this.buildI18nTab("CONSOLE_BINARY_LABEL", "CONSOLE_BINARY_TOOLTIP", UiUtil.ICON_BINARY, new LightScrollPane(1, 0, 0, 0, this.binaryTextArea), 1 + (MediatorHelper.menubar().getChunkMenu().isSelected() ? 1 : 0));
    }

    public void insertNetworkTab() {
        this.buildI18nTab("CONSOLE_NETWORK_LABEL", "CONSOLE_NETWORK_TOOLTIP", UiUtil.ICON_HEADER, new LightScrollPane(1, 0, 0, 0, this.networkSplitPane), this.tabConsoles.getTabCount() - (MediatorHelper.menubar().getJavaDebugMenu().isSelected() ? 1 : 0));
    }

    public void insertJavaTab() {
        this.buildI18nTab("CONSOLE_JAVA_LABEL", "CONSOLE_JAVA_TOOLTIP", UiUtil.ICON_CUP, new LightScrollPane(1, 0, 0, 0, (JComponent)this.javaTextPane.getProxy()), this.tabConsoles.getTabCount());
    }

    private void buildI18nTab(String keyLabel, final String keyTooltip, Icon icon, final Component manager, int position) {
        final JToolTipI18n[] refJToolTipI18n = new JToolTipI18n[]{new JToolTipI18n(I18nViewUtil.valueByKey(keyTooltip))};
        JLabel labelTab = new JLabel(I18nViewUtil.valueByKey(keyLabel), icon, 0){

            @Override
            public JToolTip createToolTip() {
                JToolTipI18n tipI18n;
                refJToolTipI18n[0] = tipI18n = new JToolTipI18n(I18nViewUtil.valueByKey(keyTooltip));
                return tipI18n;
            }
        };
        labelTab.setName(keyLabel);
        labelTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                try {
                    PanelConsoles.this.tabConsoles.setSelectedComponent(manager);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                }
                super.mousePressed(event);
            }
        });
        this.tabConsoles.insertTab(I18nViewUtil.valueByKey(keyLabel), icon, manager, null, position);
        this.tabConsoles.setTabComponentAt(this.tabConsoles.indexOfTab(I18nViewUtil.valueByKey(keyLabel)), labelTab);
        I18nViewUtil.addComponentForKey(keyLabel, labelTab);
        I18nViewUtil.addComponentForKey(keyTooltip, refJToolTipI18n[0]);
        labelTab.setToolTipText(I18nViewUtil.valueByKey(keyTooltip));
    }

    public void messageChunk(String text) {
        try {
            this.chunkTextArea.append(text + "\n");
            this.chunkTextArea.setCaretPosition(this.chunkTextArea.getDocument().getLength());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
    }

    public void messageBinary(String text) {
        try {
            this.binaryTextArea.append(String.format("\t%s", text));
            this.binaryTextArea.setCaretPosition(this.binaryTextArea.getDocument().getLength());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
    }

    public JTextArea getChunkTab() {
        return this.chunkTextArea;
    }

    public JSplitPaneWithZeroSizeDivider getNetworkSplitPane() {
        return this.networkSplitPane;
    }

    public JTextArea getBinaryTab() {
        return this.binaryTextArea;
    }

    public int getDividerLocation() {
        return this.location;
    }

    public void setDividerLocation(int location) {
        this.location = location;
    }

    public BasicArrowButton getButtonShowNorth() {
        return this.buttonShowNorth;
    }

    public NetworkTable getNetworkTable() {
        return this.networkTable;
    }
}

