/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.MenuActionExport;
import com.jsql.view.swing.list.MenuActionNewValue;
import com.jsql.view.swing.menubar.JMenuItemWithMargin;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.ComponentOrientation;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MouseAdapterMenuAction
extends MouseAdapter {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private DnDList dndList;

    public MouseAdapterMenuAction(DnDList dndList) {
        this.dndList = dndList;
    }

    public void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JList list = (JList)mouseEvent.getSource();
            JPopupMenu popupMenuList = this.initializeMenu(mouseEvent);
            popupMenuList.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()));
            try {
                popupMenuList.show(list, ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()) == ComponentOrientation.RIGHT_TO_LEFT ? mouseEvent.getX() - popupMenuList.getWidth() : mouseEvent.getX(), mouseEvent.getY());
            }
            catch (IllegalComponentStateException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
            popupMenuList.setLocation(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()) == ComponentOrientation.RIGHT_TO_LEFT ? mouseEvent.getXOnScreen() - popupMenuList.getWidth() : mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
        }
    }

    private JPopupMenu initializeMenu(MouseEvent mouseEvent) {
        JPopupMenu popupMenuList = new JPopupMenu();
        boolean isAsian = I18nUtil.isAsian(I18nUtil.getLocaleDefault());
        JMenuItemWithMargin mnImport = new JMenuItemWithMargin();
        JMenuItemWithMargin mnExport = new JMenuItemWithMargin();
        JMenuItemWithMargin mnCut = new JMenuItemWithMargin();
        JMenuItemWithMargin mnCopy = new JMenuItemWithMargin();
        JMenuItemWithMargin mnPaste = new JMenuItemWithMargin();
        JMenuItemWithMargin mnDelete = new JMenuItemWithMargin();
        JMenuItemWithMargin mnNew = new JMenuItemWithMargin();
        JMenuItemWithMargin mnRestoreDefault = new JMenuItemWithMargin();
        JMenuItemWithMargin mnSelectAll = new JMenuItemWithMargin();
        Stream.of(new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnImport, "LIST_IMPORT_CONFIRM_TITLE"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnExport, "LIST_EXPORT_TITLE"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnCut, "LIST_CUT"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnCopy, "CONTEXT_MENU_COPY"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnPaste, "LIST_PASTE"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnDelete, "LIST_DELETE"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnNew, "LIST_NEW_VALUE"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnRestoreDefault, "LIST_RESTORE_DEFAULT"), new AbstractMap.SimpleEntry<JMenuItemWithMargin, String>(mnSelectAll, "CONTEXT_MENU_SELECT_ALL")).forEach(entry -> {
            ((JMenuItem)entry.getKey()).setText(isAsian ? I18nViewUtil.valueByKey((String)entry.getValue()) : I18nUtil.valueByKey((String)entry.getValue()));
            I18nViewUtil.addComponentForKey((String)entry.getValue(), entry.getKey());
        });
        mnCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        mnCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        mnPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        mnSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        JFileChooser importFileDialog = new JFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile());
        importFileDialog.setDialogTitle(I18nUtil.valueByKey("LIST_IMPORT_CONFIRM_TITLE"));
        importFileDialog.setMultiSelectionEnabled(true);
        mnNew.addActionListener(new MenuActionNewValue(this.dndList));
        mnImport.addActionListener(actionEvent -> {
            int choice = 0;
            try {
                choice = importFileDialog.showOpenDialog(this.dndList.getTopLevelAncestor());
            }
            catch (ClassCastException | NullPointerException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
            if (choice == 0) {
                this.dndList.dropPasteFile(Arrays.asList(importFileDialog.getSelectedFiles()), this.dndList.locationToIndex(mouseEvent.getPoint()));
            }
        });
        mnCopy.addActionListener(actionEvent -> {
            Action action = this.dndList.getActionMap().get(TransferHandler.getCopyAction().getValue("Name"));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.dndList, 1001, null));
            }
        });
        mnCut.addActionListener(actionEvent -> {
            Action action = this.dndList.getActionMap().get(TransferHandler.getCutAction().getValue("Name"));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.dndList, 1001, null));
            }
        });
        mnPaste.addActionListener(actionEvent -> {
            Action action = this.dndList.getActionMap().get(TransferHandler.getPasteAction().getValue("Name"));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.dndList, 1001, null));
            }
        });
        mnDelete.addActionListener(actionEvent -> this.dndList.removeSelectedItem());
        mnExport.addActionListener(new MenuActionExport(this.dndList));
        mnRestoreDefault.addActionListener(actionEvent -> this.dndList.restore());
        mnSelectAll.addActionListener(actionEvent -> {
            int start = 0;
            int end = this.dndList.getModel().getSize() - 1;
            if (end >= 0) {
                this.dndList.setSelectionInterval(start, end);
            }
        });
        popupMenuList.add(mnNew);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(mnCut);
        popupMenuList.add(mnCopy);
        popupMenuList.add(mnPaste);
        popupMenuList.add(mnDelete);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(mnSelectAll);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(mnImport);
        popupMenuList.add(mnExport);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(mnRestoreDefault);
        return popupMenuList;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int clickIndex = this.dndList.locationToIndex(e.getPoint());
            boolean containsIndex = false;
            for (int currentIndex : this.dndList.getSelectedIndices()) {
                if (currentIndex != clickIndex) continue;
                containsIndex = true;
                break;
            }
            if (!containsIndex) {
                this.dndList.setSelectedIndex(clickIndex);
            }
        }
        this.showPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }
}

